/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.testopt.views.actions;

import com.atlassian.clover.optimization.OptimizationSession;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.junit.JUnitCore;
import org.eclipse.jdt.junit.TestRunListener;
import org.eclipse.jdt.junit.model.ITestRunSession;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.openclover.eclipse.testopt.OptimizationSessionListener;
import org.openclover.eclipse.testopt.TestOptimizationPlugin;
import org.openclover.eclipse.testopt.views.actions.OptimizationSessionIcon;

public class SavingsNotificationContributionItem
extends WorkbenchWindowControlContribution
implements OptimizationSessionListener {
    private OptimizationSession lastOptimizationSession;
    private boolean dirty = true;
    private OptimizationSessionIcon sessionIcon;
    private final TestRunListener testRunListener = new TestRunListener(){

        public void sessionStarted(final ITestRunSession isession) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TestRunSession session = (TestRunSession)isession;
                    SavingsNotificationContributionItem.this.dirty = true;
                    if (!"clover.optimized".equals(session.getLaunch().getLaunchMode())) {
                        SavingsNotificationContributionItem.this.sessionIcon.refresh(null);
                    }
                }
            });
        }
    };

    public SavingsNotificationContributionItem() {
        TestOptimizationPlugin.getDefault().addOptimizationSessionListener(this);
        JUnitCore.addTestRunListener((TestRunListener)this.testRunListener);
    }

    public void dispose() {
        super.dispose();
        TestOptimizationPlugin.getDefault().removeOptimizationSessionListener(this);
        JUnitCore.removeTestRunListener((TestRunListener)this.testRunListener);
    }

    protected Control createControl(Composite parent) {
        this.dirty = false;
        this.sessionIcon = new OptimizationSessionIcon(parent, this.lastOptimizationSession);
        return this.sessionIcon;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }

    @Override
    public void sessionFinished(final OptimizationSession session) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                SavingsNotificationContributionItem.this.lastOptimizationSession = session;
                SavingsNotificationContributionItem.this.dirty = true;
                SavingsNotificationContributionItem.this.sessionIcon.refresh(session);
            }
        });
    }
}

