/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.testopt.views.actions;

import com.atlassian.clover.optimization.Snapshot;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IStartup;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.views.actions.MultiCloverProjectActionDelegate;

public class ClearSnapshotActionDelegate
extends MultiCloverProjectActionDelegate
implements IStartup {
    protected boolean enableFor(IProject project) throws CoreException {
        File snapshot = ClearSnapshotActionDelegate.snapshotFor(project);
        return snapshot != null && snapshot.exists();
    }

    private static File snapshotFor(IProject project) throws CoreException {
        CloverProject cloverProject = CloverProject.getFor((IProject)project);
        return cloverProject != null ? Snapshot.fileForInitString((String)cloverProject.getRegistryFile().getAbsolutePath()) : null;
    }

    public void run(IAction action) {
        try {
            for (IProject project : this.projects) {
                File snapshot = ClearSnapshotActionDelegate.snapshotFor(project);
                if (snapshot == null || !snapshot.exists()) continue;
                snapshot.delete();
            }
        }
        catch (Exception e) {
            CloverPlugin.logError((String)"Unable to remove snapshot file", (Throwable)e);
        }
        this.updateStateForSelection(action);
    }

    public void earlyStartup() {
    }
}

