/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.testrunexplorer.nodes;

import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.Objects;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.swt.graphics.Image;
import org.openclover.eclipse.core.views.nodes.JavaElementNode;
import org.openclover.eclipse.core.views.nodes.Nodes;

public class TestCaseNode
extends JavaElementNode {
    public static final int STATUS_PASS = -1;
    public static final int STATUS_FAIL = 0;
    public static final int STATUS_ERROR = 1;
    private IMethod testMethod;
    private long tciId;
    private long startTime;
    private int status;
    private double durationInSeconds;
    private String failureMessage;
    private String fullFailureMessage;
    private Image testCaseIcon;

    public TestCaseNode(IMethod testMethod, TestCaseInfo tci) {
        this.testMethod = testMethod;
        this.tciId = tci.getId().intValue();
        this.startTime = tci.getStartTime();
        this.status = tci.isSuccess() ? -1 : (tci.isFailure() ? 0 : 1);
        this.durationInSeconds = tci.getDuration();
        this.failureMessage = tci.getFailMessage();
        this.fullFailureMessage = tci.getFailFullMessage();
        this.testCaseIcon = Nodes.iconFor(tci);
    }

    public IMethod getTestMethod() {
        return this.testMethod;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getStatus() {
        return this.status;
    }

    public double getDurationInSeconds() {
        return this.durationInSeconds;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public String getFullFailureMessage() {
        return this.fullFailureMessage;
    }

    public Image getTestCaseIcon() {
        return this.testCaseIcon;
    }

    @Override
    public IJavaElement toJavaElement() {
        return this.testMethod;
    }

    public long getTciId() {
        return this.tciId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestCaseNode that = (TestCaseNode)o;
        if (Double.compare(that.durationInSeconds, this.durationInSeconds) != 0) {
            return false;
        }
        if (this.startTime != that.startTime) {
            return false;
        }
        if (this.status != that.status) {
            return false;
        }
        if (this.tciId != that.tciId) {
            return false;
        }
        if (!Objects.equals(this.failureMessage, that.failureMessage)) {
            return false;
        }
        if (!Objects.equals(this.fullFailureMessage, that.fullFailureMessage)) {
            return false;
        }
        if (!Objects.equals(this.testCaseIcon, that.testCaseIcon)) {
            return false;
        }
        return Objects.equals(this.testMethod, that.testMethod);
    }

    public int hashCode() {
        int result = this.testMethod != null ? this.testMethod.hashCode() : 0;
        result = 31 * result + (int)(this.tciId ^ this.tciId >>> 32);
        result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
        result = 31 * result + this.status;
        result = 31 * result + (this.durationInSeconds != 0.0 ? (int)Double.doubleToLongBits(this.durationInSeconds) : 0);
        result = 31 * result + (this.failureMessage != null ? this.failureMessage.hashCode() : 0);
        result = 31 * result + (this.fullFailureMessage != null ? this.fullFailureMessage.hashCode() : 0);
        result = 31 * result + (this.testCaseIcon != null ? this.testCaseIcon.hashCode() : 0);
        return result;
    }
}

