/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.testrunexplorer;

import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.util.MetricsFormatUtils;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.views.BuiltinColumnDefinition;
import org.openclover.eclipse.core.views.CloveredWorkspaceProvider;
import org.openclover.eclipse.core.views.ColumnBuilder;
import org.openclover.eclipse.core.views.ColumnDefinition;
import org.openclover.eclipse.core.views.ExplorerView;
import org.openclover.eclipse.core.views.ExplorerViewLabelProvider;
import org.openclover.eclipse.core.views.ExplorerViewSettings;
import org.openclover.eclipse.core.views.TreeColumnControlListener;
import org.openclover.eclipse.core.views.testrunexplorer.ClassesTestedTreeComparator;
import org.openclover.eclipse.core.views.testrunexplorer.ClassesTestedTreeLabelProvider;
import org.openclover.eclipse.core.views.testrunexplorer.ClassesTestedTreeProvider;
import org.openclover.eclipse.core.views.testrunexplorer.TestCaseTreeProvider;
import org.openclover.eclipse.core.views.testrunexplorer.TestRunExplorerTreeComparator;
import org.openclover.eclipse.core.views.testrunexplorer.TestRunExplorerViewLabelProvider;
import org.openclover.eclipse.core.views.testrunexplorer.TestRunExplorerViewSettings;
import org.openclover.eclipse.core.views.testrunexplorer.nodes.CoverageContributionNode;
import org.openclover.eclipse.core.views.testrunexplorer.nodes.TestCaseNode;
import org.openclover.eclipse.core.views.testrunexplorer.nodes.TestCaseNodeFactory;
import org.openclover.eclipse.core.views.testrunexplorer.widgets.CoverageContributionCellRenderer;
import org.openclover.eclipse.core.views.testrunexplorer.widgets.TestStatusRenderer;
import org.openclover.eclipse.core.views.widgets.ColumnController;
import org.openclover.eclipse.core.views.widgets.ListeningRenderer;
import org.openclover.eclipse.core.views.widgets.SelectionAwareCellRenderer;
import org.openclover.util.Maps;

public class TestRunExplorerView
extends ExplorerView {
    public static final String ID = "org.openclover.eclipse.core.views.testrunexplorer";
    private static DateFormat TIME_FORMAT = DateFormat.getDateTimeInstance(3, 3);
    public static final ColumnDefinition TESTCASE_COL_ELEMENT = new BuiltinColumnDefinition("TestCaseElementName", 0, 16384, CloverEclipsePluginMessages.TEST_COL(), CloverEclipsePluginMessages.TEST_ABBREVIATED_COL(), CloverEclipsePluginMessages.TESTT_TOOL_TIP()){

        @Override
        public String getLabel(ExplorerViewSettings settings, MetricsScope scope, ILabelProvider delegate, Object element) {
            if (element instanceof TestCaseNode && settings.getHierarchyStyle() == 2) {
                IMethod method = ((TestCaseNode)element).getTestMethod();
                return method.getDeclaringType().getElementName() + "." + delegate.getText(element);
            }
            return delegate.getText(element);
        }

        @Override
        public Image getImage(ExplorerViewSettings settings, MetricsScope scope, ILabelProvider delegate, Object element) {
            if (element instanceof TestCaseNode) {
                return ((TestCaseNode)element).getTestCaseIcon();
            }
            return delegate.getImage(element);
        }

        @Override
        public boolean displaysSimpleLabel() {
            return true;
        }

        @Override
        public boolean displaysImage() {
            return true;
        }

        @Override
        public Comparator getComparator(ExplorerViewSettings settings, MetricsScope scope) {
            if (settings.getHierarchyStyle() == 2) {
                return TESTCASE_COL_ELEMENT_FLAT_NAME_COMPARATOR;
            }
            return TESTCASE_COL_ELEMENT_FULL_NAME_COMPARATOR;
        }
    };
    public static final Comparator TESTCASE_COL_ELEMENT_FLAT_NAME_COMPARATOR = new Comparator(){

        public int compare(Object object1, Object object2) {
            return TestRunExplorerTreeComparator.compareTestCaseName(object1, object2, true);
        }
    };
    public static final Comparator TESTCASE_COL_ELEMENT_FULL_NAME_COMPARATOR = new Comparator(){

        public int compare(Object object1, Object object2) {
            return TestRunExplorerTreeComparator.compareTestCaseName(object1, object2, false);
        }
    };
    public static final BuiltinColumnDefinition TESTCASE_COL_STARTED = new BuiltinColumnDefinition("TestCaseStarted", -1, 131072, CloverEclipsePluginMessages.TEST_STARTED_COL(), CloverEclipsePluginMessages.TEST_STARTED_ABBREVIATED_COL(), CloverEclipsePluginMessages.TEST_STARTED_COL_TOOL_TIP()){

        @Override
        public String getLabel(ExplorerViewSettings settings, MetricsScope scope, ILabelProvider delegate, Object element) {
            if (element instanceof TestCaseNode) {
                return TIME_FORMAT.format(new Date(((TestCaseNode)element).getStartTime()));
            }
            return "";
        }

        @Override
        public ListeningRenderer newRenderer(Composite composite, final ExplorerViewSettings viewSettings) {
            return new SelectionAwareCellRenderer(viewSettings.getTreeColumnSettings(), this, composite){

                @Override
                protected void paint(Event event) {
                    if (this.forThisColumn(event)) {
                        this.renderText(this.getLabel(viewSettings, viewSettings.getMetricsScope(), null, event.item.getData()), event.gc, event, event.display, 131072);
                    }
                }
            };
        }

        @Override
        public Comparator getComparator(ExplorerViewSettings settings, MetricsScope scope) {
            return TESTCASE_COL_STARTED_COMPARATOR;
        }
    };
    public static final Comparator TESTCASE_COL_STARTED_COMPARATOR = new Comparator(){

        public int compare(Object object1, Object object2) {
            return TestRunExplorerTreeComparator.compareStarted(object1, object2);
        }
    };
    public static final BuiltinColumnDefinition TESTCASE_COL_STATUS = new BuiltinColumnDefinition("TestCaseStatus", -1, 131072, CloverEclipsePluginMessages.TEST_STATUS_COL(), CloverEclipsePluginMessages.TEST_STATUS_ABBREVIATED_COL(), CloverEclipsePluginMessages.TEST_STATUS_COL_TOOL_TIP()){

        @Override
        public ListeningRenderer newRenderer(Composite composite, ExplorerViewSettings settings) {
            return new TestStatusRenderer((TestRunExplorerViewSettings)settings, this, composite);
        }

        @Override
        public String getLabel(ExplorerViewSettings settings, MetricsScope scope, ILabelProvider delegate, Object element) {
            return "";
        }

        @Override
        public Comparator getComparator(ExplorerViewSettings settings, MetricsScope scope) {
            return TESTCASE_COL_STATUS_COMPARATOR;
        }
    };
    public static final Comparator TESTCASE_COL_STATUS_COMPARATOR = new Comparator(){

        public int compare(Object object1, Object object2) {
            return TestRunExplorerTreeComparator.compareStatus(object1, object2);
        }
    };
    public static final BuiltinColumnDefinition TESTCASE_COL_TIME = new BuiltinColumnDefinition("TestCaseTime", -1, 131072, CloverEclipsePluginMessages.TEST_TIME_COL(), CloverEclipsePluginMessages.TEST_TIME_ABBREVIATED_COL(), CloverEclipsePluginMessages.TEST_TIME_COL_TOOL_TIP()){

        @Override
        public String getLabel(ExplorerViewSettings settings, MetricsScope scope, ILabelProvider delegate, Object element) {
            if (element instanceof TestCaseNode) {
                return ((TestCaseNode)element).getDurationInSeconds() + "s";
            }
            return "";
        }

        @Override
        public ListeningRenderer newRenderer(Composite composite, final ExplorerViewSettings viewSettings) {
            return new SelectionAwareCellRenderer(viewSettings.getTreeColumnSettings(), this, composite){

                @Override
                protected void paint(Event event) {
                    if (this.forThisColumn(event)) {
                        this.renderText(this.getLabel(viewSettings, viewSettings.getMetricsScope(), null, event.item.getData()), event.gc, event, event.display, 131072);
                    }
                }
            };
        }

        @Override
        public Comparator getComparator(ExplorerViewSettings settings, MetricsScope scope) {
            return TESTCASE_COL_TIME_COMPARATOR;
        }
    };
    public static final Comparator TESTCASE_COL_TIME_COMPARATOR = new Comparator(){

        public int compare(Object object1, Object object2) {
            return TestRunExplorerTreeComparator.compareTime(object1, object2);
        }
    };
    public static final BuiltinColumnDefinition TESTCASE_COL_MESSAGE = new BuiltinColumnDefinition("TestCaseMessage", -1, 16384, CloverEclipsePluginMessages.TEST_MESSAGE_COL(), CloverEclipsePluginMessages.TEST_MESSAGE_ABBREVIATED_COL(), CloverEclipsePluginMessages.TEST_MESSAGE_COL_TOOL_TIP()){

        @Override
        public String getLabel(ExplorerViewSettings settings, MetricsScope scope, ILabelProvider delegate, Object element) {
            TestCaseNode testCaseNode;
            if (element instanceof TestCaseNode && (testCaseNode = (TestCaseNode)element).getStatus() == 0 && testCaseNode.getFailureMessage() != null) {
                return testCaseNode.getFailureMessage();
            }
            return "";
        }

        @Override
        public boolean displaysSimpleLabel() {
            return false;
        }

        @Override
        public ListeningRenderer newRenderer(Composite composite, final ExplorerViewSettings viewSettings) {
            return new SelectionAwareCellRenderer(viewSettings.getTreeColumnSettings(), this, composite){

                @Override
                protected void paint(Event event) {
                    if (this.forThisColumn(event)) {
                        this.renderText(this.getLabel(viewSettings, viewSettings.getMetricsScope(), null, event.item.getData()), event.gc, event, event.display, 16384);
                    }
                }
            };
        }

        @Override
        public Comparator getComparator(ExplorerViewSettings settings, MetricsScope scope) {
            return TESTCASE_COL_MESSAGE_COMPARATOR;
        }
    };
    public static final Comparator TESTCASE_COL_MESSAGE_COMPARATOR = new Comparator(){

        public int compare(Object object1, Object object2) {
            return TestRunExplorerTreeComparator.compareMessage(object1, object2);
        }
    };
    public static final ColumnDefinition[] DEFAULT_TESTCASE_BUILTIN_COLUMN_DEFINITIONS = new ColumnDefinition[]{TESTCASE_COL_ELEMENT, TESTCASE_COL_STARTED, TESTCASE_COL_STATUS, TESTCASE_COL_TIME, TESTCASE_COL_MESSAGE};
    public static final ColumnDefinition[] TESTCASE_BUILTIN_COLUMN_DEFINITIONS = new ColumnDefinition[]{TESTCASE_COL_ELEMENT, TESTCASE_COL_STARTED, TESTCASE_COL_STATUS, TESTCASE_COL_TIME, TESTCASE_COL_MESSAGE};
    public static final ColumnDefinition CONTRIB_COL_CLASS = new BuiltinColumnDefinition("TestContribElementName", 0, 16384, "Class", "Class", "The name of the class coverage by the test case"){

        @Override
        public String getLabel(ExplorerViewSettings settings, MetricsScope scope, ILabelProvider delegate, Object element) {
            if (element instanceof CoverageContributionNode) {
                return ((CoverageContributionNode)element).getElement().getElementName();
            }
            return "";
        }

        @Override
        public Image getImage(ExplorerViewSettings settings, MetricsScope scope, ILabelProvider delegate, Object element) {
            return delegate.getImage(element);
        }

        @Override
        public ListeningRenderer newRenderer(Composite composite, ExplorerViewSettings settings) {
            return new SelectionAwareCellRenderer(((TestRunExplorerViewSettings)settings).getClassesTestedTreeSettings(), this, composite){};
        }

        @Override
        public boolean displaysSimpleLabel() {
            return true;
        }

        @Override
        public boolean displaysImage() {
            return true;
        }

        @Override
        public Comparator getComparator(ExplorerViewSettings settings, MetricsScope scope) {
            return CONTRIB_COL_CLASS_COMPARATOR;
        }
    };
    public static final Comparator CONTRIB_COL_CLASS_COMPARATOR = new Comparator(){

        public int compare(Object object1, Object object2) {
            return ClassesTestedTreeComparator.compareName(object1, object2);
        }
    };
    public static final ColumnDefinition CONTRIB_COL_CONTRIB = new BuiltinColumnDefinition("TestContribCoverage", -1, 16384, "Contributed Coverage%", "Contrib%", "Percentage of the class's total code coverage provided by the test case"){

        @Override
        public ListeningRenderer newRenderer(Composite composite, ExplorerViewSettings settings) {
            return new CoverageContributionCellRenderer((Tree)composite, ((TestRunExplorerViewSettings)settings).getClassesTestedTreeSettings(), (ColumnDefinition)this);
        }

        @Override
        public boolean displaysSimpleLabel() {
            return false;
        }

        @Override
        public boolean displaysImage() {
            return false;
        }

        @Override
        public String getLabel(ExplorerViewSettings settings, MetricsScope scope, ILabelProvider delegate, Object element) {
            return null;
        }

        @Override
        public Comparator getComparator(ExplorerViewSettings settings, MetricsScope scope) {
            return CONTRIB_COL_CONTRIB_COMPARATOR;
        }
    };
    public static final Comparator CONTRIB_COL_CONTRIB_COMPARATOR = new Comparator(){

        public int compare(Object object1, Object object2) {
            return ClassesTestedTreeComparator.compareContribCoverage(object1, object2);
        }
    };
    public static final ColumnDefinition CONTRIB_COL_UNIQUE = new BuiltinColumnDefinition("TestContribUniqueCoverage", -1, 131072, "Unique Coverage%", "Uniq%", "Percentage of the class's code coverage provided by the test case and by no other test case"){

        @Override
        public String getLabel(ExplorerViewSettings settings, MetricsScope scope, ILabelProvider delegate, Object element) {
            if (element instanceof CoverageContributionNode) {
                return MetricsFormatUtils.formatMetricsPercent(((CoverageContributionNode)element).getUnique());
            }
            return "";
        }

        @Override
        public ListeningRenderer newRenderer(Composite composite, final ExplorerViewSettings viewSettings) {
            return new SelectionAwareCellRenderer(((TestRunExplorerViewSettings)viewSettings).getClassesTestedTreeSettings(), this, composite){

                @Override
                protected void paint(Event event) {
                    if (this.forThisColumn(event)) {
                        this.renderText(this.getLabel(viewSettings, viewSettings.getMetricsScope(), null, event.item.getData()), event.gc, event, event.display, 131072);
                    }
                }
            };
        }

        @Override
        public Comparator getComparator(ExplorerViewSettings settings, MetricsScope scope) {
            return CONTRIB_COL_UNIQUE_COMPARATOR;
        }
    };
    public static final Comparator CONTRIB_COL_UNIQUE_COMPARATOR = new Comparator(){

        public int compare(Object object1, Object object2) {
            return ClassesTestedTreeComparator.compareUniqueCoverage(object1, object2);
        }
    };
    public static final ColumnDefinition[] DEFAULT_BUILTIN_CONTRIB_COLUMNS = new ColumnDefinition[]{CONTRIB_COL_CLASS, CONTRIB_COL_CONTRIB, CONTRIB_COL_UNIQUE};
    public static final ColumnDefinition[] ALL_BUILTIN_CONTRIB_COLUMNS = new ColumnDefinition[]{CONTRIB_COL_CLASS, CONTRIB_COL_CONTRIB, CONTRIB_COL_UNIQUE};
    private Tree classesTestedTree;
    private Map<ColumnDefinition, TreeColumn> classesTestedTreeColumns;
    private Map<TreeColumn, TreeColumnControlListener> classesTestedColumnListeners;
    private TreeViewer classesTestedTreeViewer;
    private ClassesTestedTreeProvider classesTestedTreeProvider;
    private ClassesTestedTreeLabelProvider classesTestedTreeLabelProvider;
    private TreeViewer coverageContribPaneViewer;
    private Composite explorerTreePane;
    private Map testCaseNodeCache;
    private ColumnController classesTestColumnController = new ColumnController(){

        @Override
        public void syncSorting() {
            TestRunExplorerView.this.updateClassesTestedSorter();
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.testCaseNodeCache = Collections.synchronizedMap(new WeakHashMap());
        this.settings = new TestRunExplorerViewSettings(memento, new TestCaseNodeFactory(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TestCaseNode newNode(TestCaseInfo tci, IMethod method) {
                Map map = TestRunExplorerView.this.testCaseNodeCache;
                synchronized (map) {
                    Integer hashCode = tci.hashCode();
                    TestCaseNode tcn = (TestCaseNode)TestRunExplorerView.this.testCaseNodeCache.get(hashCode);
                    if (tcn == null) {
                        tcn = new TestCaseNode(method, tci);
                        TestRunExplorerView.this.testCaseNodeCache.put(hashCode, tcn);
                    }
                    return tcn;
                }
            }
        });
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.settings.saveState(memento);
    }

    @Override
    protected void buildPartControl(Composite parent) {
        super.buildPartControl(parent);
        this.classesTestedTreeViewer.addDoubleClickListener((IDoubleClickListener)new ExplorerView.JavaElementDblClickListener(this.actions[0]){

            @Override
            protected void doEditorOpenAlternative(Object selected) {
            }
        });
    }

    @Override
    protected void buildTree() {
        this.explorerTreePane = new Composite((Composite)this.mainContent, 0);
        this.explorerTreePane.setLayout((Layout)new GridLayout(1, false));
        new Label(this.explorerTreePane, 0).setText("Tests run:");
        super.buildTree();
        this.tree.setLayoutData((Object)new GridData(1808));
    }

    @Override
    public int getAutoExpandLevel() {
        return 1;
    }

    @Override
    protected Composite getTreeParent() {
        return this.explorerTreePane;
    }

    @Override
    protected void buildRightHandSide() {
        Composite classesTestedPane = new Composite((Composite)this.mainContent, 0);
        classesTestedPane.setLayout((Layout)new GridLayout(1, false));
        new Label(classesTestedPane, 0).setText("Coverage Contribution:");
        this.classesTestedTree = new Tree(classesTestedPane, 0);
        this.classesTestedTree.setLayoutData((Object)new GridData(1808));
        this.classesTestedTree.setLinesVisible(true);
        this.classesTestedTree.setHeaderVisible(true);
        this.rebuildClassesTestedColumns();
        this.classesTestedTreeViewer = new TreeViewer(this.classesTestedTree);
        this.classesTestedTreeProvider = new ClassesTestedTreeProvider(this.classesTestedTreeViewer);
        this.classesTestedTreeViewer.setLabelProvider((IBaseLabelProvider)new ClassesTestedTreeLabelProvider(this.getSettings()));
        this.classesTestedTreeViewer.setContentProvider((IContentProvider)this.classesTestedTreeProvider);
        this.classesTestedTreeViewer.setAutoExpandLevel(-1);
        this.updateClassesTestedSorter();
        this.classesTestedTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (event.data instanceof CoverageContributionNode) {
                    TestRunExplorerView.this.actions[0].run((IStructuredSelection)new StructuredSelection());
                }
            }
        });
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.classesTestedTreeProvider);
        this.updateMainContentSashOrientation(this.calcViewOrientation());
    }

    /*
     * WARNING - void declaration
     */
    private void rebuildClassesTestedColumns() {
        if (this.classesTestedTreeColumns != null) {
            for (Map.Entry<TreeColumn, TreeColumnControlListener> entry : this.classesTestedColumnListeners.entrySet()) {
                TreeColumn treeColumn = entry.getKey();
                TreeColumnControlListener listener = entry.getValue();
                treeColumn.removeControlListener((ControlListener)listener);
                treeColumn.removeSelectionListener((SelectionListener)listener);
            }
            for (Map.Entry<Object, TreeColumnControlListener> entry : this.columns.entrySet()) {
                this.unbuildClassesTestedTreeColumn((ColumnDefinition)entry.getKey(), (TreeColumn)entry.getValue());
            }
        }
        this.classesTestedColumnListeners = Maps.newHashMap();
        this.classesTestedTreeColumns = Maps.newLinkedHashMap();
        Map<ColumnDefinition, Integer> columnToWidths = this.getSettings().getClassesTestedTreeSettings().getVisibleColumnsToWidths();
        for (Map.Entry<ColumnDefinition, Integer> entry : columnToWidths.entrySet()) {
            this.buildClassesTestedTreeColumn(entry.getKey(), entry.getValue());
        }
        boolean bl = false;
        for (Map.Entry<ColumnDefinition, TreeColumn> entry : this.classesTestedTreeColumns.entrySet()) {
            void var2_7;
            ColumnDefinition columnDef = entry.getKey();
            TreeColumn column = entry.getValue();
            TreeColumnControlListener listener = new TreeColumnControlListener(this.classesTestColumnController, this.treeColumnLabeler, this.classesTestedTreeViewer, this.getSettings().getClassesTestedTreeSettings(), column, (int)(++var2_7), columnDef);
            column.addControlListener((ControlListener)listener);
            column.addSelectionListener((SelectionListener)listener);
            columnDef.bindRenderer((Composite)this.classesTestedTree, this.getSettings());
        }
    }

    private void buildClassesTestedTreeColumn(ColumnDefinition columnDefinition, Integer width) {
        TreeColumn column = ColumnBuilder.buildTreeColumn(columnDefinition, this.classesTestedTree, this.treeColumnLabeler);
        column.setWidth(width.intValue());
        columnDefinition.bindRenderer((Composite)this.classesTestedTree, this.settings);
        this.classesTestedTreeColumns.put(columnDefinition, column);
    }

    protected void unbuildClassesTestedTreeColumn(ColumnDefinition columnDefinition, TreeColumn column) {
        columnDefinition.unbindRenderer((Composite)column.getParent());
        column.dispose();
    }

    @Override
    protected void updateMainContentSashOrientation(int viewOrientation) {
        super.updateMainContentSashOrientation(viewOrientation);
        switch (viewOrientation) {
            case 512: {
                this.mainContent.setWeights(new int[]{1, 1});
                break;
            }
            default: {
                this.mainContent.setWeights(new int[]{4, 3});
            }
        }
    }

    @Override
    protected CloveredWorkspaceProvider newContentProvider() {
        return new TestCaseTreeProvider(this, this.getSettings());
    }

    @Override
    protected ExplorerViewLabelProvider newLabelProvider() {
        return new TestRunExplorerViewLabelProvider(this.getSettings());
    }

    @Override
    protected ViewerComparator newTreeViewComparator() {
        return TestRunExplorerTreeComparator.createFor(this.getSettings());
    }

    private TestRunExplorerViewSettings getSettings() {
        return (TestRunExplorerViewSettings)this.settings;
    }

    @Override
    protected TreeViewer buildSelectionProvider() {
        return this.treeViewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRefreshWorkFor(IProject[] projects) {
        this.testCaseNodeCache.clear();
        if (!this.tree.isDisposed()) {
            Object treePaths = null;
            ISelection selection = this.treeViewer.getSelection();
            this.treeViewer.getControl().setRedraw(false);
            try {
                this.treeViewer.refresh(null);
            }
            finally {
                this.treeViewer.getControl().setRedraw(true);
            }
            this.treeViewer.setSelection(selection);
        }
    }

    private void updateClassesTestedSorter() {
        this.classesTestedTreeViewer.getControl().setRedraw(false);
        try {
            this.classesTestedTree.setSortColumn(this.classesTestedTreeColumns.get(this.getSettings().getClassesTestedTreeSettings().getSortedColumn()));
            this.classesTestedTree.setSortDirection(this.getSettings().getClassesTestedTreeSettings().isReverseSort() ? 128 : 1024);
            this.classesTestedTreeViewer.setComparator(ClassesTestedTreeComparator.getFor(this.getSettings().getClassesTestedTreeSettings()));
        }
        finally {
            this.classesTestedTreeViewer.getControl().setRedraw(true);
        }
    }

    public ColumnDefinition[] getBuiltinColumnDefinitions() {
        return TESTCASE_BUILTIN_COLUMN_DEFINITIONS;
    }

    @Override
    protected void buildToolbarStructure() {
        IToolBarManager toolbarMenuManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarMenuManager.add((IContributionItem)new Separator("project.ops"));
        toolbarMenuManager.add((IContributionItem)new Separator());
        toolbarMenuManager.add((IContributionItem)new Separator("project.reports"));
        toolbarMenuManager.add((IAction)this.generateReportAction);
        toolbarMenuManager.add((IContributionItem)new Separator());
        toolbarMenuManager.add((IContributionItem)new Separator("view.hierarchy"));
        toolbarMenuManager.add((IContributionItem)new Separator());
        toolbarMenuManager.add((IContributionItem)new Separator("view.columns"));
        toolbarMenuManager.add((IContributionItem)new Separator());
        toolbarMenuManager.add((IContributionItem)new Separator("editor.ops"));
        toolbarMenuManager.add((IContributionItem)new Separator());
        toolbarMenuManager.add((IContributionItem)new Separator("additions"));
    }

    @Override
    protected void buildMenubarStructure() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IContributionItem)new Separator("project.ops"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("project.reports"));
        menuManager.add((IAction)this.generateReportAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("view.coverage.ops.menu"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("view.hierarchy.menu"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("view.columns"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("editor.ops.menu"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("additions"));
    }
}

