/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.testcontributions;

import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.views.testcontributions.LineTestContributionsComputation;
import org.openclover.eclipse.core.views.testcontributions.TestContributionsComputation;
import org.openclover.eclipse.core.views.testcontributions.TestContributionsWidget;
import org.openclover.eclipse.core.views.testcontributions.TestContributionsWidgetSettings;

public class LineTestContributionsWidget
extends TestContributionsWidget {
    private static final int SYNC_DELAY_MS = 1500;

    public LineTestContributionsWidget(Settings settings, ViewPart viewPart, Composite parent, int style, int treeStyle, boolean showLabel) {
        super(settings, viewPart, parent, style, showLabel, treeStyle);
    }

    @Override
    protected TreeViewer createTreeViewer() {
        return new TreeViewer(this.tree);
    }

    @Override
    protected TestContributionsComputation createContributionsComputation() {
        final LineTestContributionsComputation testContributionsComputation = new LineTestContributionsComputation();
        testContributionsComputation.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().getSeverity() != 8) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (LineTestContributionsWidget.this.testsViewer.getContentProvider() != null && testContributionsComputation != null && LineTestContributionsWidget.this.viewPart.getViewSite().getPage().isPartVisible((IWorkbenchPart)LineTestContributionsWidget.this.viewPart)) {
                                    if (testContributionsComputation.isInputChanged()) {
                                        LineTestContributionsWidget.this.testsViewer.setInput((Object)testContributionsComputation);
                                    }
                                    testContributionsComputation.prime(LineTestContributionsWidget.this.editor);
                                }
                            }
                            catch (Exception e) {
                                CloverPlugin.logError("Unable to update line-based test contributions", e);
                            }
                        }
                    });
                    testContributionsComputation.schedule(1500L);
                }
            }
        });
        return testContributionsComputation;
    }

    @Override
    protected String getLabelTitle() {
        return "Contributing tests at cursor:";
    }

    public void startTrackingEditor() {
        this.testContributionsComputation.prime(this.editor);
        this.testContributionsComputation.schedule(1500L);
    }

    public void stopTrackingEditor() {
        this.testContributionsComputation.cancel();
        try {
            this.testContributionsComputation.join();
        }
        catch (InterruptedException e) {
            CloverPlugin.logError("Failed to stop cursor listing job");
        }
    }

    public void dispose() {
        super.dispose();
        this.stopTrackingEditor();
    }

    public static class Settings
    extends TestContributionsWidgetSettings {
        public Settings(IMemento memento) {
            super(memento);
        }

        public Settings() {
        }

        @Override
        public String prefix(String base) {
            return "line.";
        }
    }
}

