/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.testcontributions;

import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.ui.editors.java.CoverageAnnotationFilter;
import org.openclover.eclipse.core.ui.editors.java.CoverageAnnotationModel;
import org.openclover.eclipse.core.views.testcontributions.AllTestCaseInfoLabelProvider;
import org.openclover.eclipse.core.views.testcontributions.AllTestCaseInfoProvider;
import org.openclover.eclipse.core.views.testcontributions.AllTestContributionsComputation;
import org.openclover.eclipse.core.views.testcontributions.TestCaseInfoLabelProvider;
import org.openclover.eclipse.core.views.testcontributions.TestCaseInfoProvider;
import org.openclover.eclipse.core.views.testcontributions.TestContributionsComputation;
import org.openclover.eclipse.core.views.testcontributions.TestContributionsWidget;
import org.openclover.eclipse.core.views.testcontributions.TestContributionsWidgetSettings;
import org.openclover.util.Sets;

public class AllTestContributionsFilterWidget
extends TestContributionsWidget
implements ICheckStateListener {
    private static final int SYNC_DELAY_MS = 1500;

    public AllTestContributionsFilterWidget(Settings settings, ViewPart viewPart, Composite parent, int style, int treeStyle, boolean showLabel) {
        super(settings, viewPart, parent, style, showLabel, treeStyle);
        this.getTestsViewer().addCheckStateListener((ICheckStateListener)this);
    }

    @Override
    protected TestCaseInfoProvider createProvider() {
        return new AllTestCaseInfoProvider();
    }

    @Override
    protected TestCaseInfoLabelProvider createLabelProvider() {
        return new AllTestCaseInfoLabelProvider();
    }

    @Override
    protected TestContributionsComputation createContributionsComputation() {
        final AllTestContributionsComputation testContributionsComputation = new AllTestContributionsComputation();
        testContributionsComputation.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().getSeverity() != 8) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (AllTestContributionsFilterWidget.this.getTestsViewer().getContentProvider() != null) {
                                if (!AllTestContributionsFilterWidget.this.viewPart.getViewSite().getPage().isPartVisible((IWorkbenchPart)AllTestContributionsFilterWidget.this.viewPart)) {
                                    testContributionsComputation.prime(null);
                                } else {
                                    if (testContributionsComputation.isInputChanged()) {
                                        AllTestContributionsFilterWidget.this.getTestsViewer().setInput((Object)testContributionsComputation);
                                        Set checkedElements = testContributionsComputation.getCheckedTestCasesAndClasses();
                                        if (checkedElements.size() == 1 && checkedElements.iterator().next() == AllTestCaseInfoProvider.ALL_TEST_CASES) {
                                            AllTestContributionsFilterWidget.this.getTestsViewer().setGrayChecked(AllTestCaseInfoProvider.ALL_TEST_CASES, true);
                                        } else {
                                            AllTestContributionsFilterWidget.this.getTestsViewer().setGrayChecked(AllTestCaseInfoProvider.ALL_TEST_CASES, false);
                                            AllTestContributionsFilterWidget.this.getTestsViewer().setCheckedElements(checkedElements.toArray());
                                        }
                                    }
                                    testContributionsComputation.prime(AllTestContributionsFilterWidget.this.editor);
                                }
                            }
                        }
                    });
                    testContributionsComputation.schedule(1500L);
                }
            }
        });
        return testContributionsComputation;
    }

    @Override
    protected TreeViewer createTreeViewer() {
        return new CheckboxTreeViewer(this.tree);
    }

    @Override
    protected void createTree(int treeStyle) {
        super.createTree(treeStyle | 0x20);
    }

    @Override
    protected String getLabelTitle() {
        return "All contributing tests:";
    }

    public void startTrackingEditor() {
        this.testContributionsComputation.prime(this.editor);
        this.testContributionsComputation.schedule(1500L);
    }

    public void stopTrackingEditor() {
        this.testContributionsComputation.cancel();
        try {
            this.testContributionsComputation.join();
        }
        catch (InterruptedException e) {
            CloverPlugin.logError("Failed to stop cursor listing job");
        }
    }

    public void dispose() {
        super.dispose();
        this.stopTrackingEditor();
    }

    public Tree getTree() {
        return this.tree;
    }

    private CheckboxTreeViewer getTestsViewer() {
        return (CheckboxTreeViewer)this.testsViewer;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        CoverageAnnotationModel model = CoverageAnnotationModel.getModel(this.editor);
        if (model != null) {
            this.setCheckedFrom(event);
            this.updateGrayedOut();
            model.setExcludedTests(this.calculateFilter());
        }
    }

    private void setCheckedFrom(CheckStateChangedEvent event) {
        Set<TestCaseInfo> allTestCases = this.provider.getAllTests();
        if (event.getElement() == AllTestCaseInfoProvider.ALL_TEST_CASES) {
            HashSet<ClassInfo> classes = Sets.newHashSet();
            boolean grayed = this.getTestsViewer().getGrayed(event.getElement());
            for (ClassInfo aClass : classes) {
                this.getTestsViewer().setChecked((Object)aClass, !grayed);
            }
            for (TestCaseInfo testCase : allTestCases) {
                classes.add(testCase.getRuntimeType());
                if (event.getChecked()) {
                    this.getTestsViewer().setChecked((Object)testCase, !grayed);
                    continue;
                }
                this.getTestsViewer().setChecked((Object)testCase, grayed);
            }
        } else if (event.getElement() instanceof ClassInfo) {
            ClassInfo classInfo = (ClassInfo)event.getElement();
            boolean grayed = this.getTestsViewer().getGrayed(event.getElement());
            for (TestCaseInfo testCase : allTestCases) {
                if (testCase.getRuntimeType() != classInfo) continue;
                if (event.getChecked()) {
                    this.getTestsViewer().setChecked((Object)testCase, !grayed);
                    continue;
                }
                this.getTestsViewer().setChecked((Object)testCase, grayed);
            }
        } else if (event.getElement() instanceof TestCaseInfo) {
            TestCaseInfo testCase = (TestCaseInfo)event.getElement();
            if (event.getChecked()) {
                this.getTestsViewer().setChecked((Object)testCase, true);
            } else {
                this.getTestsViewer().setChecked((Object)testCase, false);
            }
        }
    }

    private void updateGrayedOut() {
        TreeItem[] items;
        for (TreeItem item : items = this.tree.getItems()) {
            this.grayOut(item);
        }
    }

    private TreeItemState grayOut(TreeItem item) {
        TreeItem[] items = item.getItems();
        if (items.length > 0) {
            TreeItemState state = null;
            for (TreeItem item1 : items) {
                state = this.grayOut(item1).and(state);
            }
            state.applyOn(item);
            return state;
        }
        return TreeItemState.getFor(item);
    }

    private CoverageAnnotationFilter.TestFilter calculateFilter() {
        CoverageAnnotationFilter.TestFilter filter = new CoverageAnnotationFilter.TestFilter();
        for (TreeItem item : this.tree.getItems()) {
            this.calculateFilter(filter, item);
        }
        return filter;
    }

    private CoverageAnnotationFilter.TestFilter calculateFilter(CoverageAnnotationFilter.TestFilter filter, TreeItem treeItem) {
        TreeItem[] items;
        for (TreeItem item : items = treeItem.getItems()) {
            if (item.getData() instanceof ClassInfo) {
                if (!item.getChecked() && !item.getGrayed()) {
                    filter.addTestClass((ClassInfo)item.getData());
                    continue;
                }
                this.calculateFilter(filter, item);
                continue;
            }
            if (item.getData() instanceof TestCaseInfo) {
                if (item.getChecked()) continue;
                filter.addTestCase((TestCaseInfo)item.getData());
                continue;
            }
            this.calculateFilter(filter, item);
        }
        return filter;
    }

    public static class Settings
    extends TestContributionsWidgetSettings {
        public Settings(IMemento memento) {
            super(memento);
        }

        public Settings() {
        }

        @Override
        public String prefix(String base) {
            return "all.";
        }
    }

    private static class TreeItemState {
        private static final TreeItemState CHECKED = new TreeItemState();
        private static final TreeItemState UNCHECKED = new TreeItemState();
        private static final TreeItemState GRAYED = new TreeItemState();

        private TreeItemState() {
        }

        public TreeItemState and(TreeItemState other) {
            return other == null ? this : (this == CHECKED && other == CHECKED ? CHECKED : (this == UNCHECKED && other == UNCHECKED ? UNCHECKED : GRAYED));
        }

        public void applyOn(TreeItem item) {
            if (this == CHECKED) {
                item.setChecked(true);
                item.setGrayed(false);
            } else if (this == UNCHECKED) {
                item.setChecked(false);
                item.setGrayed(false);
            } else {
                item.setChecked(true);
                item.setGrayed(true);
            }
        }

        public static TreeItemState getFor(TreeItem item) {
            if (item.getGrayed()) {
                return GRAYED;
            }
            return item.getChecked() ? CHECKED : UNCHECKED;
        }
    }
}

