/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.nodes;

import java.util.ArrayList;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.views.nodes.NodeRelationship;
import org.openclover.eclipse.core.views.nodes.NodeRelationshipFilter;

public class PkgFragRootToPkgFragRelationship
extends NodeRelationship {
    @Override
    public Object[] getChildren(Object object, NodeRelationshipFilter filter) {
        try {
            IPackageFragmentRoot root = (IPackageFragmentRoot)object;
            IJavaElement[] children = root.getChildren();
            ArrayList<IPackageFragment> packageFragments = new ArrayList<IPackageFragment>(children.length);
            for (IJavaElement child : children) {
                if (!(child instanceof IPackageFragment) || ((IPackageFragment)child).getCompilationUnits().length <= 0) continue;
                packageFragments.add((IPackageFragment)child);
            }
            return filter.perform(packageFragments);
        }
        catch (Exception e) {
            CloverPlugin.logError("Unable to retrieve children for package fragment " + object, e);
            return new Object[0];
        }
    }

    @Override
    public Boolean hasChildren(Object object, NodeRelationshipFilter filter) {
        try {
            IJavaElement[] children;
            IPackageFragmentRoot root = (IPackageFragmentRoot)object;
            for (IJavaElement child : children = root.getChildren()) {
                if (!(child instanceof IPackageFragment) || ((IPackageFragment)child).getCompilationUnits().length <= 0 || !filter.accept(child)) continue;
                return true;
            }
        }
        catch (Exception e) {
            CloverPlugin.logError("Unable to retrieve children for package fragment " + object, e);
        }
        return false;
    }

    @Override
    public boolean includes(Object object) {
        return object instanceof IPackageFragmentRoot;
    }
}

