/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.nodes;

import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.registry.metrics.HasMetricsNode;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.swt.graphics.Image;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.model.JavaElementAdapter;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.views.nodes.LeafPackageFragmentNode;
import org.openclover.eclipse.core.views.nodes.TreePackageFragmentNode;
import org.openclover.eclipse.core.views.testrunexplorer.nodes.TestCaseNode;
import org.openclover.eclipse.core.views.testrunexplorer.nodes.TestCaseNodeFactory;
import org.openclover.util.Lists;

public class Nodes {
    public static final TestCaseConverter TO_TESTCASEINFO = new TestCaseConverter(){

        @Override
        public Object convert(TestCaseInfo tci, IMethod method) {
            return tci;
        }
    };
    public static final TestCaseConverter TO_IMETHOD = new TestCaseConverter(){

        @Override
        public Object convert(TestCaseInfo tci, IMethod method) {
            return method;
        }
    };
    public static final TypeCondition CONTAINS_TEST_CASE = new TypeCondition(){

        @Override
        public boolean evaluate(IType type) throws CoreException {
            FullClassInfo classInfo = (FullClassInfo)MetricsScope.TEST_ONLY.getHasMetricsFor(type, FullClassInfo.class);
            if (classInfo != null && classInfo.isTestClass()) {
                IType[] types;
                if (classInfo.getTestCases().size() > 0) {
                    return true;
                }
                for (IType t : types = type.getTypes()) {
                    if (!this.evaluate(t)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Inference inferFor(IProject element) throws CoreException {
            CloverProject cloverProject = CloverProject.getFor(element);
            FullProjectInfo project = cloverProject == null ? null : MetricsScope.TEST_ONLY.getProjectInfoFor(cloverProject);
            return project == null || !project.hasTestResults() ? Inference.FALSE : Inference.TRUE;
        }
    };
    public static final TypeCondition IS_TEST_CLASS_CONTAINER = new TypeCondition(){

        @Override
        public boolean evaluate(IType type) throws CoreException {
            return MetricsScope.TEST_ONLY.getHasMetricsFor(type, FullClassInfo.class) != null;
        }

        @Override
        public Inference inferFor(IProject element) throws CoreException {
            CloverProject cloverProject = CloverProject.getFor(element);
            FullProjectInfo project = cloverProject == null ? null : MetricsScope.TEST_ONLY.getProjectInfoFor(cloverProject);
            return project == null || project.isEmpty() ? Inference.FALSE : Inference.TRUE;
        }

        @Override
        public Inference inferFor(IPackageFragment element) throws CoreException {
            CloverProject cloverProject = CloverProject.getFor(element.getJavaProject());
            HasMetrics hasMetrics = cloverProject == null ? null : MetricsScope.TEST_ONLY.getHasMetricsFor(element);
            HasMetricsNode hasMetricsNode = hasMetrics instanceof HasMetricsNode ? (HasMetricsNode)hasMetrics : null;
            return hasMetricsNode == null || hasMetricsNode.isEmpty() ? Inference.FALSE : Inference.TRUE;
        }
    };
    private static final TypeCondition IS_APP_CLASS_CONTAINER = new TypeCondition(){

        @Override
        public boolean evaluate(IType type) throws CoreException {
            return MetricsScope.APP_ONLY.getHasMetricsFor(type, FullClassInfo.class) != null;
        }

        @Override
        public Inference inferFor(IProject element) throws CoreException {
            CloverProject cloverProject = CloverProject.getFor(element);
            FullProjectInfo project = cloverProject == null ? null : MetricsScope.APP_ONLY.getProjectInfoFor(cloverProject);
            return project == null || project.isEmpty() ? Inference.FALSE : Inference.TRUE;
        }

        @Override
        public Inference inferFor(IPackageFragment element) throws CoreException {
            CloverProject cloverProject = CloverProject.getFor(element.getJavaProject());
            HasMetrics hasMetrics = cloverProject == null ? null : MetricsScope.APP_ONLY.getHasMetricsFor(element);
            HasMetricsNode hasMetricsNode = hasMetrics instanceof HasMetricsNode ? (HasMetricsNode)hasMetrics : null;
            return hasMetricsNode == null || hasMetricsNode.isEmpty() ? Inference.FALSE : Inference.TRUE;
        }
    };

    public static List collectTestCases(Object mysteryMeat, TestCaseConverter converter) throws CoreException {
        LinkedList testCases = Lists.newLinkedList();
        if (mysteryMeat instanceof IProject) {
            CloverProject cloverProject = CloverProject.getFor((IProject)mysteryMeat);
            if (cloverProject != null) {
                return Nodes.collectTestCases(cloverProject.getJavaProject(), testCases, converter);
            }
        } else {
            if (mysteryMeat instanceof IJavaProject) {
                return Nodes.collectTestCases((IJavaProject)mysteryMeat, testCases, converter);
            }
            if (mysteryMeat instanceof IPackageFragmentRoot) {
                return Nodes.collectTestCases((IPackageFragmentRoot)mysteryMeat, testCases, converter);
            }
            if (mysteryMeat instanceof IPackageFragment) {
                return Nodes.collectTestCases((IPackageFragment)mysteryMeat, testCases, converter);
            }
            if (mysteryMeat instanceof LeafPackageFragmentNode) {
                return Nodes.collectTestCases((LeafPackageFragmentNode)mysteryMeat, testCases, converter);
            }
            if (mysteryMeat instanceof TreePackageFragmentNode) {
                return Nodes.collectTestCases((TreePackageFragmentNode)mysteryMeat, testCases, converter);
            }
            if (mysteryMeat instanceof ICompilationUnit) {
                return Nodes.collectTestCases((ICompilationUnit)mysteryMeat, testCases, converter);
            }
            if (mysteryMeat instanceof IType) {
                return Nodes.collectTestCases((IType)mysteryMeat, testCases, converter);
            }
            if (mysteryMeat instanceof IMethod) {
                return Nodes.collectTestCases((IMethod)mysteryMeat, testCases, converter);
            }
            if (mysteryMeat instanceof TestCaseNode) {
                return Nodes.collectTestCases((TestCaseNode)mysteryMeat, testCases, converter);
            }
        }
        return testCases;
    }

    private static List collectTestCases(LeafPackageFragmentNode leafPackageFragmentNode, List testCases, TestCaseConverter converter) throws CoreException {
        Set<IPackageFragment> packageFragments = leafPackageFragmentNode.getPackageFragments();
        for (IPackageFragment packageFragment : packageFragments) {
            Nodes.collectTestCases(packageFragment, testCases, converter);
        }
        return testCases;
    }

    private static List collectTestCases(TreePackageFragmentNode treePackageFragmentNode, List testCases, TestCaseConverter converter) throws CoreException {
        IPackageFragment packageFragment = (IPackageFragment)treePackageFragmentNode.toJavaElement();
        packageFragment = packageFragment instanceof JavaElementAdapter ? (IPackageFragment)((JavaElementAdapter)packageFragment).getAdaptee() : packageFragment;
        Nodes.collectTestCases(packageFragment, testCases, converter);
        if (!packageFragment.isDefaultPackage()) {
            IJavaElement[] packages;
            for (IJavaElement aPackage : packages = ((IPackageFragmentRoot)packageFragment.getParent()).getChildren()) {
                if (!(aPackage instanceof IPackageFragment) || aPackage.getElementName().indexOf(packageFragment.getElementName() + ".") != 0) continue;
                Nodes.collectTestCases((IPackageFragment)aPackage, testCases, converter);
            }
        }
        return testCases;
    }

    public static List collectTestCases(IJavaProject project, List testCases, TestCaseConverter converter) throws CoreException {
        CloverProject cloverProject = CloverProject.getFor(project);
        FullProjectInfo projectInfo = cloverProject.getModel().getTestOnlyProjectInfo();
        if (projectInfo != null && projectInfo.hasTestResults()) {
            IPackageFragmentRoot[] roots;
            for (IPackageFragmentRoot root : roots = project.getPackageFragmentRoots()) {
                if (root.getKind() != 1) continue;
                Nodes.collectTestCases(root, testCases, converter);
            }
        }
        return testCases;
    }

    public static List collectTestCases(IProject project, List testCases, TestCaseConverter converter) throws CoreException {
        CloverProject cloverProject = CloverProject.getFor(project);
        if (cloverProject != null) {
            return Nodes.collectTestCases(cloverProject.getJavaProject(), testCases, converter);
        }
        return testCases;
    }

    public static List collectTestCases(IPackageFragmentRoot root, List testCases, TestCaseConverter converter) throws CoreException {
        IJavaElement[] children;
        for (IJavaElement child : children = root.getChildren()) {
            if (!(child instanceof IPackageFragment)) continue;
            Nodes.collectTestCases((IPackageFragment)child, testCases, converter);
        }
        return testCases;
    }

    public static List collectTestCases(IPackageFragment packageFragment, List testCases, TestCaseConverter converter) throws CoreException {
        ICompilationUnit[] cus;
        for (ICompilationUnit cu : cus = packageFragment.getCompilationUnits()) {
            Nodes.collectTestCases(cu, testCases, converter);
        }
        return testCases;
    }

    public static List collectTestCases(ICompilationUnit cu, List testCases, TestCaseConverter converter) throws CoreException {
        IType[] types;
        for (IType type : types = cu.getTypes()) {
            Nodes.collectTestCases(type, testCases, converter);
        }
        return testCases;
    }

    public static List collectTestCases(IType type, List testCases, TestCaseConverter converter) throws CoreException {
        FullClassInfo classInfo = (FullClassInfo)MetricsScope.TEST_ONLY.getHasMetricsFor(type, FullClassInfo.class);
        if (classInfo != null && classInfo.isTestClass()) {
            IType[] innerTypes;
            IMethod[] methods;
            for (IMethod method : methods = type.getMethods()) {
                Nodes.collectTestCases(method, testCases, converter);
            }
            for (IType innerType : innerTypes = type.getTypes()) {
                Nodes.collectTestCases(innerType, testCases, converter);
            }
        }
        return testCases;
    }

    public static List collectTestCases(IMethod method, List testCases, TestCaseConverter converter) {
        TestCaseInfo[] tcis = MetricsScope.TEST_ONLY.getTestCaseInfosFor(method);
        if (tcis != null) {
            for (TestCaseInfo tci : tcis) {
                testCases.add(converter.convert(tci, method));
            }
        }
        return testCases;
    }

    private static List collectTestCases(TestCaseNode testCaseNode, List testCases, TestCaseConverter converter) {
        IMethod method = testCaseNode.getTestMethod();
        TestCaseInfo[] tcis = MetricsScope.TEST_ONLY.getTestCaseInfosFor(method);
        if (tcis != null) {
            for (TestCaseInfo tci : tcis) {
                if ((long)tci.getId().intValue() != testCaseNode.getTciId()) continue;
                testCases.add(converter.convert(tci, method));
                break;
            }
        }
        return testCases;
    }

    public static boolean containsTestCases(Object mysteryMeat) throws CoreException {
        return mysteryMeat instanceof TestCaseNode || Nodes.evalOnTypes(CONTAINS_TEST_CASE, mysteryMeat);
    }

    public static boolean isTestClassContainer(Object mysteryMeat) throws CoreException {
        return Nodes.evalOnTypes(IS_TEST_CLASS_CONTAINER, mysteryMeat);
    }

    public static boolean isAppClassContainer(Object mysterMeat) throws CoreException {
        return Nodes.evalOnTypes(IS_APP_CLASS_CONTAINER, mysterMeat);
    }

    public static boolean evalOnTypes(TypeCondition condition, Object mysteryMeat) throws CoreException {
        if (mysteryMeat instanceof IProject) {
            return Nodes.evalOnTypes(condition, (IProject)mysteryMeat);
        }
        if (mysteryMeat instanceof IJavaProject) {
            return Nodes.evalOnTypes(condition, ((IJavaProject)mysteryMeat).getProject());
        }
        if (mysteryMeat instanceof IPackageFragmentRoot) {
            return Nodes.evalOnTypes(condition, (IPackageFragmentRoot)mysteryMeat);
        }
        if (mysteryMeat instanceof TreePackageFragmentNode) {
            return Nodes.evalOnTypes(condition, (TreePackageFragmentNode)mysteryMeat);
        }
        if (mysteryMeat instanceof LeafPackageFragmentNode) {
            return Nodes.evalOnTypes(condition, (LeafPackageFragmentNode)mysteryMeat);
        }
        if (mysteryMeat instanceof IPackageFragment) {
            return Nodes.evalOnTypes(condition, (IPackageFragment)mysteryMeat);
        }
        if (mysteryMeat instanceof ICompilationUnit) {
            return Nodes.evalOnTypes(condition, (ICompilationUnit)mysteryMeat);
        }
        if (mysteryMeat instanceof IType) {
            return condition.evaluate((IType)mysteryMeat);
        }
        return false;
    }

    public static boolean containsTestCases(IProject project) throws CoreException {
        return Nodes.evalOnTypes(CONTAINS_TEST_CASE, project);
    }

    public static boolean containsTestMethods(IProject project) throws CoreException {
        return Nodes.evalOnTypes(IS_TEST_CLASS_CONTAINER, project);
    }

    public static boolean evalOnTypes(TypeCondition condition, IProject project) throws CoreException {
        Inference inference = condition.inferFor(project);
        if (inference == Inference.UNKNOWN) {
            CloverProject cloverProject = CloverProject.getFor(project);
            if (cloverProject != null) {
                IPackageFragmentRoot[] roots;
                for (IPackageFragmentRoot root : roots = cloverProject.getJavaProject().getPackageFragmentRoots()) {
                    if (root.getKind() != 1 || !Nodes.evalOnTypes(condition, root)) continue;
                    return true;
                }
            }
            return false;
        }
        return inference.result();
    }

    public static boolean evalOnTypes(TypeCondition condition, LeafPackageFragmentNode packageFragmentNode) throws CoreException {
        boolean eval = false;
        for (IPackageFragment packageFragment : packageFragmentNode.getPackageFragments()) {
            if (!(eval = eval || Nodes.evalOnTypes(condition, packageFragment))) continue;
            break;
        }
        return eval;
    }

    public static boolean evalOnTypes(TypeCondition condition, TreePackageFragmentNode packageFragmentNode) throws CoreException {
        IPackageFragment packageFragment = (IPackageFragment)packageFragmentNode.toJavaElement();
        IPackageFragment iPackageFragment = packageFragment = packageFragment instanceof JavaElementAdapter ? (IPackageFragment)((JavaElementAdapter)packageFragment).getAdaptee() : packageFragment;
        if (Nodes.evalOnTypes(condition, packageFragment)) {
            return true;
        }
        if (!packageFragment.isDefaultPackage()) {
            IJavaElement[] packages;
            for (IJavaElement aPackage : packages = ((IPackageFragmentRoot)packageFragment.getParent()).getChildren()) {
                if (!(aPackage instanceof IPackageFragment) || aPackage.getElementName().indexOf(packageFragment.getElementName() + ".") != 0 || !Nodes.evalOnTypes(condition, (IPackageFragment)aPackage)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsTestCases(IPackageFragmentRoot root) throws CoreException {
        return Nodes.evalOnTypes(CONTAINS_TEST_CASE, root);
    }

    public static boolean containsTestMethods(IPackageFragmentRoot root) throws CoreException {
        return Nodes.evalOnTypes(IS_TEST_CLASS_CONTAINER, root);
    }

    public static boolean evalOnTypes(TypeCondition condition, IPackageFragmentRoot root) throws CoreException {
        IJavaElement[] children;
        for (IJavaElement child : children = root.getChildren()) {
            if (!(child instanceof IPackageFragment) || !Nodes.evalOnTypes(condition, (IPackageFragment)child)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsTestCases(IPackageFragment packageFragment) throws CoreException {
        return Nodes.evalOnTypes(CONTAINS_TEST_CASE, packageFragment);
    }

    public static boolean containsTestMethods(IPackageFragment packageFragment) throws CoreException {
        return Nodes.evalOnTypes(IS_TEST_CLASS_CONTAINER, packageFragment);
    }

    public static boolean evalOnTypes(TypeCondition condition, IPackageFragment packageFragment) throws CoreException {
        Inference inference = condition.inferFor(packageFragment);
        if (inference == Inference.UNKNOWN) {
            ICompilationUnit[] cus;
            for (ICompilationUnit cu : cus = packageFragment.getCompilationUnits()) {
                if (!Nodes.evalOnTypes(condition, cu)) continue;
                return true;
            }
            return false;
        }
        return inference.result();
    }

    public static boolean containsTestCases(ICompilationUnit cu) throws CoreException {
        return Nodes.evalOnTypes(CONTAINS_TEST_CASE, cu);
    }

    public static boolean containsTestMethods(ICompilationUnit cu) throws CoreException {
        return Nodes.evalOnTypes(IS_TEST_CLASS_CONTAINER, cu);
    }

    public static boolean evalOnTypes(TypeCondition condition, ICompilationUnit cu) throws CoreException {
        IType[] types;
        for (IType type : types = cu.getTypes()) {
            if (!condition.evaluate(type)) continue;
            return true;
        }
        return false;
    }

    public static Image iconFor(TestCaseInfo testCaseInfo) {
        if (!testCaseInfo.isHasResult()) {
            return CloverPlugin.getImage("icons/obj16/test.gif");
        }
        if (testCaseInfo.isSuccess()) {
            return CloverPlugin.getImage("icons/obj16/testpass.gif");
        }
        if (testCaseInfo.isFailure()) {
            return CloverPlugin.getImage("icons/obj16/testfailure.gif");
        }
        return CloverPlugin.getImage("icons/obj16/testerror.gif");
    }

    private static enum Inference {
        UNKNOWN{

            @Override
            public boolean result() {
                return false;
            }
        }
        ,
        TRUE{

            @Override
            public boolean result() {
                return true;
            }
        }
        ,
        FALSE{

            @Override
            public boolean result() {
                return false;
            }
        };


        public abstract boolean result();
    }

    public static abstract class TypeCondition {
        public abstract boolean evaluate(IType var1) throws CoreException;

        public Inference inferFor(IProject element) throws CoreException {
            return Inference.UNKNOWN;
        }

        public Inference inferFor(IPackageFragmentRoot element) throws CoreException {
            return Inference.UNKNOWN;
        }

        public Inference inferFor(IPackageFragment element) throws CoreException {
            return Inference.UNKNOWN;
        }

        public Inference inferFor(TreePackageFragmentNode element) throws CoreException {
            return Inference.UNKNOWN;
        }

        public Inference inferFor(LeafPackageFragmentNode element) throws CoreException {
            return Inference.UNKNOWN;
        }
    }

    public static interface TestCaseConverter {
        public Object convert(TestCaseInfo var1, IMethod var2);
    }

    public static class ToTestCaseNodeCoverter
    implements TestCaseConverter {
        private TestCaseNodeFactory tcnFactory;

        public ToTestCaseNodeCoverter(TestCaseNodeFactory tcnFactory) {
            this.tcnFactory = tcnFactory;
        }

        @Override
        public Object convert(TestCaseInfo tci, IMethod method) {
            return this.tcnFactory.newNode(tci, method);
        }
    }
}

