/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.dashboard;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.ITextEditor;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.ui.editors.cloud.CloudProjectInput;
import org.openclover.eclipse.core.views.actions.GenerateCloudJob;
import org.openclover.eclipse.core.views.dashboard.DashboardView;

final class DashboardLocationListener
extends LocationAdapter {
    private final DashboardView dashboardView;

    DashboardLocationListener(DashboardView dashboardView) {
        this.dashboardView = dashboardView;
    }

    public void changing(LocationEvent event) {
        URI uri;
        CloverPlugin.logVerbose("Changing: " + event.location);
        try {
            uri = new URI(event.location);
        }
        catch (URISyntaxException e) {
            CloverPlugin.logVerbose("Unexpected URI in the Dashboard view: " + event.location, e);
            return;
        }
        String scheme = uri.getScheme();
        try {
            if ("javaclass".equals(scheme) || "javamethod".equals(scheme)) {
                this.handleJavaSrcLocation(event, uri);
            } else if ("javapkg".equals(scheme)) {
                this.handleJavaPackageLocation(event, uri);
            } else if ("cloverview".equals(scheme)) {
                this.handleCloverView(event, uri);
            }
        }
        catch (Exception e) {
            CloverPlugin.logWarning("Error opening location " + event.location, e);
        }
    }

    private void handleCloverView(LocationEvent event, URI uri) throws CoreException {
        event.doit = false;
        String kind = uri.getSchemeSpecificPart();
        if ("toprisks".equals(kind)) {
            this.openCloudEditor(this.dashboardView.lastSelectedProject.getProject());
        } else if ("quickwins".equals(kind)) {
            this.openCloudEditor(this.dashboardView.lastSelectedProject.getProject());
        } else if (!"treemap".equals(kind)) {
            if ("coverage".equals(kind)) {
                this.focusCoverageExplorerOn((IJavaElement)this.dashboardView.lastSelectedProject.getJavaProject());
            } else if ("testresults".equals(kind)) {
                IWorkbenchPage page = this.dashboardView.getSite().getPage();
                page.showView("org.openclover.eclipse.core.views.testrunexplorer");
            }
        }
    }

    private void openCloudEditor(final IProject project) {
        new GenerateCloudJob(project){

            @Override
            protected IStatus activateEditor() {
                final IStatus[] openEditorStatus = new IStatus[]{Status.OK_STATUS};
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IDE.openEditor((IWorkbenchPage)DashboardLocationListener.this.dashboardView.getSite().getPage(), (IEditorInput)new CloudProjectInput(CloverProject.getFor(project)), (String)"org.openclover.eclipse.core.editors.cloud");
                        }
                        catch (Throwable t) {
                            openEditorStatus[0] = new Status(4, "org.openclover.eclipse.core", 0, CloverEclipsePluginMessages.FAILED_TO_OPEN_CLOUD_EDITOR(), t);
                        }
                    }
                });
                return openEditorStatus[0];
            }
        }.schedule();
    }

    private void handleJavaPackageLocation(LocationEvent event, URI uri) throws CoreException {
        event.doit = false;
        String relativePath = uri.getSchemeSpecificPart().replace('.', '/');
        IJavaElement element = this.dashboardView.lastSelectedProject.getJavaProject().findElement((IPath)new Path(relativePath));
        if (element instanceof IPackageFragment) {
            this.focusCoverageExplorerOn(element);
        }
    }

    private void focusCoverageExplorerOn(IJavaElement element) throws PartInitException {
        IWorkbenchPage page = this.dashboardView.getSite().getPage();
        IViewPart view = page.showView("org.openclover.eclipse.core.views.CloverView");
        if (view instanceof IShowInTarget) {
            IShowInTarget showInTarget = (IShowInTarget)view;
            ShowInContext context = new ShowInContext(null, (ISelection)new StructuredSelection((Object)element));
            showInTarget.show(context);
        }
    }

    private void handleJavaSrcLocation(LocationEvent event, URI uri) throws JavaModelException, CoreException, BadLocationException {
        IResource resource;
        event.doit = false;
        String relativePath = uri.getPath().substring(1);
        String[] locations = uri.getFragment().split("_");
        int line = locations.length > 0 ? Integer.parseInt(locations[0]) - 1 : 0;
        int column = locations.length > 1 ? Integer.parseInt(locations[1]) - 1 : 0;
        IJavaElement element = this.dashboardView.lastSelectedProject.getJavaProject().findElement((IPath)new Path(relativePath));
        IResource iResource = resource = element instanceof ICompilationUnit ? ((ICompilationUnit)element).getCorrespondingResource() : null;
        if (resource instanceof IFile) {
            IWorkbenchPage page;
            IViewPart view;
            IShowInSource showInSource;
            IEditorPart editor = IDE.openEditor((IWorkbenchPage)this.dashboardView.getSite().getPage(), (IFile)((IFile)resource));
            if (editor instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editor;
                IDocument doc = textEditor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                int offset = doc.getLineOffset(line) + column;
                ((ITextEditor)editor).selectAndReveal(offset, 0);
            }
            if ((showInSource = (IShowInSource)editor.getAdapter(IShowInSource.class)) != null && (view = (page = this.dashboardView.getSite().getPage()).showView("org.openclover.eclipse.core.views.CloverView")) instanceof IShowInTarget) {
                IShowInTarget showInTarget = (IShowInTarget)view;
                ShowInContext context = showInSource.getShowInContext();
                showInTarget.show(context);
                page.activate((IWorkbenchPart)editor);
            }
        }
    }
}

