/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.dashboard;

import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.reporters.html.HtmlRenderingSupportImpl;
import java.net.URI;
import java.net.URISyntaxException;
import org.openclover.eclipse.core.CloverPlugin;

public class DashboardHtmlRenderingSupport
extends HtmlRenderingSupportImpl {
    public static final String JAVA_METHOD_SCHEME = "javamethod";
    public static final String JAVA_CLASS_SCHEME = "javaclass";
    public static final String JAVA_PACKAGE_SCHEME = "javapkg";

    @Override
    public StringBuffer getSrcFileLink(boolean toplevel, boolean withAnchor, ClassInfo cls) {
        return new StringBuffer(DashboardHtmlRenderingSupport.makeURI(JAVA_CLASS_SCHEME, cls.getContainingFile().getPackagePath(), cls.getStartLine(), cls.getStartColumn()));
    }

    @Override
    public String getPkgURLPath(String aPkg) {
        return "javapkg:" + aPkg;
    }

    @Override
    public String getMethodLink(boolean toplevel, FullMethodInfo mthd) {
        return DashboardHtmlRenderingSupport.makeURI(JAVA_METHOD_SCHEME, mthd.getContainingFile().getPackagePath(), mthd.getStartLine(), mthd.getStartColumn());
    }

    private static String makeURI(String scheme, String path, int line, int column) {
        try {
            URI uri = new URI(scheme, null, "/" + path, String.valueOf(line) + '_' + column);
            return uri.toString();
        }
        catch (URISyntaxException e) {
            CloverPlugin.logError("Cannot create URI", e);
            return "";
        }
    }

    public String formatMethodName(String methodName) {
        String escapedName = this.htmlEscapeStr(methodName);
        return escapedName.replaceAll("(,|\\(|\\))", "$1<wbr>");
    }
}

