/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.coverageexplorer.widgets;

import com.atlassian.clover.cfg.instr.InstrumentationLevel;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.ui.SwtUtils;

public class ProjectSettingsDialog
extends PopupDialog {
    private final CloverProject project;
    private final Point location;
    private final boolean initialCompileWithCloverSetting;
    private final InstrumentationLevel initialInstrumentationlevel;
    private Button apply;
    private Button compileWithClover;
    private Combo instrumentationLevel;

    public ProjectSettingsDialog(Shell parent, CloverProject project, Point location) {
        super(parent, 4, true, false, false, false, false, String.format("Clover settings for %s", project.getName()), null);
        this.project = project;
        this.location = location;
        this.initialCompileWithCloverSetting = project.getSettings().isInstrumentationEnabled();
        this.initialInstrumentationlevel = project.getSettings().getInstrumentationLevel();
    }

    protected Control createDialogArea(Composite composite) {
        Composite parent = new Composite(composite, 0);
        parent.setLayout((Layout)new GridLayout(3, false));
        SelectionAdapter onChangeEnableApply = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProjectSettingsDialog.this.apply.setEnabled(true);
            }
        };
        this.compileWithClover = new Button(parent, 32);
        this.compileWithClover.setText("Instrument and compile at ");
        this.compileWithClover.setToolTipText("Choose whether Clover should instrument and compile your source code and what coverage granularity.\n\nThis can be switched off if you wish to develop without tracking code coverage for a period of time or if you have configured Clover-for-Ant or Clover-for-Maven to instrument and compile your source for you.");
        this.compileWithClover.setSelection(this.initialCompileWithCloverSetting);
        this.compileWithClover.addSelectionListener((SelectionListener)onChangeEnableApply);
        this.compileWithClover.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProjectSettingsDialog.this.instrumentationLevel.setEnabled(ProjectSettingsDialog.this.compileWithClover.getSelection());
            }
        });
        this.instrumentationLevel = new Combo(parent, 40);
        SwtUtils.gridDataFor((Control)this.instrumentationLevel).horizontalSpan = 2;
        this.instrumentationLevel.setItems(new String[]{"statement level", "method level"});
        this.instrumentationLevel.select(this.initialInstrumentationlevel == InstrumentationLevel.STATEMENT ? 0 : 1);
        this.instrumentationLevel.setToolTipText("Statement level instrumentation is more accurate but has a runtime performance penalty.Method level instrumentation is less accurate but will run faster and Clover will be able to provide coverage feedback more switfly.\n\nIf you only use Clover for optimizing your test runs, method level instrumenation is the best option.");
        this.instrumentationLevel.addSelectionListener((SelectionListener)onChangeEnableApply);
        this.apply = new Button(parent, 0);
        this.apply.setText("Apply");
        SwtUtils.gridDataFor((Control)this.apply).horizontalSpan = 3;
        SwtUtils.gridDataFor((Control)this.apply).horizontalAlignment = 3;
        this.apply.setEnabled(false);
        this.apply.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean newCompileWithCloverSetting = ProjectSettingsDialog.this.compileWithClover.getSelection();
                InstrumentationLevel newInstrementationlevel = ProjectSettingsDialog.this.instrumentationLevel.getSelectionIndex() == 0 ? InstrumentationLevel.STATEMENT : InstrumentationLevel.METHOD;
                ProjectSettingsDialog.this.project.getSettings().setInstrumentationEnabled(newCompileWithCloverSetting);
                ProjectSettingsDialog.this.project.getSettings().setInstrumentationLevel(newInstrementationlevel);
                ProjectSettingsDialog.this.close();
                if ((newCompileWithCloverSetting != ProjectSettingsDialog.this.initialCompileWithCloverSetting || newInstrementationlevel != ProjectSettingsDialog.this.initialInstrumentationlevel) && ProjectSettingsDialog.this.project.okayToRebuild(ProjectSettingsDialog.this.getParentShell())) {
                    try {
                        ProjectSettingsDialog.this.project.getProject().build(15, null);
                    }
                    catch (CoreException e) {
                        CloverPlugin.logError("Failed to rebuild project after changing 'compile with clover' state", e);
                    }
                }
            }
        });
        return parent;
    }

    protected Point getInitialLocation(Point point) {
        return this.location;
    }
}

