/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.coverageexplorer;

import java.util.List;
import org.eclipse.ui.IMemento;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.views.ExplorerViewSettings;
import org.openclover.eclipse.core.views.coverageexplorer.CoverageView;
import org.openclover.eclipse.core.views.coverageexplorer.MetricsPcCellRenderer;
import org.openclover.eclipse.core.views.coverageexplorer.nodes.FlatPackagesHierarchyBuilder;
import org.openclover.eclipse.core.views.coverageexplorer.nodes.PackageRootsFlatPackagesHierarchyBuilder;
import org.openclover.eclipse.core.views.coverageexplorer.nodes.PackageRootsTreePackagesHierarchyBuilder;
import org.openclover.eclipse.core.views.coverageexplorer.nodes.TreePackagesHierarchyBuilder;
import org.openclover.eclipse.core.views.nodes.NodeHierarchyBuilder;
import org.openclover.util.Lists;

public class CoverageViewSettings
extends ExplorerViewSettings {
    public static final int HIERARCHY_STYLE_START = 0;
    public static final int HIERARCHY_STYLE_PACKAGE_ROOTS = 0;
    public static final int HIERARCHY_STYLE_NO_PACKAGE_ROOTS = 1;
    public static final int HIERARCHY_STYLE_MAX = 1;
    public static final int COVERAGE_MODEL_START = 0;
    public static final int COVERAGE_MODEL_FULL = 0;
    public static final int COVERAGE_MODEL_APP_ONLY = 1;
    public static final int COVERAGE_MODEL_TEST_ONLY = 2;
    public static final int COVERAGE_MODEL_MAX = 2;
    public static final String COVERAGE_MODEL = "coverage.model";
    private static final String HIDE_UNAVAILABLE = "hide.unavailable";
    private static final String HIDE_FULLY_COVERED = "hide.fullycovered";
    private static final String SHOW_PACKAGE_TREE = "show.packagetree";
    private int coverageModel = this.defaultCoverageModel();
    private boolean hideUnavailable = false;
    private boolean hideUnitTests = false;
    private boolean hideFullyCovered = false;
    private boolean showPackageTree = false;

    public CoverageViewSettings() {
        this(null);
    }

    public CoverageViewSettings(IMemento memento) {
        super(memento);
        if (memento != null) {
            Integer showPackageTree;
            Integer hideUnavailable;
            Integer coverageModel = memento.getInteger(COVERAGE_MODEL);
            if (coverageModel != null) {
                this.coverageModel = coverageModel;
            }
            if ((hideUnavailable = memento.getInteger(HIDE_UNAVAILABLE)) != null) {
                this.hideUnavailable = hideUnavailable != 0;
            }
            Integer hideFullyCovered = memento.getInteger(HIDE_FULLY_COVERED);
            if (hideUnavailable != null) {
                boolean bl = this.hideFullyCovered = hideFullyCovered != 0;
            }
            if ((showPackageTree = memento.getInteger(SHOW_PACKAGE_TREE)) != null) {
                this.showPackageTree = showPackageTree != 0;
            }
        }
    }

    @Override
    protected List allTreeColumns() {
        return Lists.newArrayList(CoverageView.BUILTIN_COLUMN_DEFINITIONS);
    }

    @Override
    protected List defaultTreeColumns() {
        return Lists.newArrayList(CoverageView.DEFAULT_BUILTIN_COLUMN_DEFINITIONS);
    }

    @Override
    protected List defaultTreeColumnWidths() {
        return Lists.newArrayList(300, MetricsPcCellRenderer.getDefaultWidth(), 100, 100);
    }

    private int defaultCoverageModel() {
        return 0;
    }

    @Override
    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger(COVERAGE_MODEL, this.coverageModel);
        memento.putInteger(HIDE_UNAVAILABLE, this.hideUnavailable ? 1 : 0);
        memento.putInteger(HIDE_FULLY_COVERED, this.hideFullyCovered ? 1 : 0);
        memento.putInteger(SHOW_PACKAGE_TREE, this.showPackageTree ? 1 : 0);
    }

    public int getCoverageModel() {
        return this.coverageModel;
    }

    public void setCoverageModel(int coverageModel) {
        this.coverageModel = coverageModel;
    }

    public boolean shouldHideUnavailableCoverage() {
        return this.hideUnavailable;
    }

    public void setShouldHideUnavailableCoverage(boolean shouldHide) {
        this.hideUnavailable = shouldHide;
    }

    public boolean shouldHideFullyCovered() {
        return this.hideFullyCovered;
    }

    public void setShouldHideFullyCovered(boolean shouldHide) {
        this.hideFullyCovered = shouldHide;
    }

    @Override
    public MetricsScope getMetricsScope() {
        switch (this.coverageModel) {
            case 0: {
                return MetricsScope.FULL;
            }
            case 1: {
                return MetricsScope.APP_ONLY;
            }
            case 2: {
                return MetricsScope.TEST_ONLY;
            }
        }
        return MetricsScope.DEFAULT;
    }

    @Override
    protected NodeHierarchyBuilder[] getNodeBuilders() {
        return new NodeHierarchyBuilder[]{new PackageRootsFlatPackagesHierarchyBuilder(), new FlatPackagesHierarchyBuilder(), new PackageRootsTreePackagesHierarchyBuilder(), new TreePackagesHierarchyBuilder()};
    }

    @Override
    protected int expandDepthForStyle() {
        switch (this.hierarchyStyle) {
            case 0: {
                return 3;
            }
            case 1: {
                return 2;
            }
        }
        return 2;
    }

    @Override
    protected int getHierarchyStyleMax() {
        return 1;
    }

    @Override
    protected int getHierarchyStyleStart() {
        return 0;
    }

    @Override
    protected int defaultHierarchyStyle() {
        return 1;
    }

    public void showPackageTree(boolean show) {
        this.showPackageTree = show;
    }

    public boolean showPackageTree() {
        return this.showPackageTree;
    }

    @Override
    public NodeHierarchyBuilder nodeBuilderForStyle() {
        if (this.hierarchyStyle >= this.getHierarchyStyleStart() && this.hierarchyStyle <= this.getHierarchyStyleMax()) {
            return this.getNodeBuilders()[this.hierarchyStyle + (this.showPackageTree ? 2 : 0)];
        }
        return this.getNodeBuilders()[this.defaultHierarchyStyle()];
    }
}

