/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.coverageexplorer;

import com.atlassian.clover.registry.metrics.BlockMetrics;
import com.atlassian.clover.util.MetricsFormatUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.openclover.eclipse.core.projects.CloveredProjectLabelProvider;
import org.openclover.eclipse.core.views.coverageexplorer.CoverageViewSettings;

public class CoverageViewMetricsPane
extends Composite {
    private TreeViewer projectTreeViewer;
    private CoverageViewSettings settings;
    private WorkbenchLabelProvider labelProvider;
    private FormToolkit toolkit;
    private Form form;
    private Label passTestsValue;
    private Label failureTestsValue;
    private Label errorsValue;
    private Label testsValue;
    private Label packagesValue;
    private Label methodsValue;
    private Label filesValue;
    private Label ncLinesOfCodeValue;
    private Label classesValue;
    private Label linesOfCodeValue;
    private Section testSection;
    private Section structureSection;
    private Section sourceSection;
    private Label statementsValue;
    private Label branchesValue;
    private Label complexityValue;
    private Label avgMethodComplexityValue;
    private Label complexityDensityValue;

    public CoverageViewMetricsPane(Composite parent, int style, CoverageViewSettings settings, TreeViewer projectTreeViewer) {
        super(parent, style);
        this.settings = settings;
        this.projectTreeViewer = projectTreeViewer;
        this.setLayout((Layout)new GridLayout(1, false));
        this.labelProvider = new CloveredProjectLabelProvider();
        this.toolkit = new FormToolkit(this.getDisplay());
        this.form = this.toolkit.createForm((Composite)this);
        this.form.setBackground(null);
        this.form.setLayoutData((Object)new GridData(1808));
        this.setMetricsFor("-");
        this.form.getBody().setLayout((Layout)new GridLayout(2, true));
        this.createStructureSection();
        this.createTestSection();
        this.createSource();
        projectTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (selectionChangedEvent.getSelection() instanceof IStructuredSelection) {
                    CoverageViewMetricsPane.this.update((IStructuredSelection)selectionChangedEvent.getSelection());
                } else {
                    CoverageViewMetricsPane.this.clear();
                }
            }
        });
    }

    private void setMetricsFor(String selection) {
        this.form.setText("Metrics for: " + selection);
    }

    private void createSource() {
        this.sourceSection = this.toolkit.createSection(this.form.getBody(), 320);
        this.sourceSection.setText("Source");
        this.sourceSection.setToolTipText("Information about the source code in the current selection");
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.sourceSection.setLayoutData((Object)gridData);
        Composite sourceForm = this.toolkit.createComposite((Composite)this.sourceSection);
        this.sourceSection.setClient((Control)sourceForm);
        sourceForm.setLayout((Layout)new GridLayout(4, true));
        Label label = this.toolkit.createLabel(sourceForm, "LOC:");
        label.setToolTipText("The number of lines of code in the current selection");
        this.linesOfCodeValue = this.toolkit.createLabel(sourceForm, "-");
        label = this.toolkit.createLabel(sourceForm, "NC LOC:");
        label.setToolTipText("The number of non-comment lines of code in the current selection");
        this.ncLinesOfCodeValue = this.toolkit.createLabel(sourceForm, "-");
        label = this.toolkit.createLabel(sourceForm, "Total Cmp:");
        label.setToolTipText("The total cyclomatic complexity of the current selection");
        this.complexityValue = this.toolkit.createLabel(sourceForm, "-");
        label = this.toolkit.createLabel(sourceForm, "Cmp Density:");
        label.setToolTipText("The complexity density of the current selection");
        this.complexityDensityValue = this.toolkit.createLabel(sourceForm, "-");
        label = this.toolkit.createLabel(sourceForm, "Avg Method Cmp:");
        label.setToolTipText("The average method complexity of the current selection");
        this.avgMethodComplexityValue = this.toolkit.createLabel(sourceForm, "-");
    }

    private void createTestSection() {
        this.testSection = this.toolkit.createSection(this.form.getBody(), 320);
        this.testSection.setText("Test Executions");
        this.testSection.setToolTipText("Information on the test methods defined in the current selection.");
        this.testSection.setLayoutData((Object)new GridData(1808));
        Composite testsForm = this.toolkit.createComposite((Composite)this.testSection);
        this.testSection.setClient((Control)testsForm);
        testsForm.setLayout((Layout)new GridLayout(2, true));
        Label label = this.toolkit.createLabel(testsForm, "Executed Tests:");
        label.setToolTipText("The number of test methods defined in the current selection that have been run and generated some coverage");
        this.testsValue = this.toolkit.createLabel(testsForm, "-");
        label = this.toolkit.createLabel(testsForm, "Passes:");
        label.setToolTipText("The number of executed test methods in the selection that didn't fail or have an error");
        this.passTestsValue = this.toolkit.createLabel(testsForm, "-");
        label = this.toolkit.createLabel(testsForm, "Fails:");
        label.setToolTipText("The number of executed test methods in the selection that failed");
        this.failureTestsValue = this.toolkit.createLabel(testsForm, "-");
        label = this.toolkit.createLabel(testsForm, "Errors:");
        label.setToolTipText("The number of executed test methods in the selection that resulted in an error");
        this.errorsValue = this.toolkit.createLabel(testsForm, "-");
    }

    private void createStructureSection() {
        this.structureSection = this.toolkit.createSection(this.form.getBody(), 320);
        this.structureSection.setText("Structure");
        this.structureSection.setToolTipText("Information on the structure of the current selection");
        this.structureSection.setLayoutData((Object)new GridData(1808));
        Composite structureForm = this.toolkit.createComposite((Composite)this.structureSection);
        this.structureSection.setClient((Control)structureForm);
        structureForm.setLayout((Layout)new GridLayout(2, true));
        Label label = this.toolkit.createLabel(structureForm, "Packages:");
        label.setToolTipText("The number of Java packages");
        this.packagesValue = this.toolkit.createLabel(structureForm, "-");
        label = this.toolkit.createLabel(structureForm, "Files:");
        label.setToolTipText("The number of Java files");
        this.filesValue = this.toolkit.createLabel(structureForm, "-");
        label = this.toolkit.createLabel(structureForm, "Classes:");
        label.setToolTipText("The number of Java classes");
        this.classesValue = this.toolkit.createLabel(structureForm, "-");
        label = this.toolkit.createLabel(structureForm, "Methods:");
        label.setToolTipText("The number of Java methods");
        this.methodsValue = this.toolkit.createLabel(structureForm, "-");
        this.toolkit.createLabel(structureForm, "Statements:");
        this.statementsValue = this.toolkit.createLabel(structureForm, "-");
        this.toolkit.createLabel(structureForm, "Branches:");
        this.branchesValue = this.toolkit.createLabel(structureForm, "-");
    }

    public void dispose() {
        this.toolkit.dispose();
        super.dispose();
    }

    private void clear() {
        this.setMetricsFor("-");
        this.failureTestsValue.setText("-");
        this.passTestsValue.setText("-");
        this.errorsValue.setText("-");
        this.testsValue.setText("-");
        this.packagesValue.setText("-");
        this.methodsValue.setText("-");
        this.filesValue.setText("-");
        this.statementsValue.setText("-");
        this.branchesValue.setText("-");
        this.ncLinesOfCodeValue.setText("-");
        this.classesValue.setText("-");
        this.linesOfCodeValue.setText("-");
        this.complexityValue.setText("-");
        this.complexityDensityValue.setText("-");
        this.avgMethodComplexityValue.setText("-");
        this.structureSection.layout();
        this.testSection.layout();
        this.sourceSection.layout();
    }

    private void update(IStructuredSelection selection) {
        BlockMetrics metrics;
        if (selection.getFirstElement() instanceof IAdaptable && (metrics = this.settings.getMetricsScope().getMetricsFor(selection.getFirstElement())) != null) {
            this.failureTestsValue.setText(MetricsFormatUtils.formatMetricsInteger(metrics.getNumTestFailures()));
            this.passTestsValue.setText(MetricsFormatUtils.formatMetricsInteger(metrics.getNumTestPasses()));
            this.errorsValue.setText(MetricsFormatUtils.formatMetricsInteger(metrics.getNumTestErrors()));
            this.testsValue.setText(MetricsFormatUtils.formatMetricsInteger(metrics.getNumTests()));
            this.packagesValue.setText(MetricsFormatUtils.formatMetricsInteger(MetricsFormatUtils.getNumPackages(metrics)));
            this.methodsValue.setText(MetricsFormatUtils.formatMetricsInteger(MetricsFormatUtils.getNumMethods(metrics)));
            this.filesValue.setText(MetricsFormatUtils.formatMetricsInteger(MetricsFormatUtils.getNumFiles(metrics)));
            this.statementsValue.setText(MetricsFormatUtils.formatMetricsInteger(MetricsFormatUtils.getNumStatements(metrics)));
            this.branchesValue.setText(MetricsFormatUtils.formatMetricsInteger(MetricsFormatUtils.getNumBranches(metrics)));
            this.classesValue.setText(MetricsFormatUtils.formatMetricsInteger(MetricsFormatUtils.getNumClasses(metrics)));
            this.ncLinesOfCodeValue.setText(MetricsFormatUtils.formatMetricsInteger(MetricsFormatUtils.getNcLineCount(metrics)));
            this.linesOfCodeValue.setText(MetricsFormatUtils.formatMetricsInteger(MetricsFormatUtils.getLineCount(metrics)));
            this.complexityValue.setText(MetricsFormatUtils.formatMetricsInteger(MetricsFormatUtils.getComplexity(metrics)));
            this.complexityDensityValue.setText(MetricsFormatUtils.formatMetricsDecimal(MetricsFormatUtils.getComplexityDensity(metrics)));
            this.avgMethodComplexityValue.setText(MetricsFormatUtils.formatMetricsDecimal(MetricsFormatUtils.getAvgMethodComplexity(metrics)));
            this.structureSection.layout();
            this.testSection.layout();
            this.sourceSection.layout();
            this.setFormName(selection);
            return;
        }
        this.clear();
        this.setFormName(selection);
    }

    private void setFormName(IStructuredSelection selection) {
        IAdaptable asAdaptable = selection == null ? null : (IAdaptable)selection.getFirstElement();
        IJavaElement asJavaElement = asAdaptable == null ? null : (IJavaElement)asAdaptable.getAdapter(IJavaElement.class);
        String label = "-";
        if (asJavaElement != null) {
            label = this.labelProvider.getText((Object)asJavaElement);
        }
        this.setMetricsFor(label);
    }
}

