/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.actions;

import com.atlassian.clover.Logger;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.views.actions.UntargetedViewActionDelegate;
import org.osgi.service.prefs.BackingStoreException;

public class ToggleWorkingSetModeActionDelegate
extends UntargetedViewActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setChecked(CloverPlugin.getInstance().isInWorkingSetMode());
    }

    public void run(IAction action) {
        action.setChecked(!CloverPlugin.getInstance().isInWorkingSetMode());
        boolean actionChecked = action.isChecked();
        try {
            CloverPlugin.getInstance().setIsInWorkingSetMode(actionChecked);
        }
        catch (BackingStoreException exception) {
            Logger.getInstance().error(String.format("Could not write WorkingSetMode flag to %b", actionChecked));
            Status status = new Status(4, "org.openclover.eclipse.core", 4, Messages.preferences_saveProblems, (Throwable)exception);
            InternalPlatform.getDefault().log((IStatus)status);
        }
        CloverProject.refreshAllModels(true, false);
    }
}

