/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.settings.ProjectSettings;
import org.openclover.eclipse.core.views.actions.SingleCloverProjectActionDelegate;
import org.openclover.eclipse.core.views.widgets.context.ContextChooserDialog;

public class ShowContextFilterDialogActionDelegate
extends SingleCloverProjectActionDelegate {
    public void run(IAction action) {
        CloverProject project = null;
        try {
            project = CloverProject.getFor((IProject)this.projects.iterator().next());
        }
        catch (CoreException e) {
            CloverPlugin.logError("Unable to retreive block filter", e);
        }
        if (project != null) {
            ProjectSettings props = project.getSettings();
            final ContextChooserDialog dialog = new ContextChooserDialog(this.getShell(), props);
            final CloverProject projectAsFinal = project;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    int result = dialog.open();
                    switch (result) {
                        case 0: {
                            projectAsFinal.refreshModel(true, false);
                            break;
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            CloverPlugin.logError("Unknown dialog response code when setting block contexts: " + result);
                        }
                    }
                }
            });
        }
    }
}

