/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.ui.BrowserUtils;
import org.openclover.eclipse.core.ui.SwtUtils;
import org.openclover.eclipse.core.views.actions.CloverProjectActionDelegate;

public class ShowAboutCloverActionDelegate
extends CloverProjectActionDelegate {
    public void run(IAction action) {
        new AboutDialog(this.view.getViewSite().getPart().getSite().getShell()).open();
    }

    class AboutDialog
    extends Dialog {
        public AboutDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("About OpenClover Plugin for Eclipse");
        }

        protected Control createDialogArea(Composite parent) {
            Composite top = new Composite(parent, 0);
            top.setLayout((Layout)new GridLayout(1, false));
            Label iconLabel = new Label(top, 0);
            iconLabel.setImage(CloverPlugin.getImage("icons/logo.png"));
            iconLabel.setLayoutData((Object)new GridData(64));
            TabFolder tabFolder = new TabFolder(top, 0);
            tabFolder.setLayoutData((Object)new GridData(64));
            this.createInstallationTab(tabFolder);
            this.createAckTab(tabFolder);
            tabFolder.pack();
            return tabFolder;
        }

        private Composite createInstallationTab(TabFolder tabFolder) {
            Composite topTabItem = new Composite((Composite)tabFolder, 0);
            topTabItem.setLayout((Layout)new GridLayout(1, false));
            TabItem installationAbout = new TabItem(tabFolder, 0);
            installationAbout.setText("Installation");
            installationAbout.setControl((Control)topTabItem);
            Composite aboutComposite = new Composite(topTabItem, 0);
            aboutComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            aboutComposite.setLayout((Layout)new GridLayout(2, false));
            new Label(aboutComposite, 0).setText("Version:");
            SwtUtils.createMultilineLabel(aboutComposite, "4.5.2.v20240131000000", this.convertWidthInCharsToPixels(60));
            new Label(aboutComposite, 0);
            SwtUtils.createMultilineLabel(aboutComposite, CloverEclipsePluginMessages.CLOVER_COPYRIGHT(), this.convertWidthInCharsToPixels(60));
            return aboutComposite;
        }

        private void createAckTab(TabFolder tabFolder) {
            Composite topAck = new Composite((Composite)tabFolder, 0);
            topAck.setLayout((Layout)new GridLayout(1, false));
            Composite ackComposite = new Composite(topAck, 0);
            ackComposite.setLayoutData((Object)new GridData(576));
            ackComposite.setLayout((Layout)new GridLayout(2, false));
            ackComposite.setLayoutData((Object)new GridData(768));
            Label basedOn = new Label(ackComposite, 0);
            basedOn.setText("OpenClover is based on open source code of Atlassian Clover(R)");
            SwtUtils.setHorizontalSpan((Control)basedOn, 2);
            Label generalAck = new Label(ackComposite, 0);
            generalAck.setText("OpenClover makes use of the following 3rd party libraries:");
            SwtUtils.setHorizontalSpan((Control)generalAck, 2);
            this.linkAndLicense("Annotations (IntelliJ)", "https://www.jetbrains.com", "ANNOTATIONS-13.0-LICENSE.TXT", ackComposite);
            this.linkAndLicense("Ant", "https://ant.apache.org", "ANT-1.5.2-LICENSE.TXT", ackComposite);
            this.linkAndLicense("ANTLR2 Library", "https://www.antlr2.org", "ANTLR-2.7.7-LICENSE.TXT", ackComposite);
            this.linkAndLicense("ANTLR3 Java Grammar", "https://www.antlr3.org", "ANTLR-JAVA-GRAMMAR-3.0-LICENSE.TXT", ackComposite);
            this.linkAndLicense("ASM", "https://asm.ow2.org", "ASM-5.0.3-LICENSE.TXT", ackComposite);
            this.linkAndLicense("Cajo", "https://java.net/projects/cajo/pages/Home", "CAJO-1.117-LICENSE.TXT", ackComposite);
            this.linkAndLicense("Commons Codec", "https://commons.apache.org", "COMMONS-CODEC-1.9-LICENSE.TXT", ackComposite);
            this.linkAndLicense("Commons Collections", "https://commons.apache.org", "COMMONS-COLLECTIONS-3.2.2-LICENSE.TXT", ackComposite);
            this.linkAndLicense("Commons Lang", "https://commons.apache.org", "COMMONS-LANG3-3.3.2-LICENSE.TXT", ackComposite);
            this.linkAndLicense("FastUtil", "https://fastutil.dsi.unimi.it/", "FASTUTIL-4.4.3-LICENSE.TXT", ackComposite);
            this.linkAndLicense("Groovy", "https://groovy.codehaus.org", "GROOVY-1.7.0-LICENSE.TXT", ackComposite);
            this.linkAndLicense("GSON", "https://code.google.com/p/google-gson", "GSON-1.3-LICENSE.TXT", ackComposite);
            this.linkAndLicense("iText", "https://itextpdf.com", "ITEXT-2.0.1-LICENSE.TXT", ackComposite);
            this.linkAndLicense("JCommon", "https://www.jfree.org/jfreechart/", "JCOMMON-1.0.23-LICENSE.TXT", ackComposite);
            this.linkAndLicense("JDOM", "https://www.jdom.org", "JDOM-1.0-LICENSE.TXT", ackComposite);
            this.linkAndLicense("JFreechart", "https://www.jfree.org/jfreechart/", "JFREECHART-1.0.19-LICENSE.TXT", ackComposite);
            this.linkAndLicense("JIT", "https://thejit.org/", "JIT-1.1.2-LICENSE.TXT", ackComposite);
            this.linkAndLicense("jQuery", "https://jquery.com/", "JQUERY-1.8.3-LICENSE.TXT", ackComposite);
            this.linkAndLicense("JSON", "https://www.json.org", "JSON-LICENSE.TXT", ackComposite);
            this.linkAndLicense("KTreemap", "https://jtreemap.sourceforge.net/", "KTREEMAP-1.1.0-LICENSE.TXT", ackComposite);
            this.linkAndLicense("SLF4J", "https://www.slf4j.org/", "SLF4J-1.7.36-LICENSE.TXT", ackComposite);
            this.linkAndLicense("Velocity", "https://velocity.apache.org/", "VELOCITY-1.7-LICENSE.TXT", ackComposite);
            TabItem ackTab = new TabItem(tabFolder, 0);
            ackTab.setText("Acknowledgements");
            ackTab.setControl((Control)topAck);
            new Label(ackComposite, 0);
            Label apacheAck = new Label(ackComposite, 0);
            apacheAck.setText("This product includes software developed by\nthe Apache Software Foundation (http://www.apache.org/).");
            apacheAck.setLayoutData((Object)new GridData());
            SwtUtils.setHorizontalSpan((Control)apacheAck, 2);
        }

        private void linkAndLicense(final String name, final String url, final String pathToLicense, Composite ackComposite) {
            Link link = new Link(ackComposite, 0);
            link.setText("<a>" + name + "</a>");
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    BrowserUtils.openExternalBrowser(url);
                }
            });
            Link licenseLink = new Link(ackComposite, 0);
            licenseLink.setText("<a>View license</a>");
            licenseLink.setLayoutData((Object)new GridData(128));
            licenseLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void widgetSelected(SelectionEvent event) {
                    InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/licenses/" + pathToLicense);
                    if (in != null) {
                        try {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                            final StringBuffer sb = new StringBuffer();
                            char[] buf = new char[1024];
                            int read = 0;
                            try {
                                while (read != -1) {
                                    sb.append(buf, 0, read);
                                    read = reader.read(buf);
                                }
                            }
                            finally {
                                ((Reader)reader).close();
                            }
                            Dialog d = new Dialog(AboutDialog.this.getShell()){
                                private Font licenseFont;
                                {
                                    super(x0);
                                    this.licenseFont = new Font(null, "Courier", 10, 0);
                                }

                                protected void configureShell(Shell shell) {
                                    super.configureShell(shell);
                                    shell.setText(name + "licenses");
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                protected Control createDialogArea(Composite parent) {
                                    Composite composite = new Composite(parent, 0);
                                    composite.setLayout((Layout)new GridLayout());
                                    composite.setFont(this.licenseFont);
                                    Text licenseText = new Text(composite, 779);
                                    licenseText.setLayoutData((Object)new GridData(1808));
                                    licenseText.setFont(this.licenseFont);
                                    GC gc = new GC((Drawable)licenseText);
                                    try {
                                        gc.setFont(this.licenseFont);
                                        FontMetrics fontMetrics = gc.getFontMetrics();
                                        ((GridData)licenseText.getLayoutData()).widthHint = 1.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)80);
                                        ((GridData)licenseText.getLayoutData()).heightHint = 1.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)40);
                                    }
                                    finally {
                                        gc.dispose();
                                    }
                                    licenseText.setText(sb.toString());
                                    return composite;
                                }
                            };
                            d.open();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }
}

