/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.actions;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.reports.GenerateReportWizard;
import org.openclover.eclipse.core.reports.OpenReportDialog;
import org.openclover.eclipse.core.reports.OpenReportOperation;
import org.openclover.eclipse.core.reports.model.ReportHistoryEntry;
import org.openclover.eclipse.core.ui.projects.DatabaseChangeEvent;
import org.openclover.eclipse.core.ui.projects.DatabaseChangeListener;
import org.openclover.eclipse.core.views.ExplorerView;
import org.openclover.eclipse.core.views.SelectionUtils;
import org.openclover.util.Sets;

public class GenerateReportAction
extends Action
implements IMenuCreator,
DatabaseChangeListener,
ISelectionChangedListener {
    private final ExplorerView view;
    private Set projects = Sets.newHashSet();
    private Menu menu;

    public GenerateReportAction(ExplorerView view) {
        this.view = view;
        this.projects = Sets.newHashSet();
        this.setId("org.openclover.eclipse.core.actions.report.generate");
        this.setText(CloverEclipsePluginMessages.PROJECT_REPORT());
        this.setToolTipText(CloverEclipsePluginMessages.PROJECT_REPORT_TOOL_TIP());
        this.setImageDescriptor(CloverPlugin.getImageDescriptor("icons/clcl16/report.gif"));
        this.setMenuCreator(this);
        this.updateEnablement();
    }

    public int getStyle() {
        return 4;
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent event) {
        this.updateEnablement();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.projects = SelectionUtils.gatherProjectsForSelection(event.getSelection());
    }

    private void updateEnablement() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        boolean shouldShow = false;
        for (IProject project : projects) {
            try {
                shouldShow |= CloverProject.isAppliedTo(project);
            }
            catch (CoreException e) {
                CloverPlugin.logError("Error checking whether to enable report button", e);
            }
        }
        this.setEnabled(shouldShow);
    }

    public void run() {
        this.generate();
    }

    public void generate() {
        try {
            CloverProject project = null;
            if (!this.projects.isEmpty()) {
                project = CloverProject.getFor((IProject)this.projects.iterator().next());
            }
            WizardDialog dialog = new WizardDialog(this.view.getSite().getShell(), (IWizard)new GenerateReportWizard(project, this.view.getSite().getWorkbenchWindow().getWorkbench()));
            dialog.create();
            dialog.open();
        }
        catch (Exception e) {
            CloverPlugin.logError("Unable to launch report wizard", e);
        }
    }

    public Menu getMenu(Control control) {
        this.disposeMenu();
        this.menu = new Menu(control);
        return this.buildMenu();
    }

    public Menu getMenu(Menu parent) {
        this.disposeMenu();
        this.menu = new Menu(parent);
        return this.buildMenu();
    }

    private Menu buildMenu() {
        MenuItem runItem = new MenuItem(this.menu, 64);
        runItem.setText(CloverEclipsePluginMessages.PROJECT_GENERATE_REPORT());
        runItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GenerateReportAction.this.generate();
            }
        });
        MenuItem viewItem = new MenuItem(this.menu, 64);
        viewItem.setText(CloverEclipsePluginMessages.PROJECT_VIEW_REPORT());
        List<ReportHistoryEntry> reportHistory = CloverPlugin.getInstance().getReportHistory();
        if (reportHistory.size() > 0) {
            Menu viewItems = new Menu(viewItem);
            Collections.reverse(reportHistory);
            for (final ReportHistoryEntry report : reportHistory) {
                MenuItem viewItemsItem = new MenuItem(viewItems, 0);
                viewItemsItem.setText(report.toString());
                viewItemsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        OpenReportOperation chosenMethod;
                        List availableMethods = OpenReportOperation.findFor(report);
                        OpenReportOperation openReportOperation = chosenMethod = availableMethods.size() == 1 ? (OpenReportOperation)availableMethods.get(0) : OpenReportDialog.openOnRevist(GenerateReportAction.this.view.getSite().getShell(), report, availableMethods);
                        if (chosenMethod != null) {
                            chosenMethod.open(report);
                        }
                    }
                });
            }
            viewItem.setMenu(viewItems);
        } else {
            viewItem.setEnabled(false);
        }
        return this.menu;
    }

    public void dispose() {
        this.disposeMenu();
    }

    private void disposeMenu() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
    }
}

