/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.actions.NewWizardsActionGroup;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.GenerateBuildPathActionGroup;
import org.eclipse.jdt.ui.actions.BuildActionGroup;
import org.eclipse.jdt.ui.actions.CCPActionGroup;
import org.eclipse.jdt.ui.actions.GenerateActionGroup;
import org.eclipse.jdt.ui.actions.ImportActionGroup;
import org.eclipse.jdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.jdt.ui.actions.NavigateActionGroup;
import org.eclipse.jdt.ui.actions.ProjectActionGroup;
import org.eclipse.jdt.ui.actions.RefactorActionGroup;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.views.CloverViewPart;
import org.openclover.eclipse.core.views.CloveredWorkspaceProvider;
import org.openclover.eclipse.core.views.ColumnBuilder;
import org.openclover.eclipse.core.views.ColumnDefinition;
import org.openclover.eclipse.core.views.ColumnManager;
import org.openclover.eclipse.core.views.CustomColumnDefinition;
import org.openclover.eclipse.core.views.ExplorerViewLabelProvider;
import org.openclover.eclipse.core.views.ExplorerViewSettings;
import org.openclover.eclipse.core.views.TreeColumnControlListener;
import org.openclover.eclipse.core.views.TreeColumnLabeler;
import org.openclover.eclipse.core.views.actions.GenerateReportAction;
import org.openclover.eclipse.core.views.actions.OpenJavaEditorAction;
import org.openclover.eclipse.core.views.widgets.ColumnController;
import org.openclover.eclipse.core.views.widgets.ViewAlertContainer;
import org.openclover.util.Maps;

public abstract class ExplorerView
extends CloverViewPart {
    public static final int ACTION_OPEN = 0;
    public static final int ACTION_MAX = 1;
    public static final IProject[] ENTIRE_WORKSPACE = new IProject[]{null};
    protected Tree tree;
    protected TreeViewer treeViewer;
    protected Map<ColumnDefinition, TreeColumn> columns;
    protected TreeColumnLabeler treeColumnLabeler = new TreeColumnLabeler();
    protected ExplorerViewSettings settings;
    protected CloveredWorkspaceProvider treeContentProvider;
    protected SelectionDispatchAction[] actions;
    protected ActionGroup[] actionGroups;
    protected GenerateReportAction generateReportAction;
    private ActivationPartListener thisPartActivationListener;
    protected ColumnController treeColumnController = new ColumnController(){

        @Override
        public void syncSorting() {
            ExplorerView.this.buildTreeSorter();
        }
    };
    private TreeColumnManager treeColumnManager = new TreeColumnManager();
    private Map<TreeColumn, TreeColumnControlListener> columnListeners = Maps.newHashMap();

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.buildPartControl(parent);
        parent.pack();
        this.thisPartActivationListener = new ActivationPartListener();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)this.thisPartActivationListener);
    }

    public void dispose() {
        if (this.generateReportAction != null) {
            CloverPlugin.getInstance().getCoverageMonitor().removeCoverageChangeListener(this.generateReportAction);
            this.treeViewer.removeSelectionChangedListener((ISelectionChangedListener)this.generateReportAction);
            this.generateReportAction.dispose();
        }
        if (this.thisPartActivationListener != null) {
            this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this.thisPartActivationListener);
        }
        if (this.alertContainer != null) {
            CloverPlugin.getInstance().getCoverageMonitor().removeCoverageChangeListener(this.alertContainer);
        }
        super.dispose();
    }

    public Tree getTree() {
        return this.tree;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setFocus() {
        this.tree.setFocus();
    }

    public void setHierarchyStyle(int style) {
        this.settings.setHierarchyStyle(style);
        this.treeContentProvider.setNodeBuilder(this.settings.nodeBuilderForStyle());
        this.refresh(false);
    }

    public int getHierarchyStyle() {
        return this.settings.getHierarchyStyle();
    }

    public void refresh(boolean preserveExpansion) {
        this.refresh(preserveExpansion, ENTIRE_WORKSPACE);
    }

    public void refresh() {
        this.refresh(true, ENTIRE_WORKSPACE);
    }

    public ColumnManager getTreeColumnManager() {
        return this.treeColumnManager;
    }

    protected void buildTree() {
        this.tree = new Tree(this.getTreeParent(), 17158);
        this.tree.setLinesVisible(true);
        this.tree.setHeaderVisible(true);
    }

    protected Composite getTreeParent() {
        return this.mainContent;
    }

    protected void buildTreeViewer() {
        this.treeContentProvider = this.newContentProvider();
        ExplorerViewLabelProvider labelprovider = this.newLabelProvider();
        this.treeViewer = new TreeViewer(this.tree);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeViewer.setAutoExpandLevel(this.getAutoExpandLevel());
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelprovider);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                for (SelectionDispatchAction action : ExplorerView.this.actions) {
                    action.selectionChanged((IStructuredSelection)event.getSelection());
                    for (ActionGroup actionGroup : ExplorerView.this.actionGroups) {
                        actionGroup.setContext(new ActionContext(event.getSelection()));
                    }
                }
            }
        });
    }

    private void buildTreeColumns() {
        this.treeViewer.getControl().setRedraw(false);
        try {
            this.rebuildTreeColumns();
            this.tree.setSortColumn(this.columns.get(this.settings.getTreeColumnSettings().getSortedColumn()));
            this.tree.setSortDirection(this.settings.getTreeColumnSettings().isReverseSort() ? 1024 : 128);
        }
        finally {
            this.treeViewer.getControl().setRedraw(true);
        }
    }

    protected void buildTreeSorter() {
        this.treeViewer.getControl().setRedraw(false);
        try {
            this.tree.setSortColumn(this.columns.get(this.settings.getTreeColumnSettings().getSortedColumn()));
            this.tree.setSortDirection(this.settings.getTreeColumnSettings().isReverseSort() ? 128 : 1024);
            TreePath[] expanded = this.treeViewer.getExpandedTreePaths();
            this.treeViewer.setComparator(this.newTreeViewComparator());
            this.treeViewer.setExpandedTreePaths(expanded);
        }
        finally {
            this.treeViewer.getControl().setRedraw(true);
        }
    }

    protected void wireGlobalActions() {
        this.actionGroups = new ActionGroup[]{new NewWizardsActionGroup((IWorkbenchSite)this.getSite()), new NavigateActionGroup((IViewPart)this), new CCPActionGroup((IViewPart)this), new GenerateBuildPathActionGroup((IViewPart)this), new GenerateActionGroup((IViewPart)this), new RefactorActionGroup((IViewPart)this), new ImportActionGroup((IViewPart)this), new BuildActionGroup((IViewPart)this), new JavaSearchActionGroup((IViewPart)this), new ProjectActionGroup((IViewPart)this)};
        this.actions = new SelectionDispatchAction[1];
        this.actions[0] = new OpenJavaEditorAction((IWorkbenchSite)this.getSite());
        this.getViewSite().getActionBars().setGlobalActionHandler("org.eclipse.jdt.ui.actions.Open", (IAction)this.actions[0]);
        this.generateReportAction = new GenerateReportAction(this);
        CloverPlugin.getInstance().getCoverageMonitor().addCoverageChangeListener(this.generateReportAction);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.generateReportAction);
    }

    protected void buildPartControl(Composite parent) {
        this.alertContainer = new ViewAlertContainer(parent);
        this.mainContent = new SashForm((Composite)this.alertContainer, this.calcViewOrientation());
        this.mainContent.setLayoutData((Object)new GridData(1808));
        this.alertContainer.setContent(this.mainContent);
        this.buildTree();
        this.buildTreeViewer();
        this.buildTreeColumns();
        this.buildTreeSorter();
        this.buildRightHandSide();
        this.getSite().setSelectionProvider((ISelectionProvider)this.buildSelectionProvider());
        this.wireGlobalActions();
        this.wireToolbarActions();
        this.wireContextMenu();
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)new JavaElementDblClickListener(this.actions[0]){

            @Override
            protected void doEditorOpenAlternative(Object selected) {
                ExplorerView.this.treeViewer.setExpandedState(selected, !ExplorerView.this.treeViewer.getExpandedState(selected));
            }
        });
        this.alertContainer.updateLinks();
        CloverPlugin.getInstance().getCoverageMonitor().addCoverageChangeListener(this.alertContainer);
    }

    protected abstract TreeViewer buildSelectionProvider();

    protected void wireToolbarActions() {
        this.buildToolbarStructure();
        this.buildMenubarStructure();
        for (ActionGroup actionGroup : this.actionGroups) {
            actionGroup.fillActionBars(this.getViewSite().getActionBars());
        }
    }

    protected abstract void buildToolbarStructure();

    protected abstract void buildMenubarStructure();

    protected void wireContextMenu() {
        MenuManager manager = this.newContextMenuManager();
        Menu menu = manager.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.treeViewer);
    }

    protected MenuManager newContextMenuManager() {
        MenuManager manager = new MenuManager("#PopupMenu");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ExplorerView.this.fillContextMenu(manager);
            }
        });
        return manager;
    }

    public void refresh(final boolean preserveAutoExpansion, final Object[] elements) {
        if (elements.length > 0) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ExplorerView.this.doRefreshWorkFor(preserveAutoExpansion, elements);
                }
            });
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("project.ops"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("project.reports"));
        manager.add((IAction)this.generateReportAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("group.new"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("group.open"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("group.edit"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("group.reorganize"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("group.goto"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("group.build"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("group.search"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("group.properties"));
        for (ActionGroup actionGroup : this.actionGroups) {
            actionGroup.setContext(new ActionContext(this.treeViewer.getSelection()));
            try {
                actionGroup.fillContextMenu(manager);
            }
            catch (Exception e) {
                CloverPlugin.logError("Failed to fully construct context menu", e);
            }
        }
    }

    @Override
    protected int getAssumedViewOrientationIfUnknowable() {
        return 256;
    }

    protected void nudgeSelectionListeners() {
        try {
            this.treeViewer.setSelection(this.treeViewer.getSelection());
        }
        catch (Exception e) {
            CloverPlugin.logError("Error nudging selection listeners", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRefreshWorkFor(boolean preserveExpandedPaths, Object[] elements) {
        if (!this.tree.isDisposed()) {
            try {
                this.treeViewer.getControl().setRedraw(false);
                TreePath[] expanded = preserveExpandedPaths ? this.treeViewer.getExpandedTreePaths() : null;
                for (Object element : elements) {
                    this.treeViewer.refresh(element);
                }
                if (preserveExpandedPaths) {
                    this.treeViewer.setExpandedTreePaths(expanded);
                } else {
                    this.treeViewer.expandToLevel(this.settings.expandDepthForStyle());
                }
            }
            finally {
                this.treeViewer.getControl().setRedraw(true);
            }
            this.nudgeSelectionListeners();
        }
    }

    protected abstract void buildRightHandSide();

    protected abstract CloveredWorkspaceProvider newContentProvider();

    protected abstract ExplorerViewLabelProvider newLabelProvider();

    protected abstract ViewerComparator newTreeViewComparator();

    /*
     * WARNING - void declaration
     */
    private void rebuildTreeColumns() {
        if (this.columns != null) {
            for (Map.Entry<TreeColumn, TreeColumnControlListener> entry : this.columnListeners.entrySet()) {
                TreeColumn treeColumn = entry.getKey();
                TreeColumnControlListener listener = entry.getValue();
                treeColumn.removeControlListener((ControlListener)listener);
                treeColumn.removeSelectionListener((SelectionListener)listener);
            }
            for (Map.Entry<Object, TreeColumnControlListener> entry : this.columns.entrySet()) {
                this.teardownTreeColumn((ColumnDefinition)entry.getKey(), (TreeColumn)entry.getValue());
            }
        }
        this.columnListeners = Maps.newHashMap();
        this.columns = Maps.newLinkedHashMap();
        Map<ColumnDefinition, Integer> columnsToWidths = this.settings.getTreeColumnSettings().getVisibleColumnsToWidths();
        for (Map.Entry<ColumnDefinition, Integer> entry : columnsToWidths.entrySet()) {
            this.buildTreeColumn(entry.getKey(), entry.getValue());
        }
        boolean bl = false;
        for (Map.Entry<ColumnDefinition, TreeColumn> entry : this.columns.entrySet()) {
            void var2_7;
            ColumnDefinition columnDef = entry.getKey();
            TreeColumn column = entry.getValue();
            TreeColumnControlListener listener = new TreeColumnControlListener(this.treeColumnController, this.treeColumnLabeler, this.treeViewer, this.settings.getTreeColumnSettings(), column, (int)(++var2_7), columnDef);
            column.addControlListener((ControlListener)listener);
            column.addSelectionListener((SelectionListener)listener);
            this.columnListeners.put(column, listener);
        }
    }

    private void buildTreeColumn(ColumnDefinition columnDef, Integer width) {
        TreeColumn column = ColumnBuilder.buildTreeColumn(columnDef, this.tree, this.treeColumnLabeler);
        column.setWidth(width.intValue());
        columnDef.bindRenderer((Composite)this.tree, this.settings);
        this.columns.put(columnDef, column);
    }

    private void teardownTreeColumn(ColumnDefinition columnDefinition, TreeColumn column) {
        columnDefinition.unbindRenderer((Composite)column.getParent());
        column.dispose();
    }

    public int getAutoExpandLevel() {
        return 2;
    }

    public class TreeColumnManager
    extends ColumnManager {
        @Override
        public ColumnDefinition[] getAllColumns() {
            Set allColumns = ExplorerView.this.settings.getTreeColumnSettings().getAllColumns();
            return allColumns.toArray(new ColumnDefinition[allColumns.size()]);
        }

        @Override
        public ColumnDefinition[] getVisibleColumns() {
            List visibleColumns = ExplorerView.this.settings.getTreeColumnSettings().getVisibleColumns();
            return visibleColumns.toArray(new ColumnDefinition[visibleColumns.size()]);
        }

        @Override
        public void update(final CustomColumnDefinition[] custom, final ColumnDefinition[] visible) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ExplorerView.this.settings.getTreeColumnSettings().update(custom, visible);
                    ExplorerView.this.rebuildTreeColumns();
                    ExplorerView.this.treeViewer.refresh();
                }
            });
        }
    }

    private class ActivationPartListener
    implements IPartListener2 {
        private ActivationPartListener() {
        }

        public void partActivated(IWorkbenchPartReference workbenchPartReference) {
            IWorkbenchPart part = workbenchPartReference.getPart(false);
            if (part == ExplorerView.this) {
                ExplorerView.this.nudgeSelectionListeners();
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference workbenchPartReference) {
        }

        public void partClosed(IWorkbenchPartReference workbenchPartReference) {
        }

        public void partDeactivated(IWorkbenchPartReference workbenchPartReference) {
        }

        public void partOpened(IWorkbenchPartReference workbenchPartReference) {
        }

        public void partHidden(IWorkbenchPartReference workbenchPartReference) {
        }

        public void partVisible(IWorkbenchPartReference workbenchPartReference) {
        }

        public void partInputChanged(IWorkbenchPartReference workbenchPartReference) {
        }
    }

    protected abstract class JavaElementDblClickListener
    implements IDoubleClickListener {
        private SelectionDispatchAction action;

        protected JavaElementDblClickListener(SelectionDispatchAction action) {
            this.action = action;
        }

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object selected = selection.getFirstElement();
            if (selected instanceof IAdaptable) {
                IJavaElement selectedJavaElement = (IJavaElement)((IAdaptable)selected).getAdapter(IJavaElement.class);
                if (this.shouldOpenEditor(event, selectedJavaElement)) {
                    this.action.run((IStructuredSelection)new StructuredSelection((Object)selectedJavaElement));
                } else {
                    this.doEditorOpenAlternative(selected);
                }
            }
        }

        protected abstract void doEditorOpenAlternative(Object var1);

        boolean shouldOpenEditor(DoubleClickEvent event, IJavaElement selectedJavaElement) {
            return !(selectedJavaElement instanceof IJavaProject) && !(selectedJavaElement instanceof IPackageFragmentRoot) && !(selectedJavaElement instanceof IPackageFragment);
        }
    }
}

