/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.workingset;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.util.Lists;

public class CloverWorkingSet {
    private String CLOVER_WORKING_SET_NAME = CloverEclipsePluginMessages.CLOVER_WORKING_SET();
    private final IWorkingSetManager workingSetManager;
    private IWorkingSet mCachedWorkingSet;
    private IAdaptable[] mCachedElements;
    private List<IJavaElement> mCachedJavaElements;
    private final List<File> mMatchingFiles = Lists.newArrayList();
    private final List<File> mMatchingPackageDirs = Lists.newArrayList();
    private final List<File> mMatchingRootDirs = Lists.newArrayList();

    public CloverWorkingSet(IWorkingSetManager workingSetManager) {
        this.workingSetManager = workingSetManager;
        this.addChangeListener();
    }

    public boolean isWorkingSetMode() {
        return CloverPlugin.getInstance().isInWorkingSetMode();
    }

    private void checkCache() {
        if (this.mCachedWorkingSet != null) {
            return;
        }
        IWorkingSet ws = this.workingSetManager.getWorkingSet(this.CLOVER_WORKING_SET_NAME);
        if (ws == null) {
            ws = this.workingSetManager.createWorkingSet(this.CLOVER_WORKING_SET_NAME, new IAdaptable[0]);
            ws.setId("org.eclipse.jdt.ui.JavaWorkingSetPage");
            this.workingSetManager.addWorkingSet(ws);
        }
        this.mCachedWorkingSet = ws;
        this.mCachedElements = ws.getElements();
        this.extractCurrentJavaElements(this.mCachedElements);
    }

    public IWorkingSet getWorkingSet() {
        this.checkCache();
        return this.mCachedWorkingSet;
    }

    public void setElements(IAdaptable[] elements) {
        this.getWorkingSet().setElements(elements);
        this.clearCache();
    }

    public List getMatchingFiles() {
        this.checkCache();
        return Collections.unmodifiableList(this.mMatchingFiles);
    }

    public List getMatchingPackageDirs() {
        this.checkCache();
        return Collections.unmodifiableList(this.mMatchingPackageDirs);
    }

    public List getMatchingRootDirs() {
        this.checkCache();
        return Collections.unmodifiableList(this.mMatchingRootDirs);
    }

    public void toggleInclusion(List toggleList, IProgressMonitor monitor) throws CoreException {
        this.checkCache();
        for (Object o : toggleList) {
            IResource res;
            IJavaElement je = CloverWorkingSet.asJavaElement(o);
            if (je == null) continue;
            if (this.mCachedJavaElements.contains(je)) {
                this.mCachedJavaElements.remove(je);
            } else {
                this.mCachedJavaElements.add(je);
            }
            if ((res = je.getResource()) == null) continue;
            je.getResource().touch(monitor);
        }
        this.setElements(this.mCachedJavaElements.toArray(new IAdaptable[this.mCachedJavaElements.size()]));
    }

    private void extractCurrentJavaElements(IAdaptable[] current) {
        this.mCachedJavaElements = new ArrayList<IJavaElement>(current.length);
        this.mMatchingFiles.clear();
        this.mMatchingPackageDirs.clear();
        this.mMatchingRootDirs.clear();
        for (IAdaptable a : current) {
            IJavaElement je = CloverWorkingSet.asJavaElement(a);
            if (je == null) continue;
            IResource r = je.getResource();
            this.mCachedJavaElements.add(je);
            if (r == null || r.getLocation() == null) continue;
            try {
                File file = r.getLocation().toFile();
                File file2 = file = file == null ? null : file.getCanonicalFile();
                if (file == null) continue;
                if (je instanceof IPackageFragment) {
                    this.mMatchingPackageDirs.add(file);
                    continue;
                }
                if (je instanceof ICompilationUnit) {
                    this.mMatchingFiles.add(file);
                    continue;
                }
                if (!(je instanceof IJavaProject) && !(je instanceof IPackageFragmentRoot)) continue;
                this.mMatchingRootDirs.add(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean includes(IAdaptable adaptable) {
        IJavaElement je = CloverWorkingSet.asJavaElement(adaptable);
        if (je != null) {
            if (je instanceof IMethod) {
                return this.includesCU((IAdaptable)((IMethod)je).getCompilationUnit());
            }
            if (je instanceof ICompilationUnit) {
                return this.includesCU(adaptable);
            }
            if (je instanceof IPackageFragment) {
                return this.includesExamplePackageFragment(adaptable);
            }
            if (je instanceof IPackageFragmentRoot) {
                return this.includesPackageFragmentRoot(adaptable);
            }
            if (je instanceof IJavaProject) {
                return this.includesJavaProject(adaptable);
            }
            return true;
        }
        return false;
    }

    public boolean includesFile(File path) {
        String pathName = path.toString();
        for (File expected : this.mMatchingFiles) {
            if (!expected.equals(path)) continue;
            return true;
        }
        for (File dir : this.mMatchingPackageDirs) {
            if (!dir.equals(path.getParentFile())) continue;
            return true;
        }
        for (File root : this.mMatchingRootDirs) {
            if (!pathName.startsWith(root.getPath())) continue;
            return true;
        }
        return false;
    }

    public boolean includesCU(IAdaptable adaptable) {
        File path;
        this.checkCache();
        IJavaElement je = CloverWorkingSet.asJavaElement(adaptable);
        IResource resource = je == null ? null : je.getResource();
        IPath ipath = resource == null ? null : resource.getLocation();
        File file = path = ipath == null ? null : ipath.toFile();
        if (path != null) {
            return this.includesFile(path);
        }
        return false;
    }

    public boolean includesExamplePackageFragment(IAdaptable adaptable) {
        this.checkCache();
        try {
            IPackageFragment fragment = (IPackageFragment)CloverWorkingSet.asJavaElement(adaptable);
            if (fragment != null) {
                IPackageFragmentRoot[] allFragmentRoots = fragment.getJavaProject().getPackageFragmentRoots();
                ArrayList<IPackageFragment> allSimilarPackages = new ArrayList<IPackageFragment>(allFragmentRoots.length);
                for (IPackageFragmentRoot allFragmentRoot : allFragmentRoots) {
                    IPackageFragment packageFragment;
                    if (allFragmentRoot.getKind() != 1 || (packageFragment = allFragmentRoot.getPackageFragment(fragment.getElementName())) == null) continue;
                    allSimilarPackages.add(packageFragment);
                }
                return this.includesAnyPackageFragments(allSimilarPackages);
            }
        }
        catch (JavaModelException e) {
            CloverPlugin.logError("Unable to query all package fragments", e);
        }
        return false;
    }

    private boolean includesAnyPackageFragments(List<IPackageFragment> fragments) {
        boolean includes = false;
        for (IPackageFragment fragment : fragments) {
            if (!(includes = includes || this.includesPackageFragment(fragment))) continue;
            break;
        }
        return includes;
    }

    private boolean includesPackageFragment(IPackageFragment fragment) {
        this.checkCache();
        IPath projectLocation = fragment.getResource().getLocation();
        return this.includes(new List[]{this.mMatchingFiles}, new List[]{this.mMatchingPackageDirs, this.mMatchingRootDirs}, projectLocation);
    }

    public boolean includesJavaProject(IAdaptable adaptable) {
        this.checkCache();
        IJavaElement je = CloverWorkingSet.asJavaElement(adaptable);
        if (je != null) {
            IPath projectLocation = je.getResource().getLocation();
            return this.includes(new List[]{this.mMatchingFiles, this.mMatchingPackageDirs, this.mMatchingRootDirs}, new List[0], projectLocation);
        }
        return false;
    }

    private boolean includes(List<File>[] children, List<File>[] peers, IPath resourcePath) {
        for (List<File> match : children) {
            for (File expected : match) {
                if (new Path(expected.toString()).matchingFirstSegments(resourcePath) != resourcePath.segmentCount()) continue;
                return true;
            }
        }
        for (List<File> match : peers) {
            for (File expected : match) {
                Path expectedPath = new Path(expected.toString());
                if (resourcePath.matchingFirstSegments((IPath)expectedPath) != expectedPath.segmentCount()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean includesPackageFragmentRoot(IAdaptable adaptable) {
        this.checkCache();
        IJavaElement je = CloverWorkingSet.asJavaElement(adaptable);
        if (je != null) {
            IPath projectLocation = je.getResource().getLocation();
            return this.includes(new List[]{this.mMatchingFiles, this.mMatchingPackageDirs}, new List[]{this.mMatchingRootDirs}, projectLocation);
        }
        return false;
    }

    private static IJavaElement asJavaElement(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof IAdaptable)) {
            return null;
        }
        IAdaptable a = (IAdaptable)o;
        return (IJavaElement)a.getAdapter(IJavaElement.class);
    }

    private void addChangeListener() {
        this.workingSetManager.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                IWorkingSet ws;
                boolean refresh = false;
                String property = event.getProperty();
                if ("workingSetContentChange".equals(property)) {
                    IWorkingSet ws2 = (IWorkingSet)event.getNewValue();
                    if (ws2.getName().equals(CloverWorkingSet.this.CLOVER_WORKING_SET_NAME)) {
                        refresh = true;
                    }
                } else if ("workingSetNameChange".equals(property)) {
                    refresh = true;
                } else if ("workingSetRemove".equals(property) && (ws = (IWorkingSet)event.getOldValue()).getName().equals(CloverWorkingSet.this.CLOVER_WORKING_SET_NAME)) {
                    refresh = true;
                }
                if (refresh) {
                    CloverWorkingSet.this.clearCache();
                    if (CloverPlugin.getInstance().isInWorkingSetMode()) {
                        CloverProject.refreshAllModels(true, true);
                    }
                }
            }
        });
    }

    private void clearCache() {
        this.mCachedWorkingSet = null;
    }
}

