/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.widgets;

import com.atlassian.clover.context.ContextStore;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.projects.settings.RegexpEntry;
import org.openclover.eclipse.core.ui.SwtUtils;

class RegexpFilterEditDialog
extends Dialog {
    private Text nameField;
    private Combo typeCombo;
    private Text regexpField;
    private List<RegexpEntry> regexps;
    private RegexpEntry data;
    private Label instructionsLabel;

    protected RegexpFilterEditDialog(Shell parentShell, List<RegexpEntry> regexps) {
        super(parentShell);
        this.setShellStyle(68720);
        this.regexps = regexps;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit Regular Expression Filter");
    }

    protected void setData(RegexpEntry regexp) {
        this.data = regexp;
    }

    protected RegexpEntry getData() {
        return this.data;
    }

    protected void okPressed() {
        String errorMessage = null;
        if (this.nameField.getText().trim().length() == 0) {
            errorMessage = "Context names must not be blank.";
        } else if (this.nameField.getText().indexOf(32) != -1 || this.nameField.getText().indexOf(44) != -1) {
            errorMessage = "Context names may not contain spaces or commas.";
        } else if (ContextStore.isReservedName(this.nameField.getText())) {
            errorMessage = "This context name is reserved for use by Clover.";
        } else {
            for (RegexpEntry regexpEntry : this.regexps) {
                if (regexpEntry == this.data || !regexpEntry.getName().equals(this.nameField.getText())) continue;
                errorMessage = "This context name is already in use.";
            }
            if (errorMessage == null) {
                try {
                    Pattern.compile(this.regexpField.getText());
                }
                catch (Exception e) {
                    errorMessage = "The regular expression is not valid:\n" + e.getMessage();
                }
            }
        }
        if (errorMessage != null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)errorMessage);
        } else {
            this.data.setName(this.nameField.getText());
            this.data.setRegexp(this.regexpField.getText());
            if (this.typeCombo.getSelectionIndex() == 0) {
                this.data.setType(0);
            } else {
                this.data.setType(1);
            }
            this.data.setChanged(true);
            super.okPressed();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        contents.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(contents, 0);
        nameLabel.setText("Name:");
        this.nameField = new Text(contents, 2048);
        this.nameField.setLayoutData((Object)new GridData(768));
        Label typeLabel = new Label(contents, 0);
        typeLabel.setText("Type:");
        this.typeCombo = new Combo(contents, 2060);
        this.typeCombo.add("Method");
        this.typeCombo.add("Statement");
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (RegexpFilterEditDialog.this.typeCombo.getSelectionIndex() == 0) {
                    RegexpFilterEditDialog.this.instructionsLabel.setText(CloverEclipsePluginMessages.METHOD_CONTEXT_FILTER_INSTRUCTIONS());
                } else {
                    RegexpFilterEditDialog.this.instructionsLabel.setText(CloverEclipsePluginMessages.STATEMENT_CONTEXT_FILTER_INSTRUCTIONS());
                }
                RegexpFilterEditDialog.this.getShell().layout();
            }
        });
        this.typeCombo.setLayoutData((Object)new GridData(768));
        Label regexpLabel = new Label(contents, 0);
        regexpLabel.setText("Regular Expression:");
        regexpLabel.setLayoutData((Object)new GridData(2));
        this.regexpField = new Text(contents, 2050);
        this.regexpField.setLayoutData((Object)new GridData(1808));
        ((GridData)this.regexpField.getLayoutData()).widthHint = 200;
        ((GridData)this.regexpField.getLayoutData()).heightHint = 75;
        new Label(contents, 0);
        int maxInstructionWidth = Math.max(CloverEclipsePluginMessages.METHOD_CONTEXT_FILTER_INSTRUCTIONS().length(), CloverEclipsePluginMessages.STATEMENT_CONTEXT_FILTER_INSTRUCTIONS().length());
        this.instructionsLabel = SwtUtils.createMultilineLabel(contents, CloverEclipsePluginMessages.METHOD_CONTEXT_FILTER_INSTRUCTIONS(), this.convertWidthInCharsToPixels(maxInstructionWidth / 5));
        this.nameField.setText(this.data.getName());
        this.regexpField.setText(this.data.getRegexp());
        if (this.data.getType() == 0) {
            this.typeCombo.select(0);
        } else {
            this.typeCombo.select(1);
        }
        return contents;
    }
}

