/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.widgets;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.settings.ProjectSettings;
import org.openclover.eclipse.core.settings.InstallationSettings;
import org.openclover.eclipse.core.ui.widgets.BuiltinContextFilterSelectionWidget;
import org.openclover.eclipse.core.ui.widgets.MessageDialogWithCheckbox;
import org.openclover.eclipse.core.ui.widgets.RegexContextFilterModificationWidget;

public class ContextFilterModificationWidget
extends Composite {
    private BuiltinContextFilterSelectionWidget blockFilter;
    private RegexContextFilterModificationWidget regexFilter;
    private ProjectSettings properties;

    public ContextFilterModificationWidget(Composite composite, ProjectSettings properties) {
        super(composite, 0);
        this.properties = properties;
        this.setLayout((Layout)new GridLayout());
        Group blockContexts = new Group((Composite)this, 0);
        blockContexts.setText("Standard Coverage Contexts Filters");
        blockContexts.setLayoutData((Object)new GridData(1808));
        blockContexts.setLayout((Layout)new GridLayout());
        this.blockFilter = new BuiltinContextFilterSelectionWidget((Composite)blockContexts, properties.getContextRegistry(), properties.getContextFilter());
        this.blockFilter.buildContents();
        this.blockFilter.updateSelection();
        this.blockFilter.setLayoutData(new GridData(768));
        Group regexContexts = new Group((Composite)this, 0);
        regexContexts.setText("Custom Coverage Context Filters");
        regexContexts.setLayoutData((Object)new GridData(1808));
        regexContexts.setLayout((Layout)new GridLayout());
        this.regexFilter = new RegexContextFilterModificationWidget((Composite)regexContexts, properties);
        this.regexFilter.setLayoutData(new GridData(1808));
    }

    public void store() {
        this.regexFilter.store();
        this.blockFilter.storeTo(this.properties);
    }

    public boolean isRebuildRequired() {
        return this.regexFilter.isRebuildRequired();
    }

    public boolean alertIfManualRebuildRequired() {
        if (this.isRebuildRequired()) {
            InstallationSettings installationSettings = CloverPlugin.getInstance().getInstallationSettings();
            if (installationSettings.isPromptingOnContextChange()) {
                MessageDialogWithCheckbox.Result result = new MessageDialogWithCheckbox.Result();
                MessageDialogWithCheckbox.openQuestion(null, "Custom Coverage Context Filters", "You have changed one or more regular expression context filters. A clean rebuild\nof your project is required for these changes to take effect. Rebuild now?", true, "Display this prompt again?", true, result);
                installationSettings.setLatestPromptOnContextChange(result.isYesSelected());
                installationSettings.setPromptingOnContextChange(result.isChecked());
                return result.isYesSelected();
            }
            return installationSettings.isRebuildingOnContextChange();
        }
        return false;
    }
}

