/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.editors.java;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.registry.entities.FullBranchInfo;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullStatementInfo;
import com.atlassian.clover.registry.entities.LineInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.ui.editors.java.AnnotationCalculationJob;
import org.openclover.eclipse.core.ui.editors.java.AnnotationDisplayListener;
import org.openclover.eclipse.core.ui.editors.java.AnnotationUpdateRule;
import org.openclover.eclipse.core.ui.editors.java.CoverageAnnotation;
import org.openclover.eclipse.core.ui.editors.java.CoverageAnnotationFilter;
import org.openclover.eclipse.core.ui.editors.java.CoverageBeginning;
import org.openclover.eclipse.core.ui.editors.java.CoverageEdge;
import org.openclover.eclipse.core.ui.editors.java.CoverageEdgeComparator;
import org.openclover.eclipse.core.ui.editors.java.CoverageEnd;
import org.openclover.eclipse.core.ui.editors.java.EditorCoverageSynchronizer;
import org.openclover.eclipse.core.ui.editors.java.ILineCoverageModel;
import org.openclover.eclipse.core.ui.editors.java.LineCoverageModelImpl;
import org.openclover.eclipse.core.ui.editors.java.annotations.strategies.space.CoverageAnnotationSpaceBuilder;
import org.openclover.eclipse.core.ui.projects.DatabaseChangeEvent;
import org.openclover.eclipse.core.ui.projects.DatabaseChangeListener;
import org.openclover.util.Lists;
import org.openclover.util.Sets;
import org.openclover.util.function.Function;
import org.openclover.util.function.TransformingIterator;

public class CoverageAnnotationModel
implements IAnnotationModel,
IDocumentListener,
DatabaseChangeListener,
AnnotationDisplayListener,
ISchedulingRule {
    private static final Object MODEL_KEY = new Object();
    private static final CoverageEdgeComparator EDGE_COMPARATOR = new CoverageEdgeComparator();
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("^(\\s)+$");
    private static final List<CoverageAnnotation> ANNOTATIONS_OFF = Collections.unmodifiableList(new LinkedList());
    private final ITextEditor editor;
    private final IDocument document;
    private final EditorCoverageSynchronizer synchronizer;
    private final List<IAnnotationModelListener> listeners;
    private final AnnotationUpdateRule updateRule;
    private List<CoverageAnnotation> annotations;
    private ILineCoverageModel lineCoverageModel;
    private int connectionCount;

    public CoverageAnnotationModel(ITextEditor editor, IDocument document, EditorCoverageSynchronizer synchronizer) {
        this.editor = editor;
        this.document = document;
        this.synchronizer = synchronizer;
        this.listeners = Collections.synchronizedList(new LinkedList());
        this.annotations = Collections.emptyList();
        this.updateRule = new AnnotationUpdateRule();
    }

    public void refreshAsync() {
        new AnnotationCalculationJob(this.updateRule){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    CoverageAnnotationModel.this.refreshSync();
                }
                catch (Throwable t) {
                    CloverPlugin.logError("Error when rebuilding annotation model for changed document", t);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void refreshSync() throws BadLocationException {
        CloverPlugin.logVerbose("Refreshing annotations for editor " + this.editor.getTitle());
        this.fireAnnotationsChanged(this.rebuildAnnotations(this.editor.isDirty()));
    }

    private CoverageAnnotationFilter syncFilter(CloverDatabase database, FullFileInfo fileInfo, Map<TestCaseInfo, BitSet> tcisAndHitsForFile, ContextSet blockFilter) {
        IResource editedResource = (IResource)this.editor.getEditorInput().getAdapter(IResource.class);
        if (editedResource != null) {
            return CoverageAnnotationFilter.loadFor(database, fileInfo, tcisAndHitsForFile, editedResource, CloverPlugin.getInstance().getInstallationSettings().getEditorCoverageStyle() == 1, blockFilter);
        }
        return CoverageAnnotationFilter.NULL;
    }

    public void connect(IDocument document) {
        try {
            if (document == this.document) {
                if (this.incrementConnectionCount()) {
                    this.createAnnotations();
                    document.addDocumentListener((IDocumentListener)this);
                    CloverPlugin.getInstance().getCoverageMonitor().addCoverageChangeListener(this);
                    this.synchronizer.addAnnotationDisplayListener(this);
                }
                this.createDocumentPositions();
            }
        }
        catch (Throwable t) {
            CloverPlugin.logError("Error when annotation model connects to source file", t);
        }
    }

    public void disconnect(IDocument document) {
        try {
            if (document == this.document) {
                this.clearDocumentPositions();
                if (this.decrementConnectionCount()) {
                    CloverPlugin.getInstance().getCoverageMonitor().removeCoverageChangeListener(this);
                    this.synchronizer.removeAnnotationDisplayListener(this);
                    document.removeDocumentListener((IDocumentListener)this);
                    new AnnotationCalculationJob(this.updateRule){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                CoverageAnnotationModel.this.fireAnnotationsChanged(CoverageAnnotationModel.this.turnAnnotationsOff());
                            }
                            catch (Throwable t) {
                                CloverPlugin.logError("Error when rebuilding annotation model for changed document", t);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
        }
        catch (Throwable t) {
            CloverPlugin.logError("Error when annotation model disconnects from source file", t);
        }
    }

    private void createDocumentPositions() {
        try {
            List<CoverageAnnotation> annotations = this.annotations;
            for (CoverageAnnotation annotation : annotations) {
                this.document.addPosition(annotation.getPosition());
            }
        }
        catch (BadLocationException e) {
            CloverPlugin.logError("Unable to add position for coverage annotation", e);
        }
    }

    private void clearDocumentPositions() {
        List<CoverageAnnotation> annotations = this.annotations;
        for (CoverageAnnotation annotation : annotations) {
            this.document.removePosition(annotation.getPosition());
        }
    }

    private boolean incrementConnectionCount() {
        return this.connectionCount++ == 0;
    }

    private boolean decrementConnectionCount() {
        return --this.connectionCount == 0;
    }

    private FullFileInfo cloverFileInfoForEditorInput() {
        IJavaElement element = JavaUI.getEditorInputJavaElement((IEditorInput)this.editor.getEditorInput());
        return element != null ? (FullFileInfo)MetricsScope.FULL.getHasMetricsFor(element, FullFileInfo.class) : null;
    }

    public CloverDatabase cloverDatabaseForEditorInput() {
        CloverProject project = this.cloverProjectForEditorInput();
        return project == null ? null : project.getModel().getDatabase();
    }

    private CloverProject cloverProjectForEditorInput() {
        IJavaElement element = JavaUI.getEditorInputJavaElement((IEditorInput)this.editor.getEditorInput());
        return this.cloverProjectFor(element);
    }

    private CloverProject cloverProjectFor(IJavaElement element) {
        return element != null ? (CloverProject)element.getAdapter(CloverProject.class) : null;
    }

    public ContextSet blockFilterForEditorInput() {
        CloverProject project = this.cloverProjectForEditorInput();
        return project == null ? new ContextSet() : project.getSettings().getContextFilter();
    }

    private AnnotationModelEvent createAnnotations() throws BadLocationException {
        return this.createAnnotations(new AnnotationModelEvent((IAnnotationModel)this, true));
    }

    private AnnotationModelEvent createAnnotations(AnnotationModelEvent event) throws BadLocationException {
        CloverDatabase database = this.cloverDatabaseForEditorInput();
        FullFileInfo fileInfo = this.cloverFileInfoForEditorInput();
        if (database != null && fileInfo != null && fileInfo.validatePhysicalFile()) {
            Map<TestCaseInfo, BitSet> tcisAndHitsForFile = Collections.unmodifiableMap(database.mapTestsAndCoverageForFile(fileInfo));
            CoverageAnnotationFilter filter = this.syncFilter(database, fileInfo, tcisAndHitsForFile, this.blockFilterForEditorInput());
            try {
                LineInfo[] lineInfos = fileInfo.getLineInfo(true, true);
                this.lineCoverageModel = new LineCoverageModelImpl(database, fileInfo);
                HashSet<CoverageEdge> beginningsThisLine = Sets.newHashSet();
                Set[] endingsPerLine = new Set[lineInfos.length];
                CoverageAnnotationSpaceBuilder annotationBuilder = new CoverageAnnotationSpaceBuilder(database, this.document, tcisAndHitsForFile);
                for (int i = 0; i < lineInfos.length; ++i) {
                    LineInfo lineInfo = lineInfos[i];
                    if (lineInfo == null && endingsPerLine[i] == null) continue;
                    FullClassInfo[] classInfos = lineInfo == null ? null : lineInfo.getClassStarts();
                    FullMethodInfo[] methodInfos = lineInfo == null ? null : lineInfo.getMethodStarts();
                    FullStatementInfo[] statementInfos = lineInfo == null ? null : lineInfo.getStatements();
                    FullBranchInfo[] branchInfos = lineInfo == null ? null : lineInfo.getBranches();
                    this.assembleEdges(filter, new SourceInfo[][]{classInfos, methodInfos, statementInfos, branchInfos}, beginningsThisLine, endingsPerLine);
                    TreeSet<CoverageEdge> edgesThisLine = Sets.newTreeSet(EDGE_COMPARATOR);
                    edgesThisLine.addAll(beginningsThisLine);
                    edgesThisLine.addAll(endingsPerLine[i] == null ? Collections.emptySet() : endingsPerLine[i]);
                    for (CoverageEdge edgeThisLine : edgesThisLine) {
                        edgeThisLine.register(annotationBuilder, filter);
                    }
                    beginningsThisLine.clear();
                    Set endingsForThisLine = endingsPerLine[i];
                    if (endingsForThisLine == null) continue;
                    endingsForThisLine.clear();
                    endingsPerLine[i] = null;
                }
                TreeSet<CoverageAnnotation> annotations = Sets.newTreeSet(new Comparator<CoverageAnnotation>(){

                    @Override
                    public int compare(CoverageAnnotation annotation1, CoverageAnnotation annotation2) {
                        Position position1 = annotation1.getPosition();
                        Position position2 = annotation2.getPosition();
                        if (position1.getOffset() < position2.getOffset()) {
                            return -1;
                        }
                        if (position1.getOffset() > position2.getOffset()) {
                            return 1;
                        }
                        if (position1.getLength() < position2.getLength()) {
                            return -1;
                        }
                        if (position1.getLength() > position2.getLength()) {
                            return 1;
                        }
                        return 0;
                    }
                });
                annotationBuilder.toAnnotations(annotations);
                CoverageAnnotation previous = null;
                for (CoverageAnnotation current : annotations) {
                    IRegion lineRegion = this.document.getLineInformationOfOffset(current.getPosition().getOffset());
                    int lineStartOffset = lineRegion.getOffset();
                    String leadingSpace = this.document.get(lineRegion.getOffset(), current.getPosition().getOffset() - lineRegion.getOffset());
                    if (WHITESPACE_PATTERN.matcher(leadingSpace).matches()) {
                        int displacement = current.getPosition().getOffset() - lineStartOffset;
                        current.reposition(lineStartOffset, current.getPosition().getLength() + displacement);
                        if (previous != null && previous.encloses(lineStartOffset)) {
                            previous.reposition(previous.getPosition().getOffset(), Math.max(0, previous.getPosition().getLength() - displacement));
                        }
                    }
                    previous = current;
                }
                for (CoverageAnnotation annotation : annotations) {
                    event.annotationAdded((Annotation)annotation);
                }
                this.annotations = Collections.unmodifiableList(Lists.newLinkedList(annotations));
            }
            catch (BadLocationException e) {
                CloverPlugin.logError("Unable to annotate " + fileInfo.getName(), e);
                throw e;
            }
        }
        return event;
    }

    private void assembleEdges(CoverageAnnotationFilter filter, SourceInfo[][] collectionOfInfos, Set<CoverageEdge> beginnings, Set<CoverageEdge>[] endingsByLine) {
        boolean shouldLogErrors = CloverPlugin.isLoggingDebugFor("/annotation-errors/debug");
        for (SourceInfo[] infos : collectionOfInfos) {
            if (infos == null) continue;
            for (SourceInfo info : infos) {
                String endLine;
                String startLine;
                if (!this.smellsBad(info) && !(info instanceof ClassInfo) && filter.includes(info)) {
                    Set<CoverageEdge> infoSet = endingsByLine[info.getEndLine()];
                    if (infoSet == null) {
                        endingsByLine[info.getEndLine()] = infoSet = Sets.newHashSet();
                    }
                    CoverageBeginning beginning = new CoverageBeginning(info);
                    CoverageEnd ending = new CoverageEnd(beginning);
                    beginnings.add(beginning);
                    infoSet.add(ending);
                    continue;
                }
                if (!shouldLogErrors || !this.smellsBad(info)) continue;
                try {
                    IRegion startLineRegion = this.document.getLineInformation(info.getStartLine());
                    startLine = this.document.get(startLineRegion.getOffset(), startLineRegion.getLength());
                }
                catch (BadLocationException e) {
                    startLine = "*unavailable*";
                }
                try {
                    IRegion endLineRegion = this.document.getLineInformation(info.getEndLine());
                    endLine = this.document.get(endLineRegion.getOffset(), endLineRegion.getLength());
                }
                catch (BadLocationException e) {
                    endLine = "*unavailable*";
                }
                CloverPlugin.logError("Bad coverage info dimension: [" + info.getStartLine() + "," + info.getStartColumn() + "]=>[" + info.getEndLine() + "," + info.getEndColumn() + "] text on start line = \n" + startLine + "\ntext on end line = \n" + endLine);
            }
        }
    }

    private boolean smellsBad(SourceInfo info) {
        return info.getStartLine() > info.getEndLine() || info.getStartLine() == info.getEndLine() && info.getStartColumn() > info.getEndColumn();
    }

    private AnnotationModelEvent turnAnnotationsOff() {
        try {
            AnnotationModelEvent annotationModelEvent = this.recordAnnotationsAsRemoved(new AnnotationModelEvent((IAnnotationModel)this, true));
            return annotationModelEvent;
        }
        finally {
            this.annotations = ANNOTATIONS_OFF;
        }
    }

    private AnnotationModelEvent clearAnnotations() {
        try {
            AnnotationModelEvent annotationModelEvent = this.recordAnnotationsAsRemoved(new AnnotationModelEvent((IAnnotationModel)this, true));
            return annotationModelEvent;
        }
        finally {
            this.annotations = Collections.emptyList();
        }
    }

    private AnnotationModelEvent recordAnnotationsAsRemoved(AnnotationModelEvent event) {
        for (CoverageAnnotation annotation : this.annotations) {
            event.annotationRemoved((Annotation)annotation, annotation.getPosition());
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAnnotationsChanged(final AnnotationModelEvent event) {
        if (!event.isEmpty()) {
            LinkedList<IAnnotationModelListener> listeners;
            event.markSealed();
            List<IAnnotationModelListener> list = this.listeners;
            synchronized (list) {
                listeners = Lists.newLinkedList(this.listeners);
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (IAnnotationModelListener listener : listeners) {
                        CoverageAnnotationModel.this.fireAnnotationsChanged(listener, event);
                    }
                }
            });
        }
    }

    private void fireAnnotationsChanged(IAnnotationModelListener listener, AnnotationModelEvent event) {
        if (listener instanceof IAnnotationModelListenerExtension) {
            ((IAnnotationModelListenerExtension)listener).modelChanged(event);
        } else {
            listener.modelChanged((IAnnotationModel)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotationModelListener(IAnnotationModelListener listener) {
        List<IAnnotationModelListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
                this.fireAnnotationsChanged(listener, new AnnotationModelEvent((IAnnotationModel)this, true));
            }
        }
    }

    public void removeAnnotationModelListener(IAnnotationModelListener listener) {
        this.listeners.remove(listener);
    }

    public void addAnnotation(Annotation annotation, Position position) {
        throw new UnsupportedOperationException("External addition of Clover annotations is not supported");
    }

    public void removeAnnotation(Annotation annotation) {
        throw new UnsupportedOperationException("External removal of Clover annotations is not supported");
    }

    public Iterator<Annotation> getAnnotationIterator() {
        return new TransformingIterator(this.annotations.iterator(), new Function<CoverageAnnotation, Annotation>(){

            @Override
            public Annotation apply(CoverageAnnotation coverageAnnotation) {
                return coverageAnnotation;
            }
        });
    }

    public Position getPosition(Annotation annotation) {
        return annotation instanceof CoverageAnnotation ? ((CoverageAnnotation)annotation).getPosition() : null;
    }

    public static void applyTo(ITextEditor editor, EditorCoverageSynchronizer synchronizer) {
        CoverageAnnotationModel[] model;
        final IAnnotationModelExtension compositeModel = CoverageAnnotationModel.getAnnotationModel(editor);
        if (compositeModel != null && (model = new CoverageAnnotationModel[]{CoverageAnnotationModel.getModel(compositeModel)})[0] == null) {
            model[0] = new CoverageAnnotationModel(editor, CoverageAnnotationModel.getEditorDocument(editor), synchronizer);
            new AnnotationCalculationJob(model[0].updateRule){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        compositeModel.addAnnotationModel(MODEL_KEY, (IAnnotationModel)model[0]);
                    }
                    catch (Throwable t) {
                        CloverPlugin.logError("Unable to apply annotations to source file", t);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public static void asyncRemoveFrom(ITextEditor editor) {
        IAnnotationModel model;
        final IAnnotationModelExtension compositeModel = CoverageAnnotationModel.getAnnotationModel(editor);
        if (compositeModel != null && (model = compositeModel.getAnnotationModel(MODEL_KEY)) != null && model instanceof CoverageAnnotationModel) {
            new AnnotationCalculationJob(((CoverageAnnotationModel)model).updateRule){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            ((CoverageAnnotationModel)model).refreshSync();
                        }
                        finally {
                            compositeModel.removeAnnotationModel(MODEL_KEY);
                        }
                    }
                    catch (Throwable t) {
                        CloverPlugin.logError("Unable to remove annotations from source file", t);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public static void removeFrom(ITextEditor editor) {
        IAnnotationModel model;
        IAnnotationModelExtension compositeModel = CoverageAnnotationModel.getAnnotationModel(editor);
        if (compositeModel != null && (model = compositeModel.getAnnotationModel(MODEL_KEY)) != null && model instanceof CoverageAnnotationModel) {
            try {
                try {
                    ((CoverageAnnotationModel)model).refreshSync();
                }
                finally {
                    compositeModel.removeAnnotationModel(MODEL_KEY);
                }
            }
            catch (Throwable t) {
                CloverPlugin.logError("Unable to remove annotations from source file", t);
            }
        }
    }

    public static void removeFrom(ITextEditor editor, boolean async) {
        if (async) {
            CoverageAnnotationModel.asyncRemoveFrom(editor);
        } else {
            CoverageAnnotationModel.removeFrom(editor);
        }
    }

    public static CoverageAnnotationModel getModel(IAnnotationModelExtension model) {
        return (CoverageAnnotationModel)model.getAnnotationModel(MODEL_KEY);
    }

    public static CoverageAnnotationModel getModel(ITextEditor editor) {
        IAnnotationModelExtension model = CoverageAnnotationModel.getAnnotationModel(editor);
        return model == null ? null : CoverageAnnotationModel.getModel(model);
    }

    public static IAnnotationModelExtension getAnnotationModel(ITextEditor editor) {
        IAnnotationModel model;
        IDocumentProvider documentProvider = editor == null ? null : editor.getDocumentProvider();
        IEditorInput input = editor == null ? null : editor.getEditorInput();
        IAnnotationModel iAnnotationModel = model = documentProvider == null | input == null ? null : documentProvider.getAnnotationModel((Object)input);
        if (model instanceof IAnnotationModelExtension) {
            return (IAnnotationModelExtension)model;
        }
        return null;
    }

    private static IDocument getEditorDocument(ITextEditor editor) {
        return editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
    }

    public void documentChanged(DocumentEvent documentEvent) {
        FullFileInfo info = this.cloverFileInfoForEditorInput();
        if (!this.ignoreDocumentUpdates()) {
            this.refreshAsync();
        }
    }

    private boolean ignoreDocumentUpdates() {
        return this.annotations == ANNOTATIONS_OFF && this.editor.isDirty();
    }

    private AnnotationModelEvent rebuildAnnotations(boolean dirty) throws BadLocationException {
        this.lineCoverageModel = null;
        FullFileInfo info = this.cloverFileInfoForEditorInput();
        if (info == null || dirty || !info.validatePhysicalFile() || CloverPlugin.getInstance().isInWorkingSetMode() && !this.editorInWorkingSet() || CloverPlugin.getInstance().getInstallationSettings().getEditorCoverageStyle() == 2) {
            return this.turnAnnotationsOff();
        }
        return this.refreshAnnotations();
    }

    private AnnotationModelEvent refreshAnnotations() throws BadLocationException {
        return this.createAnnotations(this.clearAnnotations());
    }

    private boolean editorInWorkingSet() {
        IJavaElement element = JavaUI.getEditorInputJavaElement((IEditorInput)this.editor.getEditorInput());
        return CloverPlugin.getInstance().getCloverWorkingSet().includesCU((IAdaptable)element);
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent event) {
        if (event.isApplicableTo(this.cloverProjectForEditorInput()) && event.isSubstantiveProjectChange() || event.isForWorkspace()) {
            this.refreshAsync();
        }
    }

    @Override
    public void displayOptionChanged() {
        this.refreshAsync();
    }

    public CoverageAnnotationFilter.TestFilter getExcludedTests() {
        return CoverageAnnotationFilter.TestFilter.loadFor((IResource)this.editor.getEditorInput().getAdapter(IResource.class), CoverageAnnotationFilter.EXCLUDED_TEST_NAMES);
    }

    public void setExcludedTests(CoverageAnnotationFilter.TestFilter testNames) {
        if (testNames.isEmpty()) {
            CoverageAnnotationFilter.TestFilter.removeFor((IResource)this.editor.getEditorInput().getAdapter(IResource.class), CoverageAnnotationFilter.EXCLUDED_TEST_NAMES);
        } else {
            testNames.saveFor((IResource)this.editor.getEditorInput().getAdapter(IResource.class), CoverageAnnotationFilter.EXCLUDED_TEST_NAMES);
        }
        this.refreshAsync();
    }

    public boolean contains(ISchedulingRule schedulingRule) {
        return false;
    }

    public boolean isConflicting(ISchedulingRule schedulingRule) {
        return this == schedulingRule;
    }

    IDocument getDocument() {
        return this.document;
    }

    public ILineCoverageModel getLineCoverageModel() {
        return this.lineCoverageModel;
    }
}

