/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;

public class SwtUtils {
    public static final int SWT_HOT = 32;

    public static Label createMultilineLabel(Composite parent, String txt, int widthHint) {
        Label label = new Label(parent, 64);
        label.setText(txt);
        GridData gridData = new GridData(4);
        gridData.widthHint = widthHint;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public static Link createMultilineLink(Composite parent, String txt, int widthHint) {
        Link link = new Link(parent, 64);
        link.setText(txt);
        GridData gridData = new GridData(4);
        gridData.widthHint = widthHint;
        link.setLayoutData((Object)gridData);
        return link;
    }

    public static Control setHorizontalSpan(Control control, int span) {
        SwtUtils.gridDataFor((Control)control).horizontalSpan = span;
        return control;
    }

    public static Control setVerticalSpan(Control control, int span) {
        SwtUtils.gridDataFor((Control)control).verticalSpan = span;
        return control;
    }

    public static GridData gridDataFor(Control control) {
        if (control.getLayoutData() == null || !(control.getLayoutData() instanceof GridData)) {
            control.setLayoutData((Object)new GridData());
        }
        return (GridData)control.getLayoutData();
    }

    public static void drawText(String text, GC gc, Color foreground, int rowX, int rowY, int columnWidth, int rowHeight, int margin, int alignment) {
        gc.setForeground(foreground);
        Point textSize = gc.textExtent(text);
        if (alignment == 131072) {
            gc.drawText(text, rowX + columnWidth - margin - textSize.x, rowY + (rowHeight - textSize.y) / 2, true);
        } else if (alignment == 16384) {
            gc.drawText(text, rowX + margin, rowY + (rowHeight - textSize.y) / 2, true);
        } else {
            gc.drawText(text, rowX + (columnWidth - textSize.x) / 2, rowY + (rowHeight - textSize.y) / 2, true);
        }
    }

    public static void renderSelectionBackground(Event event) {
        GC gc = event.gc;
        Color oldBackground = gc.getBackground();
        gc.setBackground(event.display.getSystemColor(26));
        gc.fillRectangle(event.x, event.y, event.width, event.height);
        gc.setBackground(oldBackground);
    }
}

