/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.settings;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.openclover.eclipse.core.CloverPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class Settings {
    protected IEclipsePreferences isolatedPreferences;
    protected IPreferencesService preferencesService;

    protected Settings() {
        this.buildPreferencesService();
    }

    private void buildPreferencesService() {
        this.preferencesService = Platform.getPreferencesService();
    }

    protected IScopeContext[] getScopeDelegation() {
        return null;
    }

    public void addListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        ((IEclipsePreferences)this.getIsolatedPreferences()).addPreferenceChangeListener(listener);
    }

    public void removeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        ((IEclipsePreferences)this.getIsolatedPreferences()).removePreferenceChangeListener(listener);
    }

    protected Preferences getIsolatedPreferences() {
        return this.isolatedPreferences;
    }

    protected IPreferencesService getPreferencesService() {
        return this.preferencesService;
    }

    public void setValue(String key, String value) {
        if (value == null) {
            this.getIsolatedPreferences().remove(key);
        } else {
            this.getIsolatedPreferences().put(key, value);
        }
        this.save();
    }

    public void setValue(String key, boolean value) {
        this.getIsolatedPreferences().putBoolean(key, value);
        this.save();
    }

    public void setValue(String key, int value) {
        this.getIsolatedPreferences().putInt(key, value);
        this.save();
    }

    public void setValue(String key, long value) {
        this.getIsolatedPreferences().putLong(key, value);
        this.save();
    }

    public String getLocalValue(String key) {
        return this.getIsolatedPreferences().get(key, null);
    }

    public String getString(String key) {
        return this.getPreferencesService().getString("org.openclover.eclipse.core", key, null, this.getScopeDelegation());
    }

    public long getLong(String key, long defaultValue) {
        return this.getPreferencesService().getLong("org.openclover.eclipse.core", key, defaultValue, this.getScopeDelegation());
    }

    public long getLong(String key) {
        return this.getLong(key, -1L);
    }

    public boolean getBoolean(String key) {
        return this.getPreferencesService().getBoolean("org.openclover.eclipse.core", key, false, this.getScopeDelegation());
    }

    public int getInt(String key, int defaultValue) {
        return this.getPreferencesService().getInt("org.openclover.eclipse.core", key, -1, this.getScopeDelegation());
    }

    public int getInt(String key) {
        return this.getInt(key, -1);
    }

    public void save() {
        try {
            this.getIsolatedPreferences().flush();
        }
        catch (BackingStoreException e) {
            CloverPlugin.logError("Unable to save settings", e);
        }
    }

    protected void load() {
        try {
            this.isolatedPreferences.sync();
        }
        catch (BackingStoreException e) {
            CloverPlugin.logError("Unable to load preferences", e);
        }
    }
}

