/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.settings;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.openclover.eclipse.core.ui.SwtUtils;

public class LoggingLevelFieldEditor
extends FieldEditor {
    private Combo combo;

    public LoggingLevelFieldEditor(Composite parent) {
        super("logging_level", "Clover Plugin logging output level:", parent);
    }

    public void doSelect(LoggingLevelCombo level) {
        this.combo.select(level.ordinal());
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected void adjustForNumColumns(int numColumns) {
        SwtUtils.setHorizontalSpan((Control)this.combo, numColumns - 1);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        if (this.combo == null) {
            this.getLabelControl(parent);
            this.combo = new Combo(parent, 8);
            this.combo.setItems(LoggingLevelCombo.stringValues());
        } else {
            this.checkParent((Control)this.combo, parent);
        }
    }

    protected void doLoad() {
        this.combo.select(this.getComboSelection(this.getPreferenceStore().getString("logging_level")));
    }

    protected void doLoadDefault() {
        this.combo.select(LoggingLevelCombo.None.ordinal());
    }

    protected void doStore() {
        this.getPreferenceStore().setValue("logging_level", this.getPreferenceValueForComboSelection());
    }

    private int getComboSelection(String value) {
        return LoggingLevelCombo.fromInstallationSetting(value);
    }

    private String getPreferenceValueForComboSelection() {
        return LoggingLevelCombo.toInstallationSetting(this.combo.getSelectionIndex());
    }

    static enum LoggingLevelCombo {
        None("none"),
        Verbose("verbose"),
        Debug("debug"),
        Info("info");

        private String installationValue;

        private LoggingLevelCombo(String installationValue) {
            this.installationValue = installationValue;
        }

        static int fromInstallationSetting(String value) {
            for (LoggingLevelCombo level : LoggingLevelCombo.values()) {
                if (level.installationValue == null || !level.installationValue.equals(value)) continue;
                return level.ordinal();
            }
            return None.ordinal();
        }

        static String toInstallationSetting(int index) {
            for (LoggingLevelCombo level : LoggingLevelCombo.values()) {
                if (level.ordinal() != index) continue;
                return level.installationValue;
            }
            return LoggingLevelCombo.None.installationValue;
        }

        static String[] stringValues() {
            String[] values = new String[LoggingLevelCombo.values().length];
            int i = 0;
            for (LoggingLevelCombo level : LoggingLevelCombo.values()) {
                values[i++] = level.toString();
            }
            return values;
        }
    }
}

