/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.settings;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.settings.BasePreferencePage;
import org.openclover.eclipse.core.settings.LoggingLevelFieldEditor;
import org.openclover.eclipse.core.settings.RefreshFieldEditor;
import org.openclover.eclipse.core.ui.GLH;
import org.openclover.eclipse.core.ui.SwtUtils;

public class GeneralPreferencesPage
extends BasePreferencePage {
    private Panel panel;

    protected Control createContents(Composite parent) {
        try {
            this.panel = new Panel(parent);
            return this.panel;
        }
        catch (CoreException e) {
            CloverPlugin.logError("Error creating general preferences panel", e);
            return null;
        }
    }

    protected void performApply() {
        try {
            this.panel.performApply();
        }
        catch (IOException e) {
            CloverPlugin.logError("Unable to persist preferences", e);
        }
    }

    protected void performDefaults() {
        this.panel.performDefaults();
    }

    public boolean performOk() {
        try {
            return this.panel.performOk();
        }
        catch (IOException e) {
            CloverPlugin.logError("Unable to persist preferences", e);
            return true;
        }
    }

    private class Panel
    extends Composite {
        private RadioGroupFieldEditor rebuildActionEditor;
        private BooleanFieldEditor promptOnRebuildFieldEditor;
        private FieldEditor automaticallyRefreshEditor;
        private StringFieldEditor spanEditor;
        private LoggingLevelFieldEditor loggingLevelFiedEditor;
        private BooleanFieldEditor primeAWTInReports;
        private BooleanFieldEditor showExclusionAnnotations;
        private RadioGroupFieldEditor onContextChangeActionEditor;
        private BooleanFieldEditor promptOnContextChangeFieldEditor;
        private RadioGroupFieldEditor onInstrumentationSourceChangeActionEditor;
        private BooleanFieldEditor promptOnInstrumentationSourceChangeFieldEditor;
        private BooleanFieldEditor preserveInstrSourcesEditor;
        private BooleanFieldEditor autoOpenCloverViews;

        public Panel(Composite parent) throws CoreException {
            Control[] children;
            super(parent, 0);
            this.setLayout((Layout)new GridLayout(1, false));
            this.addRebuildActionWidget();
            this.addPromptOnRebuildWidget();
            Group refreshGroup = new Group((Composite)this, 0);
            refreshGroup.setLayoutData((Object)new GridData(256));
            refreshGroup.setLayout((Layout)new GLH(2, false).marginHeight(10).marginWidth(100).getGridLayout());
            refreshGroup.setText(CloverEclipsePluginMessages.COVERAGE_DATA());
            this.addCoverageRefreshWidget(refreshGroup);
            this.addSpanWidget(refreshGroup);
            this.addOnContextChangeActionWidget();
            this.addPromptOnContextChangeWidget();
            this.addOnInstrumentationSourceChangeActionWidget();
            this.addPromptOnInstrumentationSourceContextChangeWidget();
            Group miscGroup = new Group((Composite)this, 0);
            miscGroup.setLayout((Layout)new GridLayout(2, false));
            miscGroup.setText(CloverEclipsePluginMessages.MISC_PREFERENCES());
            this.addAWTInitialiseWidget(miscGroup);
            this.addShowExclusionAnnotationsWidget(miscGroup);
            this.addLoggingLevelWidget(miscGroup);
            this.addAutoOpenCloverViewsWidget(miscGroup);
            this.addPreserveInstrSourcesWidget(miscGroup);
            for (Control child : children = this.getChildren()) {
                child.setLayoutData((Object)new GridData(768));
            }
            this.bindPreferencesStoreToEditors((IPreferenceStore)new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "org.openclover.eclipse.core"), this.allConfigurationEditors());
            this.loadEditors(this.allConfigurationEditors());
        }

        private void addRebuildActionWidget() {
            this.rebuildActionEditor = new RadioGroupFieldEditor("action_when_rebuilding", CloverEclipsePluginMessages.WHEN_REBUILDING(), 1, (String[][])new String[][]{{CloverEclipsePluginMessages.CLEAR_COVERAGE(), "clear"}, {CloverEclipsePluginMessages.LEAVE_COVERAGE(), "leave"}}, (Composite)this, true);
            this.rebuildActionEditor.setIndent(0);
        }

        private void addPromptOnRebuildWidget() {
            Composite rebuildGroup = (Composite)this.getChildren()[this.getChildren().length - 1];
            rebuildGroup.setLayoutData((Object)new GridData(256));
            this.promptOnRebuildFieldEditor = new BooleanFieldEditor("when_rebuilding_prompt_me", CloverEclipsePluginMessages.PROMPT_ME_ON_REBUILD(), 0, rebuildGroup);
        }

        private void addOnContextChangeActionWidget() {
            this.onContextChangeActionEditor = new RadioGroupFieldEditor("action_when_context_changes", CloverEclipsePluginMessages.WHEN_CONTEXT_CHANGES(), 1, (String[][])new String[][]{{CloverEclipsePluginMessages.REBUILD_ON_CONTEXT_CHANGE(), "rebuild"}, {CloverEclipsePluginMessages.IGNORE_ON_CONTEXT_CHANGE(), "ignore"}}, (Composite)this, true);
            this.onContextChangeActionEditor.setIndent(0);
        }

        private void addPromptOnContextChangeWidget() {
            Composite contextChangeGroup = (Composite)this.getChildren()[this.getChildren().length - 1];
            contextChangeGroup.setLayoutData((Object)new GridData(256));
            this.promptOnContextChangeFieldEditor = new BooleanFieldEditor("when_context_changes_prompt_me", CloverEclipsePluginMessages.PROMPT_ME_ON_CONTEXT_CHANGE(), 0, contextChangeGroup);
        }

        private void addOnInstrumentationSourceChangeActionWidget() {
            this.onInstrumentationSourceChangeActionEditor = new RadioGroupFieldEditor("action_when_instrumentation_source_changes", CloverEclipsePluginMessages.WHEN_INSTRUMENTATION_SOURCE_CHANGES(), 1, (String[][])new String[][]{{CloverEclipsePluginMessages.REBUILD_ON_CONTEXT_CHANGE(), "rebuild"}, {CloverEclipsePluginMessages.IGNORE_ON_CONTEXT_CHANGE(), "ignore"}}, (Composite)this, true);
            this.onInstrumentationSourceChangeActionEditor.setIndent(0);
        }

        private void addPromptOnInstrumentationSourceContextChangeWidget() {
            Composite instrSrcChangeGroup = (Composite)this.getChildren()[this.getChildren().length - 1];
            instrSrcChangeGroup.setLayoutData((Object)new GridData(256));
            this.promptOnInstrumentationSourceChangeFieldEditor = new BooleanFieldEditor("when_instrumentation_source_changes_prompt_me", CloverEclipsePluginMessages.PROMPT_ME_ON_CONTEXT_CHANGE(), 0, instrSrcChangeGroup);
        }

        private void addCoverageRefreshWidget(Group refreshGroup) {
            this.automaticallyRefreshEditor = new RefreshFieldEditor((Composite)refreshGroup);
        }

        private void addSpanWidget(Group refreshGroup) {
            this.spanEditor = new StringFieldEditor("coverage_span", CloverEclipsePluginMessages.SPAN(), (Composite)refreshGroup);
            Label label = SwtUtils.createMultilineLabel((Composite)refreshGroup, CloverEclipsePluginMessages.SPAN_BLURB(), GeneralPreferencesPage.this.convertWidthInCharsToPixels(60));
            SwtUtils.setHorizontalSpan((Control)label, 2);
        }

        private void addAWTInitialiseWidget(Group miscGroup) {
            this.primeAWTInReports = new BooleanFieldEditor("prime_awt_in_ui_thread", CloverEclipsePluginMessages.PRIME_AWT_IN_UI_THREAD(), 0, (Composite)SwtUtils.setHorizontalSpan((Control)new Composite((Composite)miscGroup, 0), 2));
        }

        private void addShowExclusionAnnotationsWidget(Group miscGroup) {
            this.showExclusionAnnotations = new BooleanFieldEditor("show_exclusion_annotations", CloverEclipsePluginMessages.SHOW_EXCLUSION_ANNOTATIONS(), 0, (Composite)SwtUtils.setHorizontalSpan((Control)new Composite((Composite)miscGroup, 0), 2));
        }

        private void addLoggingLevelWidget(Group miscGroup) {
            this.loggingLevelFiedEditor = new LoggingLevelFieldEditor((Composite)miscGroup);
        }

        private void addPreserveInstrSourcesWidget(Group miscGroup) {
            this.preserveInstrSourcesEditor = new BooleanFieldEditor("preserve_instrumented_sources", CloverEclipsePluginMessages.PRESERVE_INSTRUMENTED_SOURCES(), 0, (Composite)SwtUtils.setHorizontalSpan((Control)new Composite((Composite)miscGroup, 0), 2));
            this.preserveInstrSourcesEditor.setPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (Panel.this.loggingLevelFiedEditor != null && event.getSource() instanceof BooleanFieldEditor && ((BooleanFieldEditor)event.getSource()).getBooleanValue()) {
                        Panel.this.loggingLevelFiedEditor.doSelect(LoggingLevelFieldEditor.LoggingLevelCombo.Info);
                    }
                }
            });
        }

        private void addAutoOpenCloverViewsWidget(Group miscGroup) {
            this.autoOpenCloverViews = new BooleanFieldEditor("auto_open_clover_views", CloverEclipsePluginMessages.AUTO_OPEN_CLOVER_VIEWS(), 0, (Composite)SwtUtils.setHorizontalSpan((Control)new Composite((Composite)miscGroup, 0), 2));
        }

        private FieldEditor[] allConfigurationEditors() {
            return new FieldEditor[]{this.rebuildActionEditor, this.promptOnRebuildFieldEditor, this.automaticallyRefreshEditor, this.spanEditor, this.loggingLevelFiedEditor, this.primeAWTInReports, this.showExclusionAnnotations, this.autoOpenCloverViews, this.onContextChangeActionEditor, this.promptOnContextChangeFieldEditor, this.onInstrumentationSourceChangeActionEditor, this.promptOnInstrumentationSourceChangeFieldEditor, this.preserveInstrSourcesEditor};
        }

        private void bindPreferencesStoreToEditors(IPreferenceStore store, FieldEditor[] editors) {
            for (FieldEditor editor : editors) {
                editor.setPreferenceStore(store);
            }
        }

        private void loadEditors(FieldEditor[] editors) {
            for (FieldEditor editor : editors) {
                editor.load();
            }
        }

        private void storeEditors(FieldEditor[] editors) {
            for (FieldEditor editor : editors) {
                editor.store();
            }
        }

        private void loadEditorDefaults(FieldEditor[] editors) {
            for (FieldEditor editor : editors) {
                editor.loadDefault();
            }
        }

        public void performDefaults() {
            this.loadEditorDefaults(this.allConfigurationEditors());
        }

        public void performApply() throws IOException {
            this.storeEditors(this.allConfigurationEditors());
            CloverPlugin.getInstance().getInstallationSettings().save();
        }

        public boolean performOk() throws IOException {
            this.performApply();
            return true;
        }
    }
}

