/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.reports.reporters;

import com.atlassian.clover.reporters.html.HtmlReporter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public abstract class MemoryDebugReporter {
    private static final double PERCENTAGE_MEM_THRESHOLD = 0.95;
    private static final int ONE_MEG = 0x100000;
    private ScheduledExecutorService reporterService;

    public static void mainImpl(MemoryDebugReporter reporter, String[] args) {
        try {
            reporter.runReport(args);
        }
        finally {
            reporter.stopMemoryDebugging();
        }
    }

    private static MemoryPoolMXBean findTenuredGenPool() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            return pool;
        }
        System.err.println("Could not find tenured space to report on");
        return null;
    }

    public MemoryDebugReporter() {
        NotificationEmitter emitter = (NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean());
        final MemoryPoolMXBean tenuredGenPool = MemoryDebugReporter.findTenuredGenPool();
        if (emitter != null && tenuredGenPool != null) {
            long maxMemory = tenuredGenPool.getUsage().getMax();
            long warningThreshold = (long)((double)maxMemory * 0.95);
            tenuredGenPool.setUsageThreshold(warningThreshold);
            emitter.addNotificationListener(new NotificationListener(){

                @Override
                public void handleNotification(Notification notification, Object hb) {
                    if (notification.getType().equals("java.management.memory.threshold.exceeded")) {
                        long maxMemory = tenuredGenPool.getUsage().getMax();
                        long usedMemory = tenuredGenPool.getUsage().getUsed();
                        System.out.println("LOW MEMORY WARNING - " + MemoryDebugReporter.this.tenuredMemoryDescription(usedMemory, maxMemory));
                        System.out.println("Stack traces for running threads:");
                        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
                            StackTraceElement[] elements;
                            Thread thread = entry.getKey();
                            System.out.println(thread);
                            for (StackTraceElement element : elements = entry.getValue()) {
                                System.out.println("at " + element);
                            }
                            System.out.println();
                        }
                    }
                }
            }, null, null);
            this.reporterService = Executors.newSingleThreadScheduledExecutor(Executors.defaultThreadFactory());
            this.reporterService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    long maxMemory = tenuredGenPool.getUsage().getMax();
                    long usedMemory = tenuredGenPool.getUsage().getUsed();
                    System.out.println(MemoryDebugReporter.this.tenuredMemoryDescription(usedMemory, maxMemory));
                }
            }, 5L, 5L, TimeUnit.SECONDS);
        } else {
            System.err.println("Unable to find memory MX bean or memory pool MX bean or both");
        }
    }

    private String tenuredMemoryDescription(long usedMemory, long maxMemory) {
        return "Tenured generation: [" + (int)(usedMemory / 0x100000L) + "m used out of " + (int)(maxMemory / 0x100000L) + "m]";
    }

    public abstract void runReport(String[] var1);

    private void stopMemoryDebugging() {
        this.reporterService.shutdown();
    }

    public static final class PDFReporter
    extends MemoryDebugReporter {
        @Override
        public void runReport(String[] args) {
            com.atlassian.clover.reporters.pdf.PDFReporter.main(args);
        }

        public static void main(String[] args) {
            MemoryDebugReporter.mainImpl(new PDFReporter(), args);
        }
    }

    public static final class XMLReporter
    extends MemoryDebugReporter {
        @Override
        public void runReport(String[] args) {
            com.atlassian.clover.reporters.xml.XMLReporter.main(args);
        }

        public static void main(String[] args) {
            MemoryDebugReporter.mainImpl(new XMLReporter(), args);
        }
    }

    public static final class HTMLReporter
    extends MemoryDebugReporter {
        @Override
        public void runReport(String[] args) {
            HtmlReporter.main(args);
        }

        public static void main(String[] args) {
            MemoryDebugReporter.mainImpl(new HTMLReporter(), args);
        }
    }
}

