/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.reports.model;

import com.atlassian.clover.cfg.Interval;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.Type;
import java.io.File;
import java.math.BigDecimal;
import java.util.Objects;
import org.osgi.service.prefs.Preferences;

public class ReportHistoryEntry {
    private String path = "";
    private Type type = Type.HTML;
    private String name = "unknown";
    private long when = -1L;

    public ReportHistoryEntry(Current config, long when) {
        this.path = config.getMainOutFile().getAbsolutePath();
        this.type = config.getFormat().getType();
        this.name = config.getTitle();
        this.when = when;
    }

    public ReportHistoryEntry(Preferences preferences) {
        this.path = preferences.get("path", this.path);
        this.type = Type.valueOf(preferences.get("type", this.type.name()));
        this.name = preferences.get("name", this.name);
        this.when = preferences.getLong("when", this.when);
    }

    public void saveTo(Preferences preferences) {
        preferences.put("path", this.path);
        preferences.put("type", this.type.name());
        preferences.put("name", this.name);
        preferences.putLong("when", this.when);
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public long getWhen() {
        return this.when;
    }

    public Type getType() {
        return this.type;
    }

    public boolean pathExists() {
        return new File(this.path).exists();
    }

    public boolean isValid() {
        return this.pathExists() && this.when != -1L;
    }

    public String toString() {
        return "\"" + this.name + "\"\t" + (Object)((Object)this.type) + " - generated " + new Interval(BigDecimal.valueOf((System.currentTimeMillis() - this.when) / 1000L), 0).toSensibleString() + " ago";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportHistoryEntry that = (ReportHistoryEntry)o;
        if (this.when != that.when) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (int)(this.when ^ this.when >>> 32);
        return result;
    }
}

