/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.reports;

import java.util.List;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.reports.OpenReportDialog;
import org.openclover.eclipse.core.reports.OpenReportOperation;
import org.openclover.eclipse.core.reports.ReportJob;
import org.openclover.eclipse.core.reports.model.ReportHistoryEntry;

public class ReportJobListener
extends JobChangeAdapter {
    protected final Shell shell;

    public ReportJobListener(Shell shell) {
        this.shell = shell;
    }

    public void done(final IJobChangeEvent event) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (event.getResult().getSeverity() == 0 || event.getResult().getSeverity() == 2) {
                    CloverPlugin.getInstance().addReportToHistory(new ReportHistoryEntry(((ReportJob)event.getJob()).getConfig(), System.currentTimeMillis()));
                    ReportJobListener.this.onReportSucceeded(event);
                } else if (event.getResult().getSeverity() == 4) {
                    ReportJobListener.this.onReportFailed(event);
                } else {
                    ReportJobListener.this.onReportCancelled(event);
                }
            }
        });
    }

    private void onReportCancelled(IJobChangeEvent event) {
        MessageDialog.openWarning((Shell)this.shell, (String)CloverEclipsePluginMessages.REPORT_MESSAGEBOX_TITLE(((ReportJob)event.getJob()).getConfig().getTitle()), (String)CloverEclipsePluginMessages.REPORT_CANCEL_MESSAGE());
    }

    private void onReportFailed(IJobChangeEvent event) {
        Throwable exception = event.getResult().getException();
        String message = event.getResult().getMessage();
        MessageDialog.openError((Shell)this.shell, (String)CloverEclipsePluginMessages.REPORT_MESSAGEBOX_TITLE(((ReportJob)event.getJob()).getConfig().getTitle()), (String)(message == null ? (exception == null ? "Unknown exception class" : exception.getClass().getName()) + ": " + (exception == null ? "unknown error message" : exception.getMessage()) : message));
    }

    protected void onReportSucceeded(IJobChangeEvent event) {
        List availableMethods;
        ReportHistoryEntry report = new ReportHistoryEntry(((ReportJob)event.getJob()).getConfig(), System.currentTimeMillis());
        OpenReportOperation chosenMethod = OpenReportDialog.openOnGenerate(this.shell, report, availableMethods = OpenReportOperation.findFor(report));
        if (chosenMethod != null) {
            chosenMethod.open(report);
        }
    }
}

