/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.reports;

import com.atlassian.clover.cfg.Interval;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.Format;
import com.atlassian.clover.reporters.ShowLambdaFunctions;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.model.InMemoryCurrentReportConfig;
import org.openclover.eclipse.core.reports.ConfigureFilterPage;
import org.openclover.eclipse.core.reports.ConfigureHtmlPage;
import org.openclover.eclipse.core.reports.ConfigureJvmPage;
import org.openclover.eclipse.core.reports.ConfigurePdfPage;
import org.openclover.eclipse.core.reports.ConfigureReportPage;
import org.openclover.eclipse.core.reports.ConfigureXmlPage;
import org.openclover.eclipse.core.reports.FilteredReportJob;
import org.openclover.eclipse.core.reports.MergeReportJob;
import org.openclover.eclipse.core.reports.ReportJob;
import org.openclover.eclipse.core.reports.ReportJobListener;
import org.openclover.eclipse.core.reports.SelectProjectsPage;
import org.openclover.eclipse.core.reports.SelectReportPage;

public class GenerateReportWizard
extends Wizard {
    SelectReportPage selectReportPage;
    SelectProjectsPage selectProjectsPage;
    ConfigureHtmlPage configureHtmlPage;
    ConfigurePdfPage configurePdfPage;
    ConfigureXmlPage configureXmlPage;
    ConfigureFilterPage configureFilterPage;
    ConfigureJvmPage configureJvmPage;
    CloverProject initiallySelectedProject;
    IWorkbench workbench;

    public GenerateReportWizard(CloverProject project, IWorkbench workbench) throws MalformedURLException {
        this.initiallySelectedProject = project;
        this.workbench = workbench;
        this.setWindowTitle("Generate Report");
        this.setDefaultPageImageDescriptor(CloverPlugin.getImageDescriptor("icons/wizban/report.gif"));
    }

    public void addPages() {
        this.selectReportPage = new SelectReportPage(this.initiallySelectedProject);
        this.selectProjectsPage = new SelectProjectsPage(this.initiallySelectedProject);
        this.configureHtmlPage = new ConfigureHtmlPage();
        this.configurePdfPage = new ConfigurePdfPage();
        this.configureXmlPage = new ConfigureXmlPage();
        this.configureFilterPage = new ConfigureFilterPage();
        this.configureJvmPage = new ConfigureJvmPage();
        this.addPage((IWizardPage)this.selectReportPage);
        this.addPage((IWizardPage)this.selectProjectsPage);
        this.addPage((IWizardPage)this.configureHtmlPage);
        this.addPage((IWizardPage)this.configurePdfPage);
        this.addPage((IWizardPage)this.configureXmlPage);
        this.addPage((IWizardPage)this.configureFilterPage);
        this.addPage((IWizardPage)this.configureJvmPage);
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.selectReportPage || currentPage == this.selectProjectsPage) {
            return false;
        }
        return currentPage.isPageComplete();
    }

    public boolean performFinish() {
        Shell shell = this.workbench.getActiveWorkbenchWindow().getShell();
        boolean overwrite = true;
        if (this.selectReportPage.isHtmlSelected()) {
            File dir = this.configureHtmlPage.getOutput();
            if (new File(dir, "index.html").exists()) {
                overwrite = MessageDialog.openQuestion((Shell)shell, (String)"Overwrite?", (String)"It appears that a report already exists. Do you want to overwrite it?");
            }
        } else if (this.selectReportPage.isPdfSelected()) {
            if (this.configurePdfPage.getOutput().exists()) {
                overwrite = MessageDialog.openQuestion((Shell)shell, (String)"Overwrite?", (String)"A file with this name already exists. Do you want to overwrite it?");
            }
        } else if (this.selectReportPage.isXmlSelected() && this.configureXmlPage.getOutput().exists()) {
            overwrite = MessageDialog.openQuestion((Shell)shell, (String)"Overwrite?", (String)"A file with this name already exists. Do you want to overwrite it?");
        }
        if (!overwrite) {
            return false;
        }
        this.maybeInitialiseAWT();
        try {
            ReportJob reportJob = this.buildReportJob();
            reportJob.setUser(true);
            reportJob.addJobChangeListener((IJobChangeListener)new ReportJobListener(shell));
            reportJob.schedule();
        }
        catch (IOException e) {
            CloverPlugin.logError("Unable to generate report", e);
        }
        return true;
    }

    private void maybeInitialiseAWT() {
        if (CloverPlugin.getInstance().getInstallationSettings().getBoolean("prime_awt_in_ui_thread")) {
            Toolkit.getDefaultToolkit();
        }
    }

    private ReportJob buildReportJob() throws IOException {
        if (this.selectProjectsPage.getSelectedProjects().length == 1) {
            if (this.getReportTypeWizard().isUsingDefaultContextFilter()) {
                return this.buildDefaultFilteredReportJob();
            }
            return this.buildSpeciallyFilteredReportJob();
        }
        return this.buildMergeFirstReportJob();
    }

    private ReportJob buildSpeciallyFilteredReportJob() {
        CloverProject cloverProject = this.selectProjectsPage.getSelectedProjects()[0];
        return new FilteredReportJob(cloverProject, this.buildFilteredReportConfig(this.newCurrent(), cloverProject, this.configureFilterPage.getContextRegistry().getContextsAsString(this.configureFilterPage.getBlockContextFilter())), this.configureJvmPage.getJvmArgs(), this.configureJvmPage.getMaxHeapSize());
    }

    private Current newCurrent() {
        if (this.selectReportPage.isHtmlSelected()) {
            return new Current(Current.DEFAULT_HTML);
        }
        if (this.selectReportPage.isPdfSelected()) {
            return new Current(Current.DEFAULT_PDF);
        }
        return new Current(Current.DEFAULT_XML);
    }

    private Current buildFilteredReportConfig(Current reportConfig, CloverProject project, String filter) {
        if (this.selectReportPage.isHtmlSelected()) {
            this.primeForHtmlReport(reportConfig);
        } else if (this.selectReportPage.isPdfSelected()) {
            this.primeForPdfReport(reportConfig);
        } else {
            this.primeForXmlReport(reportConfig);
        }
        reportConfig.getFormat().setFilter(filter);
        reportConfig.setInitString(project.deriveInitString());
        return reportConfig;
    }

    private ReportJob buildMergeFirstReportJob() throws IOException {
        return new MergeReportJob(this.selectProjectsPage.getSelectedProjects(), this.buildMergeReportConfig(), this.configureJvmPage.getJvmArgs(), this.configureJvmPage.getMaxHeapSize());
    }

    private Current buildMergeReportConfig() throws IOException {
        Current reportConfig = null;
        if (this.selectReportPage.isHtmlSelected()) {
            reportConfig = new Current(Current.DEFAULT_HTML);
            this.primeForHtmlReport(reportConfig);
        } else if (this.selectReportPage.isPdfSelected()) {
            reportConfig = new Current(Current.DEFAULT_PDF);
            this.primeForPdfReport(reportConfig);
        } else {
            reportConfig = new Current(Current.DEFAULT_XML);
            this.primeForXmlReport(reportConfig);
        }
        reportConfig.getFormat().setFilter(this.configureFilterPage.getContextRegistry().getContextsAsString(this.configureFilterPage.getBlockContextFilter()));
        File mergedDb = File.createTempFile("clover", "merge");
        mergedDb.deleteOnExit();
        reportConfig.setInitString(mergedDb.getAbsolutePath());
        return reportConfig;
    }

    private ReportJob buildDefaultFilteredReportJob() {
        CloverProject project = this.selectProjectsPage.getSelectedProjects()[0];
        return new FilteredReportJob(project, this.buildFilteredReportConfig(this.newInMemoryReportConfig(project), project, this.contextFilterAsString(project)), this.configureJvmPage.getJvmArgs(), this.configureJvmPage.getMaxHeapSize());
    }

    private String contextFilterAsString(CloverProject project) {
        return project.getModel().getDatabase().getContextStore().getContextsAsString(project.getSettings().getContextFilter());
    }

    private InMemoryCurrentReportConfig newInMemoryReportConfig(CloverProject project) {
        if (this.selectReportPage.isHtmlSelected()) {
            return new InMemoryCurrentReportConfig(project.getModel(), Current.DEFAULT_HTML);
        }
        if (this.selectReportPage.isPdfSelected()) {
            return new InMemoryCurrentReportConfig(project.getModel(), Current.DEFAULT_PDF);
        }
        return new InMemoryCurrentReportConfig(project.getModel(), Current.DEFAULT_XML);
    }

    private void primeForReport(Current reportConfig) {
        reportConfig.setAlwaysReport(true);
        reportConfig.setSpan(this.calculateSpan());
    }

    private Interval calculateSpan() {
        CloverProject[] selectedProjects = this.selectProjectsPage.getSelectedProjects();
        if (selectedProjects.length > 1) {
            return Interval.ZERO_INTERVAL;
        }
        return selectedProjects[0].getSettings().calcEffectiveSpanInterval(selectedProjects[0].getModel().getDatabase());
    }

    private void primeForXmlReport(Current reportConfig) {
        reportConfig.setFormat(new Format(Format.DEFAULT_XML));
        reportConfig.setOutFile(this.configureXmlPage.getOutput());
        reportConfig.setTitle(this.configureXmlPage.getReportTitle());
        reportConfig.setNumThreads(this.configureXmlPage.getNumThreads());
        reportConfig.getFormat().setSrcLevel(this.configureXmlPage.isIncludingLineInfo());
        reportConfig.setShowLambdaFunctions(this.configureXmlPage.getShowLambdaFunctions() != ShowLambdaFunctions.NONE);
        reportConfig.setShowInnerFunctions(this.configureXmlPage.getShowLambdaFunctions() == ShowLambdaFunctions.FIELDS_AND_INLINE);
        this.primeForReport(reportConfig);
    }

    private void primeForPdfReport(Current reportConfig) {
        reportConfig.setFormat(new Format(Format.DEFAULT_PDF));
        reportConfig.setOutFile(this.configurePdfPage.getOutput());
        reportConfig.setTitle(this.configurePdfPage.getReportTitle());
        reportConfig.setNumThreads(this.configurePdfPage.getNumThreads());
        this.primeForReport(reportConfig);
    }

    private void primeForHtmlReport(Current reportConfig) {
        reportConfig.setFormat(new Format(Format.DEFAULT_HTML));
        reportConfig.setOutFile(this.configureHtmlPage.getOutput());
        reportConfig.setMainFileName("index.html");
        reportConfig.setTitle(this.configureHtmlPage.getReportTitle());
        reportConfig.setNumThreads(this.configureHtmlPage.getNumThreads());
        reportConfig.getFormat().setSrcLevel(this.configureHtmlPage.shouldIncludeSource());
        reportConfig.setIncludeFailedTestCoverage(this.configureHtmlPage.shouldIncludeFailedTestCoverage());
        reportConfig.setShowLambdaFunctions(this.configureHtmlPage.getShowLambdaFunctions() != ShowLambdaFunctions.NONE);
        reportConfig.setShowInnerFunctions(this.configureHtmlPage.getShowLambdaFunctions() == ShowLambdaFunctions.FIELDS_AND_INLINE);
        this.primeForReport(reportConfig);
    }

    protected boolean useDefaultFilter() {
        return this.getReportTypeWizard().isUsingDefaultContextFilter();
    }

    protected ConfigureReportPage getReportTypeWizard() {
        if (this.selectReportPage.isHtmlSelected()) {
            return this.configureHtmlPage;
        }
        if (this.selectReportPage.isPdfSelected()) {
            return this.configurePdfPage;
        }
        return this.configureXmlPage;
    }
}

