/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.reports;

import com.atlassian.clover.reporters.Current;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.settings.ProjectSettings;
import org.openclover.eclipse.core.reports.ForkingReporter;
import org.openclover.eclipse.core.reports.ReportJob;
import org.openclover.util.Lists;
import org.osgi.framework.Bundle;

public abstract class ForkingReportJob
extends ReportJob {
    private static final long POLL_INTERVAL = 1000L;
    private static final long MAX_REPORT_DURATION = 3600000L;
    protected final Current config;
    protected String mxSetting;
    protected String vmArgs;

    public ForkingReportJob(Current config, String vmArgs, String mxSetting) {
        this.config = config;
        this.vmArgs = vmArgs;
        this.mxSetting = mxSetting;
    }

    @Override
    public Current getConfig() {
        return this.config;
    }

    protected ILaunchConfigurationWorkingCopy launchConfigFor(String name) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchType = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfiguration[] launchConfig = manager.getLaunchConfigurations(launchType);
        ILaunchConfigurationWorkingCopy launchConfigCopy = launchType.newInstance(null, name);
        return launchConfigCopy;
    }

    protected URL calculateCorePluginJarURL() throws IOException {
        URL corePlugin = FileLocator.resolve((URL)FileLocator.find((Bundle)Platform.getBundle((String)"org.openclover.eclipse.core"), (IPath)new Path("/"), null));
        URL corePluginJar = new URL(corePlugin.getPath().replaceAll("!/", ""));
        return corePluginJar;
    }

    protected void bindCloverRequiredJvm(ILaunchConfigurationWorkingCopy launchConfigCopy) {
        IVMInstall jre = JavaRuntime.getDefaultVMInstall();
        launchConfigCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, jre.getInstallLocation().getAbsolutePath());
    }

    protected static String blankIfNull(String string) {
        return string == null ? "" : string;
    }

    protected static String quote(String string) {
        return "\"" + string.replaceAll("\"", "\\\"") + "\"";
    }

    protected void bindReportingSystemProperties(ILaunchConfigurationWorkingCopy launchConfigCopy) {
        launchConfigCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.userArgs() + " -Djava.awt.headless=true -D" + "clover.eclipse.forking.reporter" + "=" + this.calculateReporterClass());
    }

    private String userArgs() {
        return (this.vmArgs.contains("-Xmx") ? "" : "-Xmx" + this.mxSetting + " ") + this.vmArgs + " ";
    }

    protected void bindCloverRequiredClasspath(ILaunchConfigurationWorkingCopy launchConfigCopy) throws IOException, CoreException {
        URL corePluginJar = this.calculateCorePluginJarURL();
        launchConfigCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, Lists.newArrayList(this.userClasspathEntryFor(corePluginJar).getMemento(), this.getJdkClassEntry().getMemento()));
        launchConfigCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
    }

    private IRuntimeClasspathEntry getJdkClassEntry() throws CoreException {
        Path systemLibsPath = new Path(JavaRuntime.JRE_CONTAINER);
        IRuntimeClasspathEntry systemLibsEntry = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)systemLibsPath, (int)1);
        return systemLibsEntry;
    }

    private IRuntimeClasspathEntry userClasspathEntryFor(URL jarUrl) {
        IRuntimeClasspathEntry cloverCorePluginPath = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(jarUrl.getPath()));
        cloverCorePluginPath.setClasspathProperty(3);
        return cloverCorePluginPath;
    }

    protected void bindMainClassArguments(ILaunchConfigurationWorkingCopy launchConfigCopy, String mainClassArgs) {
        launchConfigCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, mainClassArgs);
    }

    protected void bindMainClassName(ILaunchConfigurationWorkingCopy launchConfigCopy, String mainClassName) {
        launchConfigCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainClassName);
    }

    protected IStatus report(IProgressMonitor monitor) {
        try {
            ILaunch launch = this.buildAndLaunchForkedReporter(monitor);
            long started = System.currentTimeMillis();
            while (!launch.isTerminated() && !this.reportTakingTooLong(started)) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!monitor.isCanceled()) continue;
                launch.terminate();
                return Status.CANCEL_STATUS;
            }
            int launchExitValue = this.getLaunchExitValue(launch);
            if (launchExitValue != 0) {
                return new Status(4, "org.openclover.eclipse.core", 0, "The JVM report process failed with error code " + launchExitValue + " - see log for details", null);
            }
            return Status.OK_STATUS;
        }
        catch (Throwable e) {
            return new Status(4, "org.openclover.eclipse.core", 0, "Clover failed to generate the report", e);
        }
    }

    protected abstract IStatus runReporter(IProgressMonitor var1) throws Exception;

    private int getLaunchExitValue(ILaunch launch) throws DebugException {
        IProcess[] processes = launch.getProcesses();
        if (processes.length != 1) {
            return -1;
        }
        return processes[0].getExitValue();
    }

    private boolean reportTakingTooLong(long started) {
        return System.currentTimeMillis() - started > 3600000L;
    }

    protected ILaunch buildAndLaunchForkedReporter(IProgressMonitor monitor) throws Exception {
        ILaunchConfigurationWorkingCopy launchConfigCopy = this.launchConfigFor("Clover Reports");
        this.bindCloverRequiredClasspath(launchConfigCopy);
        this.bindCloverRequiredJvm(launchConfigCopy);
        this.bindReportingSystemProperties(launchConfigCopy);
        this.bindMainClassName(launchConfigCopy, ForkingReporter.class.getName());
        this.bindMainClassArguments(launchConfigCopy, this.calculateProgramArgs());
        CloverPlugin.logVerbose("Launching report VM with args: " + launchConfigCopy.getAttributes().toString());
        launchConfigCopy.doSave();
        return launchConfigCopy.launch("run", monitor);
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Generating report", 100);
        try {
            IStatus iStatus = this.report(monitor);
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected String calculateProgramArgs() {
        String testFilterArgs = this.calcTestFilterArgs();
        switch (this.config.getFormat().getType()) {
            case HTML: {
                return testFilterArgs + " " + this.calcHtmlReportArgs();
            }
            case PDF: {
                return testFilterArgs + " " + this.calcPdfReportArgs();
            }
        }
        return testFilterArgs + " " + this.calcXmlReportArgs();
    }

    protected abstract String calculateReporterClass();

    protected abstract String calcTestFilterArgs();

    protected String calcHtmlReportArgs() {
        return "-a -i " + ForkingReportJob.quote(this.config.getInitString()) + " -o " + ForkingReportJob.quote(this.config.getOutFile().getAbsolutePath()) + " -t " + ForkingReportJob.quote(this.config.getTitle()) + " -tc " + this.config.getNumThreads() + (this.config.getFormat().getSrcLevel() ? "" : " -h ") + (this.config.isIncludeFailedTestCoverage() ? " -if " : "") + (this.config.isShowLambdaFunctions() ? " -sl " : "") + (this.config.isShowInnerFunctions() ? " -si " : "") + " -f " + ForkingReportJob.quote(ForkingReportJob.blankIfNull(this.config.getFormat().getFilter())) + " -s " + ForkingReportJob.quote(this.config.getSpan().toString());
    }

    protected String calcPdfReportArgs() {
        return "-a -i " + ForkingReportJob.quote(this.config.getInitString()) + " -o " + ForkingReportJob.quote(this.config.getOutFile().getAbsolutePath()) + " -t " + ForkingReportJob.quote(this.config.getTitle()) + " -tc " + this.config.getNumThreads() + (this.config.isIncludeFailedTestCoverage() ? " -if " : "") + " -f " + ForkingReportJob.quote(ForkingReportJob.blankIfNull(this.config.getFormat().getFilter())) + " -s " + ForkingReportJob.quote(this.config.getSpan().toString());
    }

    protected String calcXmlReportArgs() {
        return "-a -i " + ForkingReportJob.quote(this.config.getInitString()) + " -o " + ForkingReportJob.quote(this.config.getOutFile().getAbsolutePath()) + " -t " + ForkingReportJob.quote(this.config.getTitle()) + " -tc " + this.config.getNumThreads() + (this.config.getFormat().getSrcLevel() ? " -l " : "") + (this.config.isIncludeFailedTestCoverage() ? " -if " : "") + (this.config.isShowLambdaFunctions() ? " -sl " : "") + (this.config.isShowInnerFunctions() ? " -si " : "") + " -f " + ForkingReportJob.quote(ForkingReportJob.blankIfNull(this.config.getFormat().getFilter())) + " -s " + ForkingReportJob.quote(this.config.getSpan().toString());
    }

    public static void extractTestFilterPatterns(CloverProject project, Collection<String> includePatterns, Collection<String> excludePatterns) {
        String projectBase = project.getProject().getLocation().toString() + "/";
        ProjectSettings settings = project.getSettings();
        switch (settings.getTestSourceFolders()) {
            case 1: {
                List<String> selectedFolders = settings.getSelectedTestFolders();
                for (String selectedFolder : selectedFolders) {
                    includePatterns.add(projectBase + selectedFolder + "/**/*.java");
                }
                break;
            }
            case 0: {
                for (String s : settings.calculateTestIncludeFilter()) {
                    includePatterns.add(projectBase + s);
                }
                for (String s : settings.calculateTestExcludeFilter()) {
                    excludePatterns.add(projectBase + s);
                }
                break;
            }
            default: {
                excludePatterns.add(projectBase + "**/*.*");
            }
        }
    }

    protected void addParamOptionally(StringBuilder sb, String param, List<String> args) {
        if (args.size() > 0) {
            String sep = "";
            StringBuilder patterns = new StringBuilder();
            for (String includePattern : args) {
                patterns.append(sep);
                patterns.append(includePattern);
                sep = ", ";
            }
            if (sb.length() == 0) {
                sb.append(" ");
            }
            sb.append(param).append(" ");
            sb.append(ForkingReportJob.quote(patterns.toString()));
        }
    }

    protected String calcTestFilterArgs(CloverProject ... projects) {
        ArrayList<String> includePatterns = Lists.newArrayList();
        ArrayList<String> excludePatterns = Lists.newArrayList();
        for (CloverProject project : projects) {
            ForkingReportJob.extractTestFilterPatterns(project, includePatterns, excludePatterns);
        }
        StringBuilder sb = new StringBuilder();
        this.addParamOptionally(sb, "--testsIncludePattern", includePatterns);
        this.addParamOptionally(sb, "--testsExcludePattern", excludePatterns);
        return sb.toString();
    }
}

