/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.reports;

import com.atlassian.clover.reporters.ShowLambdaFunctions;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.reports.GenerateReportWizard;
import org.openclover.eclipse.core.ui.GLH;
import org.openclover.eclipse.core.ui.SwtUtils;

public abstract class ConfigureReportPage
extends WizardPage {
    protected Text reportTitle;
    protected boolean reportTitleCustomised;
    protected Text outputPath;
    protected boolean outputPathCustomised;
    protected Button fileButton;
    protected Button useCurrentFilterProjectButton;
    protected Button includeFailedTestCoverageButton;
    protected Combo threadCount;
    protected Label showLambdaLabel;
    protected Combo showLambdaCombo;

    protected ConfigureReportPage(String title) {
        super(title);
    }

    protected boolean isOutputPathEmpty() {
        return this.outputPath.getText() == null || this.outputPath.getText().trim().length() == 0;
    }

    protected Listener newValidationListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                ConfigureReportPage.this.validate();
                ConfigureReportPage.this.getWizard().getContainer().updateButtons();
            }
        };
    }

    private void validate() {
        if (this.isOutputPathEmpty()) {
            this.setErrorMessage("Please specify an output directory.");
        } else {
            if (this.getNumThreads() != 0) {
                this.setMessage("Increasing the number of report threads will increase the amount of memory required.", 2);
            } else {
                this.setMessage(null, 2);
            }
            this.setErrorMessage(null);
        }
    }

    protected abstract Listener newOutputPathListener();

    protected abstract String getOutputPathLabelTitle();

    protected abstract void addListeners();

    protected abstract void createCustomSettings(Composite var1);

    protected void setOutputPath(String path) {
        this.outputPath.setText(path);
        this.outputPathCustomised = true;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int columnCount = 3;
        composite.setLayout((Layout)new GridLayout(3, false));
        Label reportLabel = new Label(composite, 0);
        reportLabel.setText("Report Title:");
        GridData gd = SwtUtils.gridDataFor((Control)reportLabel);
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 1;
        this.reportTitle = new Text(composite, 2052);
        this.reportTitle.setText("Coverage Report");
        this.reportTitle.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                ConfigureReportPage.this.reportTitleCustomised = true;
            }
        });
        gd = SwtUtils.gridDataFor((Control)this.reportTitle);
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 4;
        Label outputLabel = new Label(composite, 0);
        outputLabel.setText(this.getOutputPathLabelTitle());
        gd = SwtUtils.gridDataFor((Control)outputLabel);
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 1;
        this.outputPath = new Text(composite, 2052);
        this.outputPath.setText("");
        this.outputPath.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                ConfigureReportPage.this.outputPathCustomised = true;
            }
        });
        gd = SwtUtils.gridDataFor((Control)this.outputPath);
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.fileButton = new Button(composite, 8);
        this.fileButton.setText("...");
        this.fileButton.addListener(13, this.newOutputPathListener());
        gd = SwtUtils.gridDataFor((Control)this.fileButton);
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 3;
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        SwtUtils.gridDataFor((Control)separator).horizontalSpan = 3;
        this.useCurrentFilterProjectButton = new Button(composite, 32);
        this.useCurrentFilterProjectButton.setText("Use the current filter settings from this project");
        this.useCurrentFilterProjectButton.setSelection(true);
        this.useCurrentFilterProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConfigureReportPage.this.getWizard().getContainer().updateButtons();
            }
        });
        gd = SwtUtils.gridDataFor((Control)this.useCurrentFilterProjectButton);
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 1;
        this.useCurrentFilterProjectButton.setLayoutData((Object)gd);
        this.includeFailedTestCoverageButton = new Button(composite, 32);
        this.includeFailedTestCoverageButton.setText("Include failed test coverage");
        this.includeFailedTestCoverageButton.setSelection(false);
        gd = SwtUtils.gridDataFor((Control)this.includeFailedTestCoverageButton);
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 1;
        Composite threadCountComposite = new Composite(composite, 0);
        SwtUtils.gridDataFor((Control)threadCountComposite).horizontalSpan = 2;
        GridLayout threadCountCompositeLayout = new GLH(2, false).marginHeight(0).marginWidth(0).getGridLayout();
        threadCountComposite.setLayout((Layout)threadCountCompositeLayout);
        this.threadCount = new Combo(threadCountComposite, 8);
        this.threadCount.setLayoutData((Object)new GridData(768));
        this.threadCount.setItems(new String[]{"1", "2", "3", "4", "8", "12", "16"});
        this.threadCount.select(0);
        String threadCountTooltip = "A report with more threads may finish faster but will require more memory. For very large projects, only one report thread is recommended. Smaller projects may benefit from an increased number of threads.";
        Label threadCountPreable = new Label(threadCountComposite, 0);
        threadCountPreable.setLayoutData((Object)new GridData(768));
        threadCountPreable.setText("thread(s) allocated to report generation");
        this.threadCount.setToolTipText(threadCountTooltip);
        threadCountPreable.setToolTipText(threadCountTooltip);
        this.createCustomSettings(composite);
        this.addListeners();
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateForSelectedProjects(((GenerateReportWizard)this.getWizard()).selectProjectsPage.getSelectedProjects());
            this.validate();
        }
        super.setVisible(visible);
    }

    protected void updateForSelectedProjects(CloverProject[] selectedProjects) {
        this.updateProjectFilterCombo(selectedProjects);
        this.updateTitleAndPath(selectedProjects);
    }

    private void updateTitleAndPath(CloverProject[] selectedProjects) {
        if (selectedProjects.length == 1) {
            if (!this.reportTitleCustomised) {
                this.reportTitle.setText(selectedProjects[0].getName() + " Coverage Report");
            }
            if (!this.outputPathCustomised) {
                this.outputPath.setText(this.getDefaultOutputPathFor(selectedProjects[0].getProject()));
            }
        } else {
            if (!this.reportTitleCustomised) {
                this.reportTitle.setText("Coverage Report");
            }
            if (!this.outputPathCustomised) {
                this.outputPath.setText("");
            }
        }
    }

    private void updateProjectFilterCombo(CloverProject[] selectedProjects) {
        this.useCurrentFilterProjectButton.setEnabled(selectedProjects.length == 1);
        if (!this.useCurrentFilterProjectButton.isEnabled()) {
            this.useCurrentFilterProjectButton.setSelection(false);
        }
    }

    public boolean canFlipToNextPage() {
        return this.getErrorMessage() == null;
    }

    public boolean isPageComplete() {
        return this.getErrorMessage() == null;
    }

    public IWizardPage getNextPage() {
        if (!this.useCurrentFilterProjectButton.getSelection()) {
            return ((GenerateReportWizard)this.getWizard()).configureFilterPage;
        }
        return ((GenerateReportWizard)this.getWizard()).configureJvmPage;
    }

    protected String getReportTitle() {
        return this.reportTitle.getText();
    }

    protected boolean isUsingDefaultContextFilter() {
        return this.useCurrentFilterProjectButton.getSelection();
    }

    protected File getOutput() {
        return new File(this.outputPath.getText());
    }

    public boolean shouldIncludeFailedTestCoverage() {
        return this.includeFailedTestCoverageButton.getSelection();
    }

    public ShowLambdaFunctions getShowLambdaFunctions() {
        if (this.showLambdaCombo != null && this.showLambdaCombo.getSelectionIndex() == 2) {
            return ShowLambdaFunctions.FIELDS_AND_INLINE;
        }
        if (this.showLambdaCombo != null && this.showLambdaCombo.getSelectionIndex() == 1) {
            return ShowLambdaFunctions.FIELDS_ONLY;
        }
        return ShowLambdaFunctions.NONE;
    }

    public int getNumThreads() {
        try {
            return Integer.parseInt(this.threadCount.getText()) - 1;
        }
        catch (NumberFormatException e) {
            CloverPlugin.logError("Unable to parse thread count: \"" + this.threadCount.getText() + "\", defaulting to 0", e);
            return 0;
        }
    }

    protected abstract String getDefaultOutputPathFor(IProject var1);

    protected void createShowLambdaComposite(Composite parent) {
        Composite showLambdaComposite = new Composite(parent, 0);
        SwtUtils.gridDataFor((Control)showLambdaComposite).horizontalSpan = 2;
        GridLayout compositeLayout = new GLH(2, false).marginHeight(0).marginWidth(0).getGridLayout();
        showLambdaComposite.setLayout((Layout)compositeLayout);
        this.showLambdaLabel = new Label(showLambdaComposite, 0);
        this.showLambdaLabel.setLayoutData((Object)new GridData(768));
        this.showLambdaLabel.setText("Show lambda functions: ");
        this.showLambdaCombo = new Combo(showLambdaComposite, 8);
        this.showLambdaCombo.setLayoutData((Object)new GridData(768));
        this.showLambdaCombo.setItems(new String[]{ShowLambdaFunctions.NONE.getDescription(), ShowLambdaFunctions.FIELDS_ONLY.getDescription(), ShowLambdaFunctions.FIELDS_AND_INLINE.getDescription()});
        this.showLambdaCombo.select(0);
    }
}

