/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.reports;

import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.context.ContextStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.reports.ConfigureReportPage;
import org.openclover.eclipse.core.reports.GenerateReportWizard;
import org.openclover.eclipse.core.ui.widgets.BuiltinContextFilterSelectionWidget;
import org.openclover.eclipse.core.ui.widgets.ContextFilterSelectionWidget;

public class ConfigureFilterPage
extends WizardPage {
    private BuiltinContextFilterSelectionWidget contextWidget;
    private boolean flipResize;
    ContextStore contextRegistry;
    ContextSet filter;

    public ConfigureFilterPage() {
        super("ConfigureFilter");
        this.setTitle("Report Filter Configuration");
        this.setDescription("Select what to exclude from your coverage report.");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(512));
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.contextWidget != null && !this.contextWidget.isDisposed()) {
                this.contextWidget.dispose();
            }
            ConfigureReportPage reportConfigPage = ((GenerateReportWizard)this.getWizard()).getReportTypeWizard();
            CloverProject[] selectedProjects = ((GenerateReportWizard)this.getWizard()).selectProjectsPage.getSelectedProjects();
            if (selectedProjects.length == 1) {
                this.contextRegistry = selectedProjects[0].getSettings().getContextRegistry();
                this.filter = selectedProjects[0].getSettings().getContextFilter();
            } else {
                this.contextRegistry = new ContextStore();
                this.filter = new ContextSet();
            }
            this.contextWidget = new ContextFilterSelectionWidget((Composite)this.getControl(), this.contextRegistry, this.filter);
            this.contextWidget.buildContents();
            this.contextWidget.updateSelection();
            Rectangle bounds = this.getShell().getBounds();
            bounds.height = bounds.height + (this.flipResize ? 1 : -1);
            this.getShell().setBounds(bounds);
            this.flipResize = !this.flipResize;
        }
        super.setVisible(visible);
    }

    public ContextSet getBlockContextFilter() {
        return this.contextWidget == null ? new ContextSet() : this.contextWidget.getFilterFromSelection();
    }

    public ContextStore getContextRegistry() {
        return this.contextRegistry == null ? new ContextStore() : this.contextRegistry;
    }

    public IWizardPage getNextPage() {
        return ((GenerateReportWizard)this.getWizard()).configureJvmPage;
    }

    public boolean canFlipToNextPage() {
        return true;
    }
}

