/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.model;

import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import java.io.File;
import org.eclipse.core.runtime.IAdaptable;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;

public class WorkingSetHasMetricsFilter
implements HasMetricsFilter {
    private CloverProject project;
    private File projectLocation;

    public WorkingSetHasMetricsFilter(CloverProject project) {
        this.project = project;
        this.projectLocation = project.getProject().getLocation().toFile();
    }

    @Override
    public boolean accept(HasMetrics metrics) {
        Object resource = null;
        if (metrics instanceof FullProjectInfo) {
            return CloverPlugin.getInstance().getCloverWorkingSet().includesJavaProject((IAdaptable)this.project.getProject());
        }
        if (metrics instanceof FullFileInfo) {
            return CloverPlugin.getInstance().getCloverWorkingSet().includesFile(((FullFileInfo)metrics).getPhysicalFile());
        }
        return true;
    }

    private String getPackageName(HasMetrics hasMetrics) {
        return "default-pkg".equals(hasMetrics.getName()) ? "" : hasMetrics.getName() + ".";
    }
}

