/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.model;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.entities.BaseFileInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.model.CoverageModelChangeEvent;
import org.openclover.eclipse.core.projects.model.MetricsScope;

public abstract class DatabaseModel {
    protected final CloverProject project;
    protected final CoverageModelChangeEvent changeEvent;

    protected DatabaseModel(CloverProject project, CoverageModelChangeEvent changeEvent) {
        this.project = project;
        this.changeEvent = changeEvent;
    }

    public abstract CloverDatabase getDatabase();

    public String toString() {
        return this.shortClassName() + "[" + this.project.getName() + "]";
    }

    protected String shortClassName() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public abstract boolean isLoaded();

    public abstract boolean isLoading();

    public abstract CloverDatabase forcePrematureLoad(IProgressMonitor var1);

    public abstract void loadDbAndCoverage(CoverageModelChangeEvent var1);

    public abstract void refreshCoverage(CoverageModelChangeEvent var1);

    public abstract void close(CoverageModelChangeEvent var1);

    public void onActivation(DatabaseModel predecessor) {
    }

    public void onDeactication(DatabaseModel successor) {
    }

    public abstract FullProjectInfo getFullProjectInfo();

    public abstract FullProjectInfo getTestOnlyProjectInfo();

    public abstract FullProjectInfo getAppOnlyProjectInfo();

    public abstract HasMetrics getPackageInfoOrFragment(IPackageFragment var1, MetricsScope var2);

    public abstract BaseFileInfo getSourceFileInfo(ICompilationUnit var1, MetricsScope var2);

    public abstract BaseClassInfo getTypeInfo(IType var1, MetricsScope var2);

    public abstract FullMethodInfo getMethodInfo(IMethod var1, MetricsScope var2);

    public abstract TestCaseInfo getTestCaseInfo(IMethod var1, MetricsScope var2);

    public abstract TestCaseInfo[] getTestCaseInfos(IMethod var1, MetricsScope var2);

    public abstract HasMetrics metricsProviderFor(Object var1, MetricsScope var2);

    public abstract boolean isRegistryOfDate();

    public abstract boolean isCoverageOutOfDate();

    public CoverageModelChangeEvent getLoadEvent() {
        return this.changeEvent;
    }

    public CloverProject getProject() {
        return this.project;
    }
}

