/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.model.DatabaseModel;
import org.openclover.eclipse.core.ui.projects.DatabaseChangeEvent;
import org.openclover.eclipse.core.ui.projects.DatabaseChangeListener;

public class CoverageModelsMonitor {
    private final Object OWNER_KEY = new Object();
    private final List<DatabaseChangeListener> listeners = Collections.synchronizedList(new ArrayList(2));

    public void start() {
        final MonitoringJob job = new MonitoringJob();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK() && event.getResult().getSeverity() != 8) {
                    CloverPlugin.logWarning("Job " + job.getName() + " failed: " + event.getResult(), event.getResult().getException());
                }
            }
        });
        job.schedule();
    }

    public void stop() {
        Job.getJobManager().cancel(this.OWNER_KEY);
    }

    public void addCoverageChangeListener(DatabaseChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeCoverageChangeListener(DatabaseChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void fireCoverageChange() {
        this.fireCoverageChange(null, null, null);
    }

    public void fireCoverageChange(CloverProject project) {
        DatabaseModel model = project.getModel();
        this.fireCoverageChange(project, model, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCoverageChange(CloverProject project, DatabaseModel oldModel, DatabaseModel newModel) {
        List<DatabaseChangeListener> listenersCopy;
        List<DatabaseChangeListener> list = this.listeners;
        synchronized (list) {
            listenersCopy = Collections.unmodifiableList(new ArrayList<DatabaseChangeListener>(this.listeners));
        }
        DatabaseChangeEvent event = new DatabaseChangeEvent(project, oldModel, newModel);
        for (DatabaseChangeListener listener : listenersCopy) {
            try {
                listener.databaseChanged(event);
            }
            catch (Throwable t) {
                CloverPlugin.logError("Error while notifying listener of coverage change", t);
            }
        }
    }

    private void refreshAllOpenCloverProjects() {
        CloverProject.refreshAllModels(false, false);
    }

    class MonitoringJob
    extends Job {
        public MonitoringJob() {
            super("Clover Coverage Monitor");
            this.setPriority(30);
            this.setSystem(true);
        }

        public boolean belongsTo(Object family) {
            return family == CoverageModelsMonitor.this.OWNER_KEY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (CloverPlugin.getInstance().getInstallationSettings().isAutoRefreshingCoverage()) {
                    CoverageModelsMonitor.this.refreshAllOpenCloverProjects();
                }
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (Exception e) {
                CloverPlugin.logError("Failed to refresh coverage", e);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                if (!monitor.isCanceled()) {
                    long msUntilNextRun = 0L;
                    msUntilNextRun = CloverPlugin.getInstance().getInstallationSettings().isAutoRefreshingCoverage() ? Math.max(5000L, CloverPlugin.getInstance().getInstallationSettings().getCoverageRefreshPeriod()) : 10000L;
                    this.schedule(msUntilNextRun);
                }
            }
        }
    }
}

