/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.openclover.eclipse.core.projects.builder.PathUtils;
import org.openclover.util.Lists;
import org.openclover.util.Maps;
import org.openclover.util.Sets;

public class ProjectPathMap {
    protected IPath projectLocation;
    protected IPath defaultOutputLocation;
    protected IClasspathEntry[] allClasspathEntries;
    protected IClasspathEntry[] sourcePathEntries;
    protected Map<IClasspathEntry, IPath> sourcePathsToOutputPaths;

    protected ProjectPathMap() {
    }

    public ProjectPathMap(IJavaProject project) throws CoreException {
        this.projectLocation = project.getProject().getFullPath();
        this.defaultOutputLocation = project.getJavaProject().getOutputLocation();
        this.allClasspathEntries = project.getJavaProject().getRawClasspath();
        this.sourcePathsToOutputPaths = Maps.newHashMap();
        ArrayList sourcepathEntries = Lists.newArrayList();
        for (IClasspathEntry entry : this.allClasspathEntries) {
            if (entry.getEntryKind() != 3) continue;
            sourcepathEntries.add(entry);
            this.sourcePathsToOutputPaths.put(entry, entry.getOutputLocation() == null ? this.defaultOutputLocation : entry.getOutputLocation());
        }
        this.sourcePathEntries = sourcepathEntries.toArray(new IClasspathEntry[sourcepathEntries.size()]);
    }

    public IPath getDefaultOutputLocation() {
        return this.defaultOutputLocation;
    }

    public IPath[] getAllOutputLocations() {
        ArrayList paths = Lists.newArrayList();
        if (this.defaultOutputLocation != null) {
            paths.add(this.defaultOutputLocation);
        }
        for (IClasspathEntry sourcePathEntry : this.sourcePathEntries) {
            if (sourcePathEntry.getOutputLocation() == null) continue;
            paths.add(sourcePathEntry.getOutputLocation());
        }
        return paths.toArray(new IPath[paths.size()]);
    }

    public IPath[] getSourcePaths() {
        ArrayList paths = Lists.newArrayList();
        for (IClasspathEntry sourcePathEntry : this.sourcePathEntries) {
            if (sourcePathEntry.getPath() == null) continue;
            paths.add(sourcePathEntry.getPath());
        }
        return paths.toArray(new IPath[paths.size()]);
    }

    public Set getOutputLocations() {
        LinkedHashSet<String> libraries = new LinkedHashSet<String>();
        for (IClasspathEntry sourcePathEntry : this.sourcePathEntries) {
            IPath outputLocation = sourcePathEntry.getOutputLocation();
            if (outputLocation == null) continue;
            libraries.add(PathUtils.containerFor(outputLocation).getLocation().toOSString());
        }
        if (this.defaultOutputLocation != null) {
            libraries.add(PathUtils.containerFor(this.defaultOutputLocation).getLocation().toOSString());
        }
        return libraries;
    }

    public Set<IPath> getOutputPaths() {
        LinkedHashSet<IPath> libraries = Sets.newLinkedHashSet();
        for (IClasspathEntry sourcePathEntry : this.sourcePathEntries) {
            IPath outputLocation = sourcePathEntry.getOutputLocation();
            if (outputLocation == null) continue;
            libraries.add(PathUtils.containerFor(outputLocation).getLocation());
        }
        if (this.defaultOutputLocation != null) {
            libraries.add(PathUtils.containerFor(this.defaultOutputLocation).getLocation());
        }
        return libraries;
    }

    public String toClasspath() {
        StringBuilder buffer = new StringBuilder();
        for (IClasspathEntry sourcePathEntry : this.sourcePathEntries) {
            IPath outputLocation = sourcePathEntry.getOutputLocation();
            if (outputLocation == null) continue;
            if (buffer.length() > 0) {
                buffer.append(File.pathSeparatorChar);
            }
            buffer.append(PathUtils.containerFor(outputLocation).getLocation().toOSString());
        }
        if (this.defaultOutputLocation != null) {
            if (buffer.length() > 0) {
                buffer.append(File.pathSeparatorChar);
            }
            buffer.append(PathUtils.containerFor(this.defaultOutputLocation).getLocation().toOSString());
        }
        return buffer.toString();
    }
}

