/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.builder;

import java.util.Date;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.builder.BaseCloverBuilder;
import org.openclover.eclipse.core.projects.builder.Markers;

public class PreJavaCloverBuilder
extends BaseCloverBuilder {
    public static final String ID = "org.openclover.eclipse.core.prejavabuilder";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        CloverPlugin.logVerbose("----CLOVER: PRE JAVA BUILDER (" + this.kindToString(kind) + "): " + new Date() + "----");
        Markers.deleteCloverBuilderErrorMarkers(this.getProject());
        CloverProject targetProject = CloverProject.getFor(this.getProject());
        if (targetProject != null && kind == 6 && !targetProject.getSettings().isInstrumentationEnabled()) {
            Markers.deleteCloverStaleDbMarkers(this.getProject());
        }
        return new IProject[0];
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        CloverPlugin.logVerbose("----CLOVER: PRE JAVA BUILDER CLEAN: " + new Date() + "----");
        CloverProject targetProject = CloverProject.getFor(this.getProject());
        if (targetProject != null) {
            if (!targetProject.getSettings().isInstrumentationEnabled()) {
                CloverPlugin.logVerbose("PreJavaCloverBuilder: not cleaning as Clover compilation not enabled");
            } else {
                targetProject.getBuildCoordinator().onClean(monitor);
            }
        } else {
            CloverPlugin.logWarning("PreJavaCloverBuilder: not cleaning as user project no longer open");
        }
    }
}

