/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.builder;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class Markers {
    public static final String ID = "org.openclover.eclipse.core.markers";
    public static final String PROBLEM_ID = "org.openclover.eclipse.core.markers.problem";
    public static final String STALEDB_ID = "org.openclover.eclipse.core.markers.problem.staledb";
    public static final QualifiedName STALEDB_PROPERTY_NAME = new QualifiedName("org.openclover.eclipse.core", "staledb");

    public static void createCloverBuilderProblemMarker(IResource resource, String message, int severity) throws CoreException {
        Markers.createCloverBuilderProblemMarker(resource, message, PROBLEM_ID, severity);
    }

    public static void createCloverStaleDbMarker(IResource resource, String message) throws CoreException {
        Markers.createCloverBuilderProblemMarker(resource, message, STALEDB_ID);
    }

    public static void createCloverBuilderProblemMarker(IResource resource, String message, String markerId) throws CoreException {
        Markers.createCloverBuilderProblemMarker(resource, message, markerId, 2);
    }

    public static void createCloverBuilderProblemMarker(IResource resource, final String message, String markerId, final int severity) throws CoreException {
        MarkerUtilities.createMarker((IResource)resource, (Map)new HashMap(){
            {
                this.put("severity", severity);
                this.put("message", message);
            }
        }, (String)markerId);
    }

    public static void deleteCloverBuilderErrorMarkers(IProject project) throws CoreException {
        Markers.deleteMarkersFor((IResource)project, PROBLEM_ID);
    }

    public static void deleteCloverStaleDbMarkers(IProject project) throws CoreException {
        Markers.deleteMarkersFor((IResource)project, STALEDB_ID);
    }

    public static void deleteMarkersFor(IResource resource, String type) throws CoreException {
        IMarker[] markers;
        for (IMarker marker : markers = resource.findMarkers(type, true, 0)) {
            marker.delete();
        }
    }
}

