/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.builder;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.builder.ProjectPathMap;
import org.openclover.eclipse.core.projects.settings.ProjectSettings;
import org.openclover.util.Lists;

public class InstrumentationProjectPathMap
extends ProjectPathMap {
    private CloverProject project;
    private ProjectPathMap userPathMap;
    private IPath workingArea;

    public InstrumentationProjectPathMap(CloverProject project, IPath workingArea) throws CoreException {
        this(project, new ProjectPathMap(project.getJavaProject()), workingArea);
    }

    public InstrumentationProjectPathMap(CloverProject project, ProjectPathMap userPathMap, IPath workingArea) throws CoreException {
        this.userPathMap = userPathMap;
        this.project = project;
        this.workingArea = workingArea;
        this.projectLocation = project.getProject().getFullPath();
        ProjectSettings properties = project.getSettings();
        boolean outputRootSameAsProject = properties.isOutputRootSameAsProject();
        boolean recreateOutputDirs = properties.isRecreateOutputDirs();
        this.defaultOutputLocation = outputRootSameAsProject ? userPathMap.defaultOutputLocation : (recreateOutputDirs ? InstrumentationProjectPathMap.displace(userPathMap.defaultOutputLocation, userPathMap.projectLocation, this.customRootPathFor(properties)) : this.customRootPathFor(properties));
        this.allClasspathEntries = InstrumentationProjectPathMap.resolveClasspathEntries(InstrumentationProjectPathMap.displaceAll(userPathMap.allClasspathEntries, userPathMap.projectLocation, workingArea != null, workingArea, !outputRootSameAsProject, recreateOutputDirs, outputRootSameAsProject ? this.customRootPathFor(properties) : project.getInstrumentationOutputRootDir().getFullPath()), project.getJavaProject());
        this.sourcePathEntries = this.sourcepathEntriesIn(this.allClasspathEntries);
    }

    private IPath customRootPathFor(ProjectSettings properties) {
        return this.project.getProject().getFullPath().append(properties.getOutputRoot());
    }

    private IClasspathEntry[] sourcepathEntriesIn(IClasspathEntry[] classpathEntries) {
        LinkedList sourcepathEntries = Lists.newLinkedList();
        for (IClasspathEntry classpathEntry : classpathEntries) {
            if (classpathEntry.getEntryKind() != 3) continue;
            sourcepathEntries.add(classpathEntry);
        }
        return sourcepathEntries.toArray(new IClasspathEntry[sourcepathEntries.size()]);
    }

    public IPath getDisplacedSourceRootFor(IPath path) {
        for (int i = 0; i < this.userPathMap.sourcePathEntries.length; ++i) {
            IClasspathEntry entry = this.userPathMap.sourcePathEntries[i];
            if (!entry.getPath().isPrefixOf(path)) continue;
            return this.sourcePathEntries[i].getPath();
        }
        return null;
    }

    public IPath getDisplacedSourcePathFor(IPath path) {
        for (int i = 0; i < this.userPathMap.sourcePathEntries.length; ++i) {
            IClasspathEntry entry = this.userPathMap.sourcePathEntries[i];
            if (!entry.getPath().isPrefixOf(path)) continue;
            return this.sourcePathEntries[i].getPath().append(path.removeFirstSegments(path.matchingFirstSegments(entry.getPath())));
        }
        return null;
    }

    public IPath getOutputPathForOutputResource(IPath outputResourcePath) {
        for (int i = 0; i < this.userPathMap.allClasspathEntries.length; ++i) {
            IClasspathEntry entry = this.userPathMap.allClasspathEntries[i];
            if (entry.getOutputLocation() == null || !entry.getOutputLocation().isPrefixOf(outputResourcePath)) continue;
            return InstrumentationProjectPathMap.displace(outputResourcePath, entry.getOutputLocation(), this.allClasspathEntries[i].getOutputLocation());
        }
        if (this.userPathMap.defaultOutputLocation != null && this.userPathMap.defaultOutputLocation.isPrefixOf(outputResourcePath)) {
            return InstrumentationProjectPathMap.displace(outputResourcePath, this.userPathMap.defaultOutputLocation, this.defaultOutputLocation);
        }
        return outputResourcePath;
    }

    public IPath getOriginalSourceRootFor(IPath path) {
        for (int i = 0; i < this.userPathMap.sourcePathEntries.length; ++i) {
            IClasspathEntry entry = this.userPathMap.sourcePathEntries[i];
            if (!entry.getPath().isPrefixOf(path)) continue;
            return this.userPathMap.sourcePathEntries[i].getPath();
        }
        return null;
    }

    public static IClasspathEntry[] displaceAll(IClasspathEntry[] entries, IPath root, boolean displaceSourcepathEntries, IPath srcBase, boolean displaceOutputLocations, boolean recreateOutputLocations, IPath classesBase) {
        IClasspathEntry[] displaced = new IClasspathEntry[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            IClasspathEntry entry = entries[i];
            if (entries[i].getEntryKind() == 3) {
                displaced[i] = JavaCore.newSourceEntry((IPath)(displaceSourcepathEntries ? InstrumentationProjectPathMap.displace(entry.getPath(), root, srcBase) : entry.getPath()), (IPath[])entry.getInclusionPatterns(), (IPath[])entry.getExclusionPatterns(), (IPath)(displaceOutputLocations ? (recreateOutputLocations ? InstrumentationProjectPathMap.displace(entry.getOutputLocation(), root, classesBase) : classesBase) : entry.getOutputLocation()), (IClasspathAttribute[])entry.getExtraAttributes());
                continue;
            }
            displaced[i] = entries[i];
        }
        return displaced;
    }

    public static IPath displace(IPath path, IPath root, IPath newRoot) {
        if (path != null) {
            if (!root.isPrefixOf(path)) {
                throw new IllegalArgumentException("Resource path " + path + " isn't under root path " + root);
            }
            return newRoot.append(path.removeFirstSegments(root.segmentCount()));
        }
        return path;
    }

    private static IClasspathEntry[] resolveClasspathEntries(IClasspathEntry[] classpathEntries, IJavaProject javaProject) throws JavaModelException {
        LinkedList<IClasspathEntry> classpathLibs = Lists.newLinkedList();
        for (IClasspathEntry classpathEntry : classpathEntries) {
            InstrumentationProjectPathMap.resolveAndAddEntry(classpathLibs, javaProject, classpathEntry);
        }
        return classpathLibs.toArray(new IClasspathEntry[classpathLibs.size()]);
    }

    private static void resolveAndAddEntry(Collection<IClasspathEntry> classpathLibs, IJavaProject javaProject, IClasspathEntry entry) throws JavaModelException {
        if (entry == null) {
            CloverPlugin.logWarning("Unresolved classpath entry");
        } else {
            switch (entry.getEntryKind()) {
                case 1: 
                case 2: 
                case 3: {
                    classpathLibs.add(entry);
                    break;
                }
                case 5: {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProject);
                    if (container != null) {
                        IClasspathEntry[] containerEntries;
                        for (IClasspathEntry containerEntry : containerEntries = container.getClasspathEntries()) {
                            InstrumentationProjectPathMap.resolveAndAddEntry(classpathLibs, javaProject, containerEntry);
                        }
                        break;
                    }
                    CloverPlugin.logWarning("Unable to resolve classpath container entry: " + entry.getPath());
                    break;
                }
                case 4: {
                    IClasspathEntry variableEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                    if (variableEntry != null) {
                        InstrumentationProjectPathMap.resolveAndAddEntry(classpathLibs, javaProject, variableEntry);
                        break;
                    }
                    CloverPlugin.logWarning("Unable to resolve classpath variable entry: " + entry.getPath());
                }
            }
        }
    }

    public IPath guessClassFileFor(IPath sourcePath) {
        IClasspathEntry sourcePathEntry = null;
        for (int i = 0; i < this.userPathMap.sourcePathEntries.length; ++i) {
            IClasspathEntry entry = this.userPathMap.sourcePathEntries[i];
            if (!entry.getPath().isPrefixOf(sourcePath)) continue;
            sourcePathEntry = this.userPathMap.sourcePathEntries[i];
            break;
        }
        if (sourcePathEntry != null) {
            IPath sourcePathBranch = sourcePath.removeFirstSegments(sourcePath.matchingFirstSegments(sourcePathEntry.getPath()));
            IPath outputPathRoot = sourcePathEntry.getOutputLocation() != null ? sourcePathEntry.getOutputLocation() : this.userPathMap.getDefaultOutputLocation();
            return this.getOutputPathForOutputResource(outputPathRoot).append(sourcePathBranch).removeFileExtension().addFileExtension("class");
        }
        return null;
    }

    public IPath getOutputRootForWorkignAreaSourceResource(IPath workingAreaResourcePath) {
        for (IClasspathEntry entry : this.sourcePathEntries) {
            if (entry.getOutputLocation() == null || !entry.getPath().isPrefixOf(workingAreaResourcePath)) continue;
            return entry.getOutputLocation();
        }
        return this.defaultOutputLocation;
    }

    public IPath getWorkingArea() {
        return this.workingArea;
    }
}

