/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.builder;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.instrumentation.ConcurrentInstrumentationException;
import com.atlassian.clover.api.instrumentation.InstrumentationSession;
import com.atlassian.clover.cfg.instr.java.JavaInstrumentationConfig;
import com.atlassian.clover.instr.java.Instrumenter;
import com.atlassian.clover.registry.Clover2Registry;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.exclusion.ExclusionFilter;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.builder.InstrumentationException;
import org.openclover.eclipse.core.projects.builder.InstrumentationInitialisationException;
import org.openclover.eclipse.core.projects.builder.InstrumentationProjectPathMap;
import org.openclover.eclipse.core.projects.builder.Markers;

public abstract class BaseInstrumenter {
    protected static final String INSTRUMENTATION_PROBLEM_MARKER = "org.openclover.eclipse.core.markers.instrumentation.problem";
    protected static final int LOAD_STORE_PROGRESS = 25;
    protected final Instrumenter instrumenter;
    protected final InstrumentationProjectPathMap instrumentationMapper;
    protected final ExclusionFilter exclusionFilter;
    protected final boolean isDebugging;
    protected final CloverProject project;
    protected final IProgressMonitor monitor;
    protected final boolean fullBuild;
    protected final Clover2Registry registry;
    protected boolean hasInstrumented;
    protected JavaInstrumentationConfig config;

    public BaseInstrumenter(IProgressMonitor monitor, InstrumentationProjectPathMap pathMap, CloverProject project, Clover2Registry registry, int buildKind) throws CoreException {
        this.monitor = monitor;
        this.instrumentationMapper = pathMap;
        this.project = project;
        this.registry = registry;
        this.config = project.newInsturmentationConfig();
        this.fullBuild = buildKind == 15 || buildKind == 6;
        this.instrumenter = new Instrumenter(CloverPlugin.getInstance().getCloverLogger(), this.config){

            @Override
            protected void finishAndApply(final InstrumentationSession session) throws ConcurrentInstrumentationException {
                final ConcurrentInstrumentationException[] uiThreadException = new ConcurrentInstrumentationException[]{null};
                Runnable finishWork = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            session.close();
                        }
                        catch (ConcurrentInstrumentationException e) {
                            uiThreadException[0] = e;
                        }
                    }
                };
                if (BaseInstrumenter.this.fullBuild) {
                    finishWork.run();
                } else {
                    Display.getDefault().syncExec(finishWork);
                }
                if (uiThreadException[0] != null) {
                    throw uiThreadException[0];
                }
            }
        };
        this.exclusionFilter = new ExclusionFilter(project.getSettings());
        this.isDebugging = CloverPlugin.getInstance().isDebugging();
    }

    public void start(int expectedFileCount) {
        this.monitor.beginTask("Instrumenting project source", 50 + expectedFileCount);
    }

    public void finish(boolean successful) throws InstrumentationException {
        this.monitor.subTask("Finalising source instrumentation");
        if (this.hasInstrumented) {
            try {
                long start = System.currentTimeMillis();
                CloverPlugin.logVerbose("Storing model after instrumentation");
                this.instrumenter.endInstrumentation(true);
                CloverPlugin.logVerbose("Storing model ended (" + (System.currentTimeMillis() - start) + " ms)");
                this.monitor.worked(25);
                if (!this.isIncremental()) {
                    this.project.flagStaleRegistryBecause(null);
                }
            }
            catch (CloverException e) {
                throw new InstrumentationException(e);
            }
        }
    }

    public void instrumentOrCopySource(IFile file) throws CoreException {
        try {
            if (this.filteredOut(file)) {
                this.copySource(file);
            } else {
                this.instrumentSource(file);
            }
        }
        catch (CloverException e) {
            throw new InstrumentationException(e);
        }
    }

    protected abstract void copySource(IFile var1) throws CloverException, CoreException;

    protected abstract void instrumentSource(IFile var1) throws CloverException, CoreException;

    private boolean filteredOut(IFile file) {
        boolean filteredOut = this.exclusionFilter.isFilteredOut(file);
        if (filteredOut && this.isDebugging) {
            CloverPlugin.logError("Source file " + file.getProjectRelativePath().toPortableString() + " skipped owing to Clover workingset or project instrumentation filters: [include = " + Arrays.toString(this.exclusionFilter.getIncludeFilter()) + "] [exclude = " + Arrays.toString(this.exclusionFilter.getExcludeFilter()) + "]");
        }
        return filteredOut;
    }

    protected void removeMarkers(IFile originalFile) throws CoreException {
        originalFile.deleteMarkers(INSTRUMENTATION_PROBLEM_MARKER, true, 1);
    }

    protected void maybeInitialiseInstrumentation() throws InstrumentationInitialisationException {
        if (!this.hasInstrumented) {
            try {
                this.registry.setContextStore(this.project.getSettings().getContextRegistry());
                this.startInstrumentation();
            }
            catch (CloverException e) {
                throw new InstrumentationInitialisationException(e);
            }
            finally {
                this.monitor.worked(25);
            }
        }
    }

    private void startInstrumentation() throws CloverException {
        long start = System.currentTimeMillis();
        CloverPlugin.logVerbose("Starting instrumentation");
        this.instrumenter.startInstrumentation(this.registry);
        CloverPlugin.logVerbose("Instrumentation started (" + (System.currentTimeMillis() - start) + " ms)");
    }

    private boolean isIncremental() {
        return !this.fullBuild;
    }

    private Clover2Registry truncateRegistry() throws CloverException {
        Clover2Registry reg;
        try {
            reg = Clover2Registry.createOrLoad(this.config.getRegistryFile(), this.config.getProjectName());
        }
        catch (IOException e1) {
            try {
                Markers.deleteCloverStaleDbMarkers(this.project.getProject());
                Markers.createCloverStaleDbMarker((IResource)this.project.getProject(), "Clover could not create a fresh instrumentation database:\n\n" + e1.getMessage());
            }
            catch (CoreException e2) {
                CloverPlugin.logError("Unable to create problem marker for database ", e2);
            }
            throw new CloverException("Clover could not create a fresh instrumentation database", e1);
        }
        return reg;
    }

    protected void addInstrumentationFailure(IFile originalFile, Exception e) throws CoreException {
        this.project.addInstrumentationFailure(originalFile);
        CloverPlugin.logError("Clover instrumentation failed for file " + originalFile + " - code coverage will not be recorded for this file.", e);
    }

    public abstract Iterator fileNamesAsCompilerArg();

    public char[] getContentsFor(String filename) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean willRenderContentsFor(String var1);
}

