/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CoverageDataSpec;
import com.atlassian.clover.cfg.instr.java.JavaInstrumentationConfig;
import com.atlassian.clover.cfg.instr.java.SourceLevel;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.instr.tests.AggregateTestDetector;
import com.atlassian.clover.instr.tests.AndStrategy;
import com.atlassian.clover.instr.tests.AntPatternTestDetectorFilter;
import com.atlassian.clover.instr.tests.TestDetector;
import com.atlassian.clover.recorder.PerTestCoverageStrategy;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.exclusion.DecorationPreferenceChangeListener;
import org.openclover.eclipse.core.projects.BaseNature;
import org.openclover.eclipse.core.projects.builder.BuildCoordinator;
import org.openclover.eclipse.core.projects.builder.Markers;
import org.openclover.eclipse.core.projects.builder.PathUtils;
import org.openclover.eclipse.core.projects.builder.ProjectPathMap;
import org.openclover.eclipse.core.projects.model.ClosedDatabaseModel;
import org.openclover.eclipse.core.projects.model.CoverageClearerModelDecorator;
import org.openclover.eclipse.core.projects.model.CoverageModelChangeEvent;
import org.openclover.eclipse.core.projects.model.DatabaseModel;
import org.openclover.eclipse.core.projects.model.DatabasePostLoadDecorator;
import org.openclover.eclipse.core.projects.model.DatabasePreLoadDecorator;
import org.openclover.eclipse.core.projects.model.FolderAwareTestDetectorFilter;
import org.openclover.eclipse.core.projects.model.FoldersAwareTestFilter;
import org.openclover.eclipse.core.projects.model.ModelOperation;
import org.openclover.eclipse.core.projects.model.UnloadedDatabaseModel;
import org.openclover.eclipse.core.projects.model.WorkingSetHasMetricsFilter;
import org.openclover.eclipse.core.projects.settings.ProjectSettings;
import org.openclover.util.Lists;

public class CloverProject
extends BaseNature {
    public static final String ID = "org.openclover.eclipse.core.clovernature";
    private static final QualifiedName CLOVER_VERSION_PROPERTY = new QualifiedName("org.openclover.eclipse.core", "Version");
    private static final QualifiedName FILES_BEING_COMPILED = new QualifiedName("org.openclover.eclipse.core", "FilesBeingCompiled");
    private static final QualifiedName LAST_CLEAN_BUILD_STAMP = new QualifiedName("org.openclover.eclipse.core", "last_full_build_stamp");
    private static final String DEFAULT_CLOVER_DIR = ".clover";
    private static final String COVERAGE_DB_FILE = "coverage.db";
    private static final String CLOVER_JAR_MISSING_MSG = "Your instrumented application could not find the Clover classes necessary to record coverage. Please use the 'Run with Clover' option to correct this.";
    private volatile DatabaseModel model = new UnloadedDatabaseModel(this);
    private final ILock modelMutex = Job.getJobManager().newLock();
    private final BuildCoordinator buildCoordinator = new BuildCoordinator(this);
    private ProjectSettings settings;
    private static final IEclipsePreferences.IPreferenceChangeListener EXCLUSION_PREFERENCE_CHANGE_LISTENER = new DecorationPreferenceChangeListener();
    private static final int JOIN_SLEEP_MS = 1000;

    public void configure() throws CoreException {
        this.ensureClasspathEntryAdded(this.getCloverJar());
        CloverProject.ensureBuildersPresent(this.project);
        this.ensureLastBuildStamped();
    }

    public static void ensureBuildersPresent(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        List<ICommand> commands = Lists.newArrayList(project.getDescription().getBuildSpec());
        commands = CloverProject.ensureBuilderAddedBefore(description, commands, "org.eclipse.jdt.core.javabuilder", "org.openclover.eclipse.core.prejavabuilder", "org.openclover.eclipse.core.nojavabuilder");
        commands = CloverProject.ensureBuilderAddedAfter(description, commands, "org.eclipse.jdt.core.javabuilder", "org.openclover.eclipse.core.postjavabuilder", "org.openclover.eclipse.core.nojavabuilder");
        description.setBuildSpec(commands.toArray(new ICommand[commands.size()]));
        project.setDescription(description, null);
    }

    public static boolean buildersPresent(IProject project) throws CoreException {
        ArrayList<ICommand> builders = Lists.newArrayList(project.getDescription().getBuildSpec());
        return CloverProject.builderPresent(builders, "org.openclover.eclipse.core.prejavabuilder") && CloverProject.builderPresent(builders, "org.openclover.eclipse.core.postjavabuilder") || CloverProject.builderPresent(builders, "org.openclover.eclipse.core.nojavabuilder");
    }

    public static boolean builderPresent(IProject project, String builderId) throws CoreException {
        return CloverProject.builderPresent(Lists.newArrayList(project.getDescription().getBuildSpec()), builderId);
    }

    private static boolean builderPresent(List builders, String builderId) {
        for (int i = 0; i < builders.size(); ++i) {
            if (!((ICommand)builders.get(i)).getBuilderName().equals(builderId)) continue;
            return true;
        }
        return false;
    }

    private void ensureLastBuildStamped() {
        try {
            if (this.project.getPersistentProperty(LAST_CLEAN_BUILD_STAMP) != null) {
                this.project.setPersistentProperty(LAST_CLEAN_BUILD_STAMP, Long.toString(System.currentTimeMillis()));
            }
        }
        catch (CoreException e) {
            CloverPlugin.logError("Unable to set initial time stamp for project", e);
        }
    }

    public void deconfigure() throws CoreException {
        Markers.deleteMarkersFor((IResource)this.project, "org.openclover.eclipse.core.markers");
        CloverProject.ensureBuilderRemoved(this.project, "org.openclover.eclipse.core.prejavabuilder");
        CloverProject.ensureBuilderRemoved(this.project, "org.openclover.eclipse.core.postjavabuilder");
        CloverProject.ensureBuilderRemoved(this.project, "org.openclover.eclipse.core.nojavabuilder");
        this.ensureClasspathEntryAbsent(this.getCloverJar());
        this.settings.removeListener(EXCLUSION_PREFERENCE_CHANGE_LISTENER);
    }

    @Override
    public void setProject(final IProject project) {
        super.setProject(project);
        this.settings = new ProjectSettings(project);
        this.settings.upgrade();
        this.settings.addListener(EXCLUSION_PREFERENCE_CHANGE_LISTENER);
        this.ensureWorkingDirCreated();
        this.ensureLastBuildStamped();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getResource().equals((Object)project) && project.isOpen()) {
                    CloverPlugin.logVerbose("A Clover project is closing");
                    CloverProject.this.setModel(new ClosedDatabaseModel(CloverProject.this, CoverageModelChangeEvent.CLOSE(CloverProject.this)));
                }
            }
        }, 2);
    }

    public void ensureWorkingDirCreated() {
        IFolder workingDir = this.getCloverWorkingDir();
        if (!workingDir.exists()) {
            try {
                PathUtils.makeDerivedFoldersFor((IResource)workingDir);
            }
            catch (CoreException e) {
                CloverPlugin.logError("Unable to create Clover working directory " + workingDir.getLocation(), e);
            }
        }
    }

    private IClasspathEntry getCloverJar() {
        return JavaCore.newVariableEntry((IPath)CloverPlugin.CLOVER_RUNTIME_VARIABLE, null, null);
    }

    public void refreshCloverWorkingDir(IProgressMonitor monitor) throws CoreException {
        this.getCloverWorkingDir().refreshLocal(2, monitor);
    }

    public static boolean isAppliedTo(IProject project) throws CoreException {
        return project != null && project.exists() && project.isOpen() && project.isAccessible() && project.getNature(ID) != null;
    }

    public static boolean isAppliedTo(IJavaProject project) throws CoreException {
        return project != null && project.exists() && project.getProject().isOpen() && project.getProject().isAccessible() && project.getProject().getNature(ID) != null;
    }

    public static void toggle(IJavaProject project) throws CoreException {
        IProjectDescription description;
        boolean isApplied = CloverProject.isAppliedTo(project);
        try {
            description = project.getProject().getDescription();
        }
        catch (CoreException e) {
            CloverPlugin.logError("Error getting description from project", e);
            throw e;
        }
        String[] oldIds = description.getNatureIds();
        ArrayList<String> newIds = Lists.newArrayList(oldIds);
        if (isApplied) {
            CloverPlugin.logVerbose("Removing natureorg.openclover.eclipse.core.clovernature");
            newIds.remove(ID);
        } else {
            CloverPlugin.logVerbose("Adding nature org.openclover.eclipse.core.clovernature");
            newIds.add(ID);
        }
        description.setNatureIds(newIds.toArray(new String[newIds.size()]));
        if (isApplied) {
            try {
                CloverProject.getFor(project).closeCoverage();
            }
            catch (CoreException e) {
                CloverPlugin.logError("Error closing coverage model", e);
            }
        }
        try {
            project.getProject().setDescription(description, null);
            CloverPlugin.getInstance().getCoverageMonitor().fireCoverageChange();
        }
        catch (CoreException e) {
            CloverPlugin.logError("Error setting description for project, attempting to undo", e);
            try {
                description.setNatureIds(oldIds);
                project.getProject().setDescription(description, null);
            }
            catch (CoreException e2) {
                CloverPlugin.logError("Error undoing changes to description for project, most likely related to the previous error", e2);
            }
            throw e;
        }
    }

    public static CloverProject getFor(IProject project) throws CoreException {
        return CloverProject.isAppliedTo(project) ? (CloverProject)project.getNature(ID) : null;
    }

    public static CloverProject getFor(IJavaProject project) throws CoreException {
        return CloverProject.isAppliedTo(project) ? (CloverProject)project.getProject().getNature(ID) : null;
    }

    public IFolder getCloverWorkingDir() {
        return this.getProject().getFolder(DEFAULT_CLOVER_DIR);
    }

    public File getRegistryFile() {
        if (this.settings.isInitStringDefault()) {
            return this.getCloverWorkingDir().getFile(COVERAGE_DB_FILE).getLocation().toFile();
        }
        String initString = this.settings.getInitString();
        if (this.settings.isInitStringProjectRelative()) {
            return new File(this.getProject().getLocation().toFile(), initString);
        }
        return new File(initString);
    }

    public IFile getCoverageDbIFile() {
        if (this.settings.isInitStringDefault()) {
            return this.getCloverWorkingDir().getFile(COVERAGE_DB_FILE);
        }
        String initString = this.settings.getInitString();
        if (this.settings.isInitStringProjectRelative()) {
            try {
                return this.getProject().getFile(initString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String getName() {
        return this.project.getName();
    }

    public JavaInstrumentationConfig newInsturmentationConfig() throws CoreException {
        JavaInstrumentationConfig config = new JavaInstrumentationConfig();
        config.setInitstring(this.deriveInitString());
        config.setProjectName(this.project.getName());
        config.setEncoding(this.getProject().getDefaultCharset());
        config.setDefaultBaseDir(this.getProject().getLocation().toFile());
        config.setSourceLevel(SourceLevel.fromString(this.getJavaProject().getOption("org.eclipse.jdt.core.compiler.source", true)));
        config.setFlushPolicy(this.settings.getFlushPolicy());
        config.setFlushInterval(this.settings.getFlushInterval());
        config.setFullyQualifyJavaLang(this.settings.shouldQualifyJavaLang());
        config.setTestDetector(this.getTestDetector(config.getTestDetector()));
        config.setInstrLevelStrategy(this.settings.getInstrumentationLevel().name());
        config.setInstrumentLambda(this.settings.getInstrumentLambda());
        config.setClassNotFoundMsg(CLOVER_JAR_MISSING_MSG);
        return config;
    }

    private TestDetector getTestDetector(TestDetector defaultTestDetector) {
        switch (this.settings.getTestSourceFolders()) {
            case 2: {
                return new TestDetector(){

                    @Override
                    public boolean isTypeMatch(TestDetector.SourceContext sourceContext, TestDetector.TypeContext typeContext) {
                        return false;
                    }

                    @Override
                    public boolean isMethodMatch(TestDetector.SourceContext sourceContext, TestDetector.MethodContext methodContext) {
                        return false;
                    }
                };
            }
            case 1: {
                AggregateTestDetector atd = new AggregateTestDetector(new AndStrategy());
                atd.addDetector(new FolderAwareTestDetectorFilter(this, this.getSettings().getSelectedTestFolders()));
                atd.addDetector(defaultTestDetector);
                return atd;
            }
        }
        AggregateTestDetector atd = new AggregateTestDetector(new AndStrategy());
        atd.addDetector(new AntPatternTestDetectorFilter(this.project.getLocation().toFile(), this.getSettings().calculateTestIncludeFilter(), this.getSettings().calculateTestExcludeFilter()));
        atd.addDetector(defaultTestDetector);
        return atd;
    }

    public String deriveInitString() {
        if (this.settings.isInitStringDefault()) {
            return this.getCloverWorkingDir().getLocation().append(COVERAGE_DB_FILE).toPortableString();
        }
        String initString = this.settings.getInitString();
        if (this.settings.isInitStringProjectRelative()) {
            return new File(this.getProject().getLocation().toFile(), initString).getAbsolutePath();
        }
        return initString;
    }

    public <T> T onPinnedModel(ModelOperation<T> operation) {
        this.modelMutex.acquire();
        try {
            T t = operation.run(this.model);
            return t;
        }
        finally {
            this.modelMutex.release();
        }
    }

    public DatabaseModel getModel() {
        return this.onPinnedModel(new ModelOperation<DatabaseModel>(){

            @Override
            public DatabaseModel run(DatabaseModel model) {
                if (!model.isLoaded()) {
                    model.loadDbAndCoverage(CoverageModelChangeEvent.IDLY(CloverProject.this));
                }
                return model;
            }
        });
    }

    public void setModel(final DatabaseModel update) {
        this.onPinnedModel(new ModelOperation<Void>(){

            @Override
            public Void run(DatabaseModel model) {
                CloverProject.this.maybeSetModel(model, update);
                return null;
            }
        });
    }

    public boolean compareAndSetModel(final DatabaseModel expected, final DatabaseModel update) {
        return this.onPinnedModel(new ModelOperation<Boolean>(){

            @Override
            public Boolean run(DatabaseModel model) {
                return CloverProject.this.maybeSetModel(expected, update);
            }
        });
    }

    private boolean maybeSetModel(DatabaseModel expected, DatabaseModel update) {
        if (this.model == expected) {
            CloverPlugin.logVerbose("De-activating coverage model " + expected);
            try {
                this.model.onDeactication(update);
            }
            catch (Throwable t) {
                CloverPlugin.logError("Failed to deactivate model " + this.model, t);
            }
            CloverPlugin.logVerbose("Switching coverage model from " + expected + " to " + update);
            this.model = update;
            CloverPlugin.logVerbose("Activating coverage model " + update);
            try {
                this.model.onActivation(expected);
            }
            catch (Throwable t) {
                CloverPlugin.logDebug("Failed to activate model " + this.model, t);
            }
            CloverPlugin.getInstance().getCoverageMonitor().fireCoverageChange(this, expected, update);
            return true;
        }
        return false;
    }

    public CloverDatabase joinOnLoad(IProgressMonitor monitor) {
        CloverDatabase database = null;
        do {
            DatabaseModel loadedOrLoadingModel;
            if ((loadedOrLoadingModel = this.onPinnedModel(new ModelOperation<DatabaseModel>(){

                @Override
                public DatabaseModel run(DatabaseModel model) {
                    if (model.isLoading() || model.isLoaded()) {
                        return model;
                    }
                    model.loadDbAndCoverage(new CoverageModelChangeEvent(CloverProject.this, "Load-join", false));
                    return null;
                }
            })) != null) {
                if (loadedOrLoadingModel.isLoading()) {
                    database = loadedOrLoadingModel.forcePrematureLoad(monitor);
                } else if (loadedOrLoadingModel.isLoaded()) {
                    database = loadedOrLoadingModel.getDatabase();
                }
            }
            if (database != null) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (database == null && !monitor.isCanceled());
        return database;
    }

    public static void refreshAllModels(boolean forceModelReload, boolean forceCoverageReoload) {
        IProject[] projects;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        for (IProject project : projects = workspace.getRoot().getProjects()) {
            try {
                if (!CloverProject.isAppliedTo(project)) continue;
                CloverProject.getFor(project).refreshModel(forceModelReload, forceCoverageReoload);
            }
            catch (CoreException e) {
                CloverPlugin.logError("Error while refreshing coverage for project " + project.getName(), e);
            }
        }
    }

    public void refreshModel(boolean forceModelReload, boolean forceCoverageReload) {
        this.refreshModel(forceModelReload, forceCoverageReload, new CoverageModelChangeEvent(this, "Reloading coverage", forceModelReload));
    }

    public void refreshModel(final boolean forceModelReload, final boolean forceCoverageReload, final CoverageModelChangeEvent changeEvent) {
        this.onPinnedModel(new ModelOperation<Void>(){

            @Override
            public Void run(DatabaseModel model) {
                if ((forceModelReload || model.isRegistryOfDate()) && !model.isLoading()) {
                    model.loadDbAndCoverage(changeEvent);
                } else if ((forceCoverageReload || model.isCoverageOutOfDate()) && !model.isLoading()) {
                    model.refreshCoverage(changeEvent);
                }
                return null;
            }
        });
    }

    public void clearCoverage() {
        this.onPinnedModel(new ModelOperation<Void>(){

            @Override
            public Void run(DatabaseModel model) {
                model.loadDbAndCoverage(new CoverageModelChangeEvent("Clearing coverage", true, new DatabasePreLoadDecorator[]{new CoverageClearerModelDecorator()}, DatabasePostLoadDecorator.NONE));
                return null;
            }
        });
    }

    private void closeCoverage() {
        this.onPinnedModel(new ModelOperation<Void>(){

            @Override
            public Void run(DatabaseModel model) {
                model.close(CoverageModelChangeEvent.CLOSE(CloverProject.this));
                return null;
            }
        });
    }

    public IFolder getReportDir() {
        return this.getCloverWorkingDir().getFolder("report");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOnWorkingDir(Callable callable) throws Exception {
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ISchedulingRule rule = ruleFactory.createRule((IResource)this.getCloverWorkingDir());
        try {
            Job.getJobManager().beginRule(rule, null);
            callable.call();
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
    }

    public ISchedulingRule getCloverWorkingDirSchedulingRule() {
        return this.getCloverWorkingDir();
    }

    public ProjectPathMap getPathMap() throws CoreException {
        return new ProjectPathMap(this.getJavaProject());
    }

    public void addInstrumentationFailure(IFile originalFile) throws CoreException {
        ArrayList failures = (ArrayList)this.getProject().getSessionProperty(new QualifiedName("org.openclover.eclipse.core", "instrumentation.failures"));
        if (failures == null) {
            failures = Lists.newArrayList();
            this.getProject().setSessionProperty(new QualifiedName("org.openclover.eclipse.core", "instrumentation.failures"), failures);
        }
        failures.add(originalFile);
    }

    public void clearInstrumentationFailures() throws CoreException {
        this.getProject().setSessionProperty(new QualifiedName("org.openclover.eclipse.core", "instrumentation.failures"), new ArrayList());
    }

    public List getInstrumentationFailures() throws CoreException {
        List failures = (List)this.getProject().getSessionProperty(new QualifiedName("org.openclover.eclipse.core", "instrumentation.failures"));
        if (failures == null) {
            failures = Collections.emptyList();
        }
        return failures;
    }

    public BuildCoordinator getBuildCoordinator() throws CoreException {
        return this.buildCoordinator;
    }

    public ProjectSettings getSettings() {
        return this.settings;
    }

    public static Version getLastVersionStamp(IProject project) throws CoreException {
        try {
            String versionString = project.getPersistentProperty(CLOVER_VERSION_PROPERTY);
            return versionString == null ? Version.V2_0_0_A1_1 : new Version(versionString);
        }
        catch (CoreException e) {
            CloverPlugin.logError("Unable to query Clover version last applied to project", e);
            throw e;
        }
    }

    public static void stampWithCurrentVersion(IProject project) throws CoreException {
        project.setPersistentProperty(CLOVER_VERSION_PROPERTY, Version.CURRENT_VERSION.toString());
    }

    public static boolean toggleWithUserFeedback(Shell shell, IProject project) {
        return CloverProject.toggleWithUserFeedback(shell, JavaCore.create((IProject)project));
    }

    public static boolean toggleWithUserFeedback(final Shell shell, IJavaProject javaProject) {
        final boolean[] isProjectCloverEnabled = new boolean[]{false};
        try {
            isProjectCloverEnabled[0] = CloverProject.isAppliedTo(javaProject);
        }
        catch (CoreException e) {
            CloverPlugin.logError("Unable to determine if project is Clover-enabled", e);
        }
        try {
            CloverProject.toggle(javaProject);
            return true;
        }
        catch (Throwable t) {
            CloverPlugin.logError("Error toggling Clover support", t);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)shell, (String)("Unable to " + (isProjectCloverEnabled[0] ? "disable" : "enable") + " Clover"), (String)("An error occurred while " + (isProjectCloverEnabled[0] ? "disabling" : "enabling") + " Clover on this project.\nPlease check that Eclipse has permission to write to the project directory, that\nany Team plugins you use allow Eclipse to save the project file and then try\nagain."));
                }
            });
            return false;
        }
    }

    public IFolder getInstrumentationOutputRootDir() throws CoreException {
        if (!this.getSettings().isOutputRootSameAsProject()) {
            IPath path = this.project.getFullPath().append(this.getSettings().getOutputRoot());
            if (ResourcesPlugin.getWorkspace().validatePath(path.toString(), 2).getCode() == 0) {
                return ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
            }
        }
        return null;
    }

    public CloverProject[] getDependencies() throws CoreException {
        IProject[] referenced = this.getProject().getReferencedProjects();
        ArrayList<CloverProject> projects = new ArrayList<CloverProject>(referenced.length);
        for (IProject project : referenced) {
            if (!CloverProject.isAppliedTo(project)) continue;
            projects.add(CloverProject.getFor(project));
        }
        return projects.toArray(new CloverProject[projects.size()]);
    }

    public long getLastCleanBuildStamp() {
        return CloverProject.getLastCleanBuildStamp(this.project);
    }

    public static long getLastCleanBuildStamp(IProject project) {
        try {
            String value = project.getPersistentProperty(LAST_CLEAN_BUILD_STAMP);
            return value == null ? 0L : Long.parseLong(value);
        }
        catch (CoreException e) {
            CloverPlugin.logError("Invalid build stamp", e);
            long now = System.currentTimeMillis();
            CloverProject.setLastCleanBuildStamp(project, now);
            return now;
        }
    }

    public void setLastCleanBuildStamp(long timeStamp) {
        CloverProject.setLastCleanBuildStamp(this.project, timeStamp);
    }

    private static void setLastCleanBuildStamp(IProject project, long timeStamp) {
        try {
            project.setPersistentProperty(LAST_CLEAN_BUILD_STAMP, Long.toString(timeStamp));
        }
        catch (CoreException e) {
            CloverPlugin.logError("Unable to set build stamp for project", e);
        }
    }

    public IPath getWorkingPath() {
        return this.project.getWorkingLocation(CloverPlugin.getInstance().getBundle().getSymbolicName());
    }

    public void setFilesNeedingCloverCompile(Set<IFile> files) throws CoreException {
        this.project.setSessionProperty(FILES_BEING_COMPILED, files);
    }

    public void clearFilesNeedingCloverCompile() throws CoreException {
        this.project.setSessionProperty(FILES_BEING_COMPILED, null);
    }

    public Set<IFile> getFilesNeedingCloverCompile() throws CoreException {
        return (Set)this.project.getSessionProperty(FILES_BEING_COMPILED);
    }

    public boolean okayToRebuild(Shell shell) {
        return MessageDialog.openQuestion((Shell)shell, (String)"Clover compilation settings changed", (String)"Clover compilation settings have changed. To take effect you should rebuild your project.\n\nRebuild your project now?");
    }

    public CloverDatabase newEmptyDatabase() {
        return this.newEmptyDatabase(this.settings.getContextFilter());
    }

    public CloverDatabase newEmptyDatabase(ContextSet contextFilter) {
        return new CloverDatabase(this.getRegistryFile(), false, this.project.getName(), contextFilter, this.newCoverageDataSpec(null));
    }

    public HasMetricsFilter newIncludeFilter() {
        return CloverPlugin.getInstance().isInWorkingSetMode() ? new WorkingSetHasMetricsFilter(this) : HasMetricsFilter.ACCEPT_ALL;
    }

    public CoverageDataSpec newCoverageDataSpec(CloverDatabase database) {
        return new CoverageDataSpec(FoldersAwareTestFilter.getFor(this), this.settings.calcEffectiveSpanMS(database), this.shouldDeleteUnusedCoverage(), true, true, CloverPlugin.getInstance().getInstallationSettings().isTrackingPerTestCoverage(), CloverPlugin.getInstance().getInstallationSettings().isPerTestCoverageInMemory() ? PerTestCoverageStrategy.IN_MEMORY : PerTestCoverageStrategy.SAMPLING);
    }

    public boolean shouldDeleteUnusedCoverage() {
        return this.settings.isInstrumentationEnabled();
    }

    public void flagStaleRegistryBecause(String message) {
        try {
            this.project.setPersistentProperty(Markers.STALEDB_PROPERTY_NAME, message);
            Markers.deleteCloverStaleDbMarkers(this.project.getProject());
            if (message != null) {
                Markers.createCloverStaleDbMarker((IResource)this.project.getProject(), message);
            }
        }
        catch (CoreException e) {
            CloverPlugin.logError("Unable to set/unset stale registry message", e);
        }
    }

    public static class Version
    implements Comparable {
        public static final Version V2_0_0_A1 = new Version("2_0_0_a1");
        public static final Version V2_0_0_A1_1 = new Version("2_0_0_a1_1");
        public static final Version V2_0_0_A2 = new Version("2_0_0_a2");
        public static final Version V2_0_0_B1 = new Version("2_0_0_b1");
        public static final Version V2_0_0_B2 = new Version("2_0_0_b2");
        public static final Version CURRENT_VERSION = new Version("4.5.2.v20240131000000".replace('.', '_'));
        private String label;

        public Version(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Version version = (Version)o;
            return Objects.equals(this.label, version.label);
        }

        public int hashCode() {
            return this.label != null ? this.label.hashCode() : 0;
        }

        public int compareTo(Object other) {
            if (other instanceof Version) {
                return this.label.compareTo(((Version)other).label);
            }
            return -1;
        }
    }

    public static interface Callable {
        public void call() throws Exception;
    }
}

