/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.util.Lists;

public abstract class BaseNature
implements IProjectNature {
    protected IProject project;

    public IProject getProject() {
        return this.project;
    }

    public IJavaProject getJavaProject() throws CoreException {
        return this.getJavaProject(this.project);
    }

    protected IJavaProject getJavaProject(IProject project) throws CoreException {
        return (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    protected static List<ICommand> ensureBuilderAddedAfter(IProjectDescription description, List<ICommand> commands, String primaryId, String subsequentId, String absentId) throws CoreException {
        return BaseNature.ensureBuilderAdded(description, commands, false, primaryId, subsequentId, absentId);
    }

    protected static List<ICommand> ensureBuilderAddedBefore(IProjectDescription description, List<ICommand> commands, String primaryId, String subsequentId, String absentId) throws CoreException {
        return BaseNature.ensureBuilderAdded(description, commands, true, primaryId, subsequentId, absentId);
    }

    private static List<ICommand> ensureBuilderAdded(IProjectDescription description, List<ICommand> commands, boolean before, String primaryId, String subsequentId, String absentId) throws CoreException {
        int i;
        CloverPlugin.logVerbose("adding builder " + subsequentId);
        boolean added = false;
        ArrayList<ICommand> newCommands = new ArrayList<ICommand>(commands.size() + 1);
        newCommands.addAll(commands);
        for (i = 0; i < newCommands.size(); ++i) {
            if (!((ICommand)newCommands.get(i)).getBuilderName().equals(subsequentId)) continue;
            newCommands.remove(i);
        }
        for (i = 0; i < newCommands.size(); ++i) {
            if (!((ICommand)newCommands.get(i)).getBuilderName().equals(primaryId)) continue;
            newCommands.add(before ? i : i + 1, BaseNature.newCommand(description, subsequentId));
            added = true;
            break;
        }
        if (!added) {
            boolean absentBuilderIdPresent = false;
            for (int i2 = 0; i2 < commands.size(); ++i2) {
                if (!((ICommand)newCommands.get(i2)).getBuilderName().equals(absentId)) continue;
                absentBuilderIdPresent = true;
                break;
            }
            if (!absentBuilderIdPresent) {
                newCommands.add(BaseNature.newCommand(description, absentId));
            }
        }
        return newCommands;
    }

    private static ICommand newCommand(IProjectDescription description, String subsequentId) {
        ICommand command = description.newCommand();
        command.setBuilderName(subsequentId);
        return command;
    }

    public static void ensureBuilderRemoved(IProject project, String builderId) throws CoreException {
        if (BaseNature.alreadyContainsBuilder(project, builderId)) {
            BaseNature.removeBuilder(project, builderId);
        }
    }

    private static boolean alreadyContainsBuilder(IProject project, String builderId) throws CoreException {
        ICommand[] commands;
        for (ICommand command : commands = project.getDescription().getBuildSpec()) {
            if (!command.getBuilderName().equals(builderId)) continue;
            return true;
        }
        return false;
    }

    private static void removeBuilder(IProject project, String builderId) throws CoreException {
        IProjectDescription description = project.getDescription();
        ArrayList<ICommand> updatedCommands = Lists.newArrayList(description.getBuildSpec());
        Iterator<ICommand> commandIter = updatedCommands.iterator();
        while (commandIter.hasNext()) {
            if (!commandIter.next().getBuilderName().equals(builderId)) continue;
            CloverPlugin.logVerbose("removing builder " + builderId);
            commandIter.remove();
            break;
        }
        description.setBuildSpec(updatedCommands.toArray(new ICommand[updatedCommands.size()]));
        project.setDescription(description, null);
    }

    protected void ensureClasspathEntryAdded(IClasspathEntry newEntry) throws CoreException {
        IJavaProject javaProject = this.getJavaProject();
        ArrayList<IClasspathEntry> newEntries = Lists.newArrayList(javaProject.getRawClasspath());
        Iterator iterator = newEntries.iterator();
        while (iterator.hasNext()) {
            IClasspathEntry entry = (IClasspathEntry)iterator.next();
            if (!this.similarOrSame(entry, newEntry)) continue;
            iterator.remove();
        }
        newEntries.add(0, newEntry);
        javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), null);
    }

    protected boolean similarOrSame(IClasspathEntry entry1, IClasspathEntry entry2) {
        return entry1.equals(entry2) || entry1.getPath().lastSegment().equals(entry2.getPath().lastSegment());
    }

    protected void ensureClasspathEntryAbsent(IClasspathEntry entry) throws CoreException {
        IJavaProject javaProject = this.getJavaProject();
        ArrayList<IClasspathEntry> oldEntries = Lists.newArrayList(javaProject.getRawClasspath());
        Iterator oldEntriesIter = oldEntries.iterator();
        while (oldEntriesIter.hasNext()) {
            IClasspathEntry oldEntry = (IClasspathEntry)oldEntriesIter.next();
            if (!this.similarOrSame(oldEntry, entry)) continue;
            oldEntriesIter.remove();
        }
        javaProject.setRawClasspath(oldEntries.toArray(new IClasspathEntry[oldEntries.size()]), null);
    }
}

