/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.launching;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.builder.InstrumentationProjectPathMap;
import org.openclover.eclipse.core.projects.settings.ProjectSettings;
import org.openclover.util.Lists;
import org.openclover.util.Sets;

public abstract class CloveredLauncherDelegate
implements ILaunchConfigurationDelegate2,
IExecutableExtension {
    private ILaunchConfigurationDelegate launchdelegate;
    private ILaunchConfigurationDelegate2 launchdelegate2;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.launchdelegate = this.launchDelegateFor(config.getAttribute("type"));
        this.launchdelegate2 = this.launchdelegate instanceof ILaunchConfigurationDelegate2 ? (ILaunchConfigurationDelegate2)this.launchdelegate : null;
    }

    private ILaunchConfigurationDelegate launchDelegateFor(String launchType) throws CoreException {
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(launchType);
        if (type == null) {
            throw CloverPlugin.logAndThrowError("Unknown launch type " + launchType);
        }
        ILaunchDelegate[] delegates = type.getDelegates(Sets.newHashSet("run"));
        if (delegates.length > 0) {
            return delegates[0].getDelegate();
        }
        return null;
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Launching " + config.getName(), 1);
        if (!monitor.isCanceled()) {
            ILaunchConfigurationWorkingCopy configurationWorkingCopy = this.bindCustomOutputDirToLaunchClasspath(this.bindCloverRuntimeJarToLaunch(config.getWorkingCopy()));
            if (this.launchdelegate != null) {
                this.launchdelegate.launch((ILaunchConfiguration)configurationWorkingCopy, "run", launch, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            }
            monitor.done();
        }
    }

    protected ILaunchConfigurationWorkingCopy bindCloverRuntimeJarToLaunch(ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        return workingCopy;
    }

    protected ILaunchConfigurationWorkingCopy bindCustomOutputDirToLaunchClasspath(ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        ProjectSettings settings;
        CloverProject cloverProject;
        IProject project;
        String projectName = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, (String)null);
        if (projectName != null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && (cloverProject = CloverProject.getFor(project)) != null && !(settings = cloverProject.getSettings()).isOutputRootSameAsProject()) {
            LinkedList launchClasspath = Lists.newLinkedList();
            Set<IPath> outputPaths = new InstrumentationProjectPathMap(cloverProject, null).getOutputPaths();
            for (IPath outputPath : outputPaths) {
                launchClasspath.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)outputPath).getMemento());
            }
            List origLaunchClasspath = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, (List)null);
            if (origLaunchClasspath == null) {
                IRuntimeClasspathEntry[] classpathEntries;
                for (IRuntimeClasspathEntry classpathEntry : classpathEntries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)workingCopy)) {
                    launchClasspath.add(classpathEntry.getMemento());
                }
            } else {
                for (String cp : origLaunchClasspath) {
                    launchClasspath.add(cp);
                }
            }
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, launchClasspath);
        }
        return workingCopy;
    }

    public ILaunch getLaunch(ILaunchConfiguration config, String mode) throws CoreException {
        return new Launch(config, "clover", null);
    }

    public boolean buildForLaunch(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        if (this.launchdelegate2 == null) {
            return true;
        }
        return this.launchdelegate2.buildForLaunch(config, "run", monitor);
    }

    public boolean finalLaunchCheck(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        if (this.launchdelegate2 == null) {
            return true;
        }
        return this.launchdelegate2.finalLaunchCheck(config, "run", monitor);
    }

    public boolean preLaunchCheck(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        if (this.launchdelegate2 == null) {
            return true;
        }
        return this.launchdelegate2.preLaunchCheck(config, mode, monitor);
    }

    protected String resolveCloverRuntimeJar(ILaunchConfiguration config) throws CoreException {
        return JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)JavaRuntime.newVariableRuntimeClasspathEntry((IPath)CloverPlugin.CLOVER_RUNTIME_VARIABLE), (ILaunchConfiguration)config)[0].getLocation();
    }
}

