/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.openclover.eclipse.core.CloverPlugin;

public class CloveredLaunchShortcut
implements ILaunchShortcut,
IExecutableExtension {
    private static ILaunchShortcut EMPTY_SHORTCUT_DELEGATE = new ILaunchShortcut(){

        public void launch(ISelection selection, String mode) {
        }

        public void launch(IEditorPart editor, String mode) {
        }
    };
    private ILaunchShortcut delegate;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String delegateId = String.valueOf(data);
        try {
            IConfigurationElement[] configs;
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.debug.ui", "launchShortcuts");
            for (IConfigurationElement cfg : configs = extensionPoint.getConfigurationElements()) {
                if (!delegateId.equals(cfg.getAttribute("id"))) continue;
                this.delegate = (ILaunchShortcut)cfg.createExecutableExtension("class");
            }
        }
        catch (CoreException e) {
            CloverPlugin.logError("Error creating launch delegate", e);
        }
        if (this.delegate == null) {
            this.delegate = EMPTY_SHORTCUT_DELEGATE;
            CloverPlugin.logError("Launch shortcut not found for id: " + delegateId);
        }
    }

    public void launch(ISelection selection, String mode) {
        this.delegate.launch(selection, "clover");
    }

    public void launch(IEditorPart editor, String mode) {
        this.delegate.launch(editor, "clover");
    }
}

