/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.exclusion;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.openclover.eclipse.core.exclusion.CloverExcludable;
import org.openclover.eclipse.core.exclusion.ICloverExcludable;
import org.openclover.eclipse.core.projects.CloverProject;

public class CloverExcludableAdapterFactory
implements IAdapterFactory {
    private static Class[] ADAPTER_LIST = new Class[]{ICloverExcludable.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == ICloverExcludable.class && adaptableObject instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)adaptableObject;
            IProject project = javaElement.getJavaProject().getProject();
            try {
                if (!CloverProject.isAppliedTo(project)) {
                    return null;
                }
            }
            catch (CoreException e) {
                return null;
            }
            if (adaptableObject instanceof IPackageFragment) {
                try {
                    IPackageFragment pf = (IPackageFragment)adaptableObject;
                    if (pf.getKind() == 1) {
                        String path = pf.getElementName().replace('.', '/') + "/";
                        return new CloverExcludable(project, (IJavaElement)pf, path);
                    }
                }
                catch (JavaModelException pf) {
                    // empty catch block
                }
            }
            if (adaptableObject instanceof IPackageFragmentRoot) {
                try {
                    IPackageFragmentRoot pfr = (IPackageFragmentRoot)adaptableObject;
                    if (pfr.getKind() == 1) {
                        return new CloverExcludable(project, (IJavaElement)pfr, "/");
                    }
                }
                catch (JavaModelException pfr) {
                    // empty catch block
                }
            }
            if (adaptableObject instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)adaptableObject;
                String path = cu.getParent().getElementName().replace('.', '/') + '/' + cu.getElementName();
                return new CloverExcludable(project, (IJavaElement)cu, path);
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return ADAPTER_LIST;
    }
}

