/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.openclover.eclipse.core.CloverPlugin;

public final class CloverEclipsePluginMessages {
    private static final String BUNDLE_NAME = "plugin";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("plugin");

    private CloverEclipsePluginMessages() {
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            CloverPlugin.logWarning("Missing string resource: " + key, e);
            return "!" + key + "!";
        }
    }

    public static String getFormattedString(String key, Object arg) {
        Object[] objectArray;
        String format = null;
        try {
            format = RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            CloverPlugin.logWarning("Missing string resource: " + key, e);
            return "!" + key + "!";
        }
        if (arg == null) {
            arg = "";
        }
        Object[] objectArray2 = new Object[1];
        if (arg instanceof Object[]) {
            objectArray = arg;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = arg;
        }
        objectArray2[0] = objectArray;
        return MessageFormat.format(format, objectArray2);
    }

    public static String CLOVER_COPYRIGHT() {
        return CloverEclipsePluginMessages.getString("clover.copyright");
    }

    public static String INITSTRING() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.initstring");
    }

    public static String INITSTRING_BLURB() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.initstringBlurb");
    }

    public static String INITSTRING_AUTOMATIC() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.initstringAutomatic");
    }

    public static String INITSTRING_USER_SPECIFIED() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.initstringUserSpecified");
    }

    public static String INITSTRING_RELATIVE() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.initstringRelative");
    }

    public static String ENABLE_CLOVER_COVERAGE() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.enableCloverCoverage");
    }

    public static String INSTRUMENTATION() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.instrumentation");
    }

    public static String COMPILATION() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.compilation");
    }

    public static String FILTERING() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.filtering");
    }

    public static String FLUSH_POLICY() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.flushPolicy");
    }

    public static String FLUSH_COVERAGE_WHEN() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.flushCoverageWhen");
    }

    public static String FLUSH_POLICY_EXPLANATION() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.flushPolicyExplanation");
    }

    public static String FLUSH_INTERVAL() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.flushInterval");
    }

    public static String FLUSH_POLICY_INTERVAL_MILISECONDS() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.flushPolicy.intervalMiliseconds");
    }

    public static String FLUSH_POLICY_THREADED() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.threadedFlush");
    }

    public static String FLUSH_POLICY_INTERVAL() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.intervalFlush");
    }

    public static String FLUSH_POLICY_DIRECTED() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.directedFlush");
    }

    public static String OUTPUT_DIR() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.outputDir");
    }

    public static String CUSTOM_OUTPUT_ROOT_IS_RELATIVE() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.customOutputRootIsRelative");
    }

    public static String PLACE_IN_PROJECT_DIRS() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.placeInProjectDirs");
    }

    public static String PLACE_IN_USER_DIRS() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.placeInUserDirs");
    }

    public static String QUALIFY_JAVA_LANG() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.qualifyJavaLang");
    }

    public static String METHOD_CONTEXT_FILTER_INSTRUCTIONS() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.methodContextFilterInstructions");
    }

    public static String STATEMENT_CONTEXT_FILTER_INSTRUCTIONS() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.statementContextFilterInstructions");
    }

    public static String WHEN_REBUILDING() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.whenRebuilding");
    }

    public static String LEAVE_COVERAGE() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.leaveOnRebuild");
    }

    public static String CLEAR_COVERAGE() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.clearOnRebuild");
    }

    public static String PROMPT_ME_ON_REBUILD() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.promptOnRebuild");
    }

    public static String WHEN_CONTEXT_CHANGES() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.whenContextChanges");
    }

    public static String REBUILD_ON_CONTEXT_CHANGE() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.rebuildOnContextChange");
    }

    public static String IGNORE_ON_CONTEXT_CHANGE() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.ignoreOnContextChange");
    }

    public static String PROMPT_ME_ON_CONTEXT_CHANGE() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.promptOnContextChange");
    }

    public static String WHEN_INSTRUMENTATION_SOURCE_CHANGES() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.whenInstrumentedSourceChanges");
    }

    public static String INSTRUMENTATION_SOURCE_CHANGED_TITLE() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.rebuildSourceTitle");
    }

    public static String INSTRUMENTATION_SOURCE_CHANGED_QUESTION() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.rebuildSourceQuestion");
    }

    public static String DISPLAY_THIS_PROMPT_AGAIN() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.displayThisPromptAgain");
    }

    public static String PRIME_AWT_IN_UI_THREAD() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.primeAWTInUIThread");
    }

    public static String SHOW_EXCLUSION_ANNOTATIONS() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.showExclusionAnnotations");
    }

    public static String AUTO_REFRESH_COVERAGE_DATA() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.autoRefreshCoverageData");
    }

    public static String AUTO_OPEN_CLOVER_VIEWS() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.autoOpenCloverViews");
    }

    public static String COVERAGE_DATA() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.coverageData");
    }

    public static String TWO_SECONDS() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.twoSeconds");
    }

    public static String FIVE_SECONDS() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.fiveSeconds");
    }

    public static String TEN_SECONDS() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.tenSeconds");
    }

    public static String TWENTY_SECONDS() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.twentySeconds");
    }

    public static String SPAN() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.span");
    }

    public static String SPAN_BLURB() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.spanBlurb");
    }

    public static String MISC_PREFERENCES() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.miscellaneous");
    }

    public static String PRESERVE_INSTRUMENTED_SOURCES() {
        return CloverEclipsePluginMessages.getString("PreferencesPage.preserveInstrumentedSources");
    }

    public static String FILE_FILTERING() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.fileFiltering");
    }

    public static String FILE_FILTERING_ALL_FOLDERS() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.fileFilteringAllFolders");
    }

    public static String FILE_FILTERING_SELECTED_FOLDERS() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.fileFilteringSelectedFolders");
    }

    public static String FILE_FILTERING_INCLUDE() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.fileFilteringInclude");
    }

    public static String FILE_FILTERING_EXCLUDE() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.fileFilteringExclude");
    }

    public static String TEST_FOLDERS() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.testFolders");
    }

    public static String TEST_FOLDERS_ALL() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.testFoldersAll");
    }

    public static String TEST_FOLDERS_SELECTED() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.testFoldersSelected");
    }

    public static String TEST_FOLDERS_NONE() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.testFoldersNone");
    }

    public static String SOURCE_FILES_TAB() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.sourceFilesTab");
    }

    public static String TEST_CLASSES_TAB() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.testClassesTab");
    }

    public static String OUTPUT_FOLDER_GROUP() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.outputFolder.groupTitle");
    }

    public static String OUTPUT_FOLDER_DIALOG_CAPTION() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.outputFolder.folderDialog.caption");
    }

    public static String OUTPUT_FOLDER_RECREATE_ORIGINAL_FOLDERS() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.outputFolder.recreateOriginalFolders");
    }

    public static String OUTPUT_FOLDER_RECREATE_ORIGINAL_FOLDERS_TOOLTIP() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.outputFolder.recreateOriginalFolders.toolTip");
    }

    public static String ERROR_SELECT_WITHIN_PROJECT() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.outputFolder.folderDialog.errorSelectWithinProject");
    }

    public static String ERROR_OUTPUT_FOLDER_HAS_SOURCES() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.errorOutputFolderHasSources");
    }

    public static String ERROR_OUTPUT_FOLDER_HAS_SOURCES(String path, String packageName) {
        return CloverEclipsePluginMessages.getFormattedString("ProjectPropertyPage.errorOutputFolderHasSourcesExt", new Object[]{path, packageName});
    }

    public static String ERROR_UNEXPECTED_WHILE_APPLY_PROPERTIES() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.errorUnexpectedWhileApplyProperties");
    }

    public static String ERROR_CUSTOM_INITSTRING_NOT_EMPTY() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.errorCustomInitStringNotEmpty");
    }

    public static String ERROR_FLUSH_INTERVAL_NOT_POSITIVE() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.errorFlushIntervalNotPositive");
    }

    public static String ERROR_FLUSH_INTERVAL_NOT_A_NUMBER() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.errorFlushIntervalNotANumber");
    }

    public static String ERROR_OUTPUT_DIR_NAME_IS_NULL() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.errorOutputDirNameIsNull");
    }

    public static String ERROR_UNEXPECTED_WHILE_CUSTOM_OUTPUT_DIR() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.errorUnexpectedWhileCustomOutputDir");
    }

    public static String CONTEXT_FILTERING() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.contextFiltering");
    }

    public static String CONTEXT_FILTERING_BLURB() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.contextFilteringBlurb");
    }

    public static String MISC_INSTRUMENTATION() {
        return CloverEclipsePluginMessages.getString("ProjectPropertyPage.miscellaneousInstrumentationSettings");
    }

    public static String NOT_COVERED() {
        return CloverEclipsePluginMessages.getString("CoverageAnnotation.notCovered");
    }

    public static String COVERED() {
        return CloverEclipsePluginMessages.getString("CoverageAnnotation.covered");
    }

    public static String COVERAGE_ELEMENT_COL() {
        return CloverEclipsePluginMessages.getString("CoverageView.elementColumn");
    }

    public static String COVERAGE_ELEMENT_ABBREVIATED_COL() {
        return CloverEclipsePluginMessages.getString("CoverageView.elementAbbreviatedColumn");
    }

    public static String COVERAGE_ELEMENT_COL_TOOL_TIP() {
        return CloverEclipsePluginMessages.getString("CoverageView.elementColumnToolTip");
    }

    public static String COVERAGE_COL() {
        return CloverEclipsePluginMessages.getString("CoverageView.coverageColumn");
    }

    public static String COVERAGE_COL_TOOL_TIP() {
        return CloverEclipsePluginMessages.getString("CoverageView.coverageColumnToolTip");
    }

    public static String AVG_METH_COMPLEXITY_COL() {
        return CloverEclipsePluginMessages.getString("CoverageView.avgMethComplexityColumn");
    }

    public static String AVG_METH_COMPLEXITY_COL_TOOL_TIP() {
        return CloverEclipsePluginMessages.getString("CoverageView.avgMethComplexityColumnToolTip");
    }

    public static String TOTAL_COMPLEXITY_COL() {
        return CloverEclipsePluginMessages.getString("CoverageView.totalComplexityColumn");
    }

    public static String TOTAL_COMPLEXITY_COL_TOOL_TIP() {
        return CloverEclipsePluginMessages.getString("CoverageView.totalComplexityColumnToolTip");
    }

    public static String TEST_COL() {
        return CloverEclipsePluginMessages.getString("TestRunExplorerView.testColumn");
    }

    public static String TEST_ABBREVIATED_COL() {
        return CloverEclipsePluginMessages.getString("TestRunExplorerView.testAbbreviatedColumn");
    }

    public static String TESTT_TOOL_TIP() {
        return CloverEclipsePluginMessages.getString("TestRunExplorerView.testColumnToolTip");
    }

    public static String TEST_STARTED_COL() {
        return CloverEclipsePluginMessages.getString("TestRunExplorerView.startedColumn");
    }

    public static String TEST_STARTED_ABBREVIATED_COL() {
        return CloverEclipsePluginMessages.getString("TestRunExplorerView.startedAbbreviatedColumn");
    }

    public static String TEST_STARTED_COL_TOOL_TIP() {
        return CloverEclipsePluginMessages.getString("TestRunExplorerView.startedColumnToolTip");
    }

    public static String TEST_STATUS_COL() {
        return CloverEclipsePluginMessages.getString("TestRunExplorerView.statusColumn");
    }

    public static String TEST_STATUS_ABBREVIATED_COL() {
        return CloverEclipsePluginMessages.getString("TestRunExplorerView.statusAbbreviatedColumn");
    }

    public static String TEST_STATUS_COL_TOOL_TIP() {
        return CloverEclipsePluginMessages.getString("TestRunExplorerView.statusColumnToolTip");
    }

    public static String TEST_TIME_COL() {
        return CloverEclipsePluginMessages.getString("TestRunExplorerView.timeColumn");
    }

    public static String TEST_TIME_ABBREVIATED_COL() {
        return CloverEclipsePluginMessages.getString("TestRunExplorerView.timeAbbreviatedColumn");
    }

    public static String TEST_TIME_COL_TOOL_TIP() {
        return CloverEclipsePluginMessages.getString("TestRunExplorerView.timeColumnToolTip");
    }

    public static String TEST_MESSAGE_COL() {
        return CloverEclipsePluginMessages.getString("TestRunExplorerView.messageColumn");
    }

    public static String TEST_MESSAGE_ABBREVIATED_COL() {
        return CloverEclipsePluginMessages.getString("TestRunExplorerView.messageAbbreviatedColumn");
    }

    public static String TEST_MESSAGE_COL_TOOL_TIP() {
        return CloverEclipsePluginMessages.getString("TestRunExplorerView.messageColumnToolTip");
    }

    public static String METRICS_SUMMARY() {
        return CloverEclipsePluginMessages.getString("CoverageView.metricsSummaryDetails");
    }

    public static String LOADING_DECORATION(String label) {
        return CloverEclipsePluginMessages.getFormattedString("CoverageView.loadingDecoration", label);
    }

    public static String PROJECT_RISKS() {
        return CloverEclipsePluginMessages.getString("CloudEditor.projectRisks");
    }

    public static String PACKAGE_RISKS() {
        return CloverEclipsePluginMessages.getString("CloudEditor.packageRisks");
    }

    public static String QUICK_WINS() {
        return CloverEclipsePluginMessages.getString("CloudEditor.quickWins");
    }

    public static String SHOW_AGGREGATE_CLOUD() {
        return CloverEclipsePluginMessages.getString("CloudEditor.showAggregateCloud");
    }

    public static String FAILED_TO_GENERATE_CLOUD() {
        return CloverEclipsePluginMessages.getString("OpenCloudAction.failedToGenerateCloud");
    }

    public static String FAILED_TO_OPEN_CLOUD_EDITOR() {
        return CloverEclipsePluginMessages.getString("OpenCloudAction.failedToOpenCloudEditor");
    }

    public static String GENERATING_CLOUD_FOR(String projectName) {
        return CloverEclipsePluginMessages.getFormattedString("OpenCloudAction.generatingCloudForProject", projectName);
    }

    public static String REFRESH_CLOUD() {
        return CloverEclipsePluginMessages.getString("RefreshCloudAction.refreshCloud");
    }

    public static String REFRESH_CLOUD_BUTTON() {
        return CloverEclipsePluginMessages.getString("RefreshCloudAction.refresh");
    }

    public static String REFRESH_CLOUD_TOOL_TIP() {
        return CloverEclipsePluginMessages.getString("RefreshCloudAction.refreshCloudToolTip");
    }

    public static String CLOVER_WORKING_SET() {
        return CloverEclipsePluginMessages.getString("CloverWorkingSet.title");
    }

    public static String HIERARCHY_LAYOUT() {
        return CloverEclipsePluginMessages.getString("CoverageView.hierarchyStyleMenuTitle");
    }

    public static String BLOCK_CONTEXT_FILTER_INSTRUCTIONS() {
        return CloverEclipsePluginMessages.getString("Contexts.blockContextFilterInstructions");
    }

    public static String REGEXP_CONTEXT_FILTER_MODIFICATION_INSTRUCTIONS() {
        return CloverEclipsePluginMessages.getString("Contexts.regexpContextFilterModificationInstructions");
    }

    public static String REGEXP_CONTEXT_FILTER_SELECTION_INSTRUCTIONS() {
        return CloverEclipsePluginMessages.getString("Contexts.regexpContextFilterSelectionInstructions");
    }

    public static String RESERVED_BLOCK_CONTEXT(String name) {
        return CloverEclipsePluginMessages.getString("Contexts.block." + name);
    }

    public static String RESERVED_REGEX_CONTEXT(String name) {
        return CloverEclipsePluginMessages.getString("Contexts.regex." + name);
    }

    public static String LAUNCH_TOOLBAR_LAST_CLOVERED_NAME() {
        return CloverEclipsePluginMessages.getString("launch.toolbar.last.clovered.name");
    }

    public static String LAUNCH_TOOLBAR_LAST_CLOVERED_DESCRIPTION() {
        return CloverEclipsePluginMessages.getString("launch.commands.last.clovered.description");
    }

    public static String REPORT_SHOW_IN_BROWSER() {
        return CloverEclipsePluginMessages.getString("Report.showInBrowser");
    }

    public static String SYSTEM_BROWSER() {
        return CloverEclipsePluginMessages.getString("Report.systemBrowser");
    }

    public static String ECLIPSE_BROWSER() {
        return CloverEclipsePluginMessages.getString("Report.eclipseBrowser");
    }

    public static String ECLIPSE_VIEWER(String name) {
        return CloverEclipsePluginMessages.getFormattedString("Report.eclipseViewer", name);
    }

    public static String SYSTEM_PDF_VIEWER() {
        return CloverEclipsePluginMessages.getString("Report.systemPDFViewer");
    }

    public static String SYSTEM_XML_VIEWER() {
        return CloverEclipsePluginMessages.getString("Report.systemXMLViewer");
    }

    public static String ECLIPSE_XML_TEXT_VIEWER() {
        return CloverEclipsePluginMessages.getString("Report.eclipseXMLTextViewer");
    }

    public static String REPORT_MESSAGEBOX_TITLE(String title) {
        return CloverEclipsePluginMessages.getFormattedString("Report.messageBoxTitle", title);
    }

    public static String REPORT_OPEN_IN() {
        return CloverEclipsePluginMessages.getString("Report.openReportIn");
    }

    public static String REPORT_SUCCESS_MESSAGE() {
        return CloverEclipsePluginMessages.getString("Report.successMessage");
    }

    public static String REPORT_CANCEL_MESSAGE() {
        return CloverEclipsePluginMessages.getString("Report.cancelMessage");
    }

    public static String PROJECT_REPORT() {
        return CloverEclipsePluginMessages.getString("project.report");
    }

    public static String PROJECT_REPORT_TOOL_TIP() {
        return CloverEclipsePluginMessages.getString("project.reporttooltip");
    }

    public static String PROJECT_GENERATE_REPORT() {
        return CloverEclipsePluginMessages.getString("project.generatereport");
    }

    public static String PROJECT_VIEW_REPORT() {
        return CloverEclipsePluginMessages.getString("project.viewreport");
    }

    public static String MARKERS_STALE_DB() {
        return CloverEclipsePluginMessages.MARKERS_STALE_DB("");
    }

    public static String MARKERS_STALE_DB(String message) {
        return CloverEclipsePluginMessages.getFormattedString("markers.staledb", message);
    }

    public static String MARKERS_ERROR_LOADING_DB(String message) {
        return CloverEclipsePluginMessages.getFormattedString("markers.errorloadingdb", message);
    }

    public static String MARKERS_ERROR_REMOVING_DB(String path) {
        return CloverEclipsePluginMessages.getFormattedString("markers.errorremovingdb", path);
    }
}

