/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jtreemap.ktreemap;

import java.util.ArrayList;
import java.util.List;
import net.sf.jtreemap.ktreemap.SplitBySlice;
import net.sf.jtreemap.ktreemap.SplitStrategy;
import net.sf.jtreemap.ktreemap.TreeMapNode;
import org.eclipse.swt.graphics.Rectangle;

public class SplitSquarified
extends SplitStrategy {
    private int w1;
    private int h1;
    private int x;
    private int y;
    private int w;
    private int h;
    private int x2;
    private int y2;
    private int w2;
    private int h2;

    @Override
    public void splitElements(List<TreeMapNode> list, List<TreeMapNode> group1, List<TreeMapNode> group2) {
        double a;
        int mid = 0;
        double weight0 = this.sumWeight(list);
        double b = a = list.get(mid).getWeight() / weight0;
        if (this.w < this.h) {
            int i;
            while (mid < list.size()) {
                double aspect = this.normAspect(this.h, this.w, a, b);
                double q = list.get(mid).getWeight() / weight0;
                if (this.normAspect(this.h, this.w, a, b + q) > aspect) break;
                ++mid;
                b += q;
            }
            for (i = 0; i <= mid && i < list.size(); ++i) {
                group1.add(list.get(i));
            }
            while (i < list.size()) {
                group2.add(list.get(i));
                ++i;
            }
            this.h1 = (int)Math.round((double)this.h * b);
            this.w1 = this.w;
            this.x2 = this.x;
            this.y2 = (int)Math.round((double)this.y + (double)this.h * b);
            this.w2 = this.w;
            this.h2 = this.h - this.h1;
        } else {
            int i;
            while (mid < list.size()) {
                double aspect = this.normAspect(this.w, this.h, a, b);
                double q = list.get(mid).getWeight() / weight0;
                if (this.normAspect(this.w, this.h, a, b + q) > aspect) break;
                ++mid;
                b += q;
            }
            for (i = 0; i <= mid && i < list.size(); ++i) {
                group1.add(list.get(i));
            }
            while (i < list.size()) {
                group2.add(list.get(i));
                ++i;
            }
            this.h1 = this.h;
            this.w1 = (int)Math.round((double)this.w * b);
            this.x2 = (int)Math.round((double)this.x + (double)this.w * b);
            this.y2 = this.y;
            this.w2 = this.w - this.w1;
            this.h2 = this.h;
        }
    }

    @Override
    protected void calculatePositionsRec(Rectangle bounds, double weight0, List<TreeMapNode> children) {
        ArrayList<TreeMapNode> listClone = new ArrayList<TreeMapNode>(children);
        this.sortList(listClone);
        if (listClone.size() <= 2) {
            SplitBySlice.splitInSlice(bounds, listClone, this.sumWeight(listClone));
            this.calculateChildren(listClone);
        } else {
            ArrayList<TreeMapNode> l1 = new ArrayList<TreeMapNode>();
            ArrayList<TreeMapNode> l2 = new ArrayList<TreeMapNode>();
            this.x = bounds.x;
            this.y = bounds.y;
            this.w = bounds.width;
            this.h = bounds.height;
            this.splitElements(listClone, l1, l2);
            int x2 = this.x2;
            int y2 = this.y2;
            int w2 = this.w2;
            int h2 = this.h2;
            Rectangle bounds1 = new Rectangle(bounds.x, bounds.y, this.w1, this.h1);
            SplitBySlice.splitInSlice(bounds1, l1, this.sumWeight(l1));
            this.calculateChildren(l1);
            Rectangle bounds2 = new Rectangle(x2, y2, w2, h2);
            this.calculatePositionsRec(bounds2, this.sumWeight(l2), l2);
        }
    }

    private double aspect(double big, double small, double a, double b) {
        return big * b / (small * a / b);
    }

    private void calculateChildren(List<TreeMapNode> v) {
        for (TreeMapNode node : v) {
            int h;
            if (node.isLeaf()) {
                int h2;
                node.setX(node.getX() + TreeMapNode.getBorder());
                node.setY(node.getY() + TreeMapNode.getBorder());
                int w = node.getWidth() - TreeMapNode.getBorder();
                if (w < 0) {
                    w = 0;
                }
                if ((h2 = node.getHeight() - TreeMapNode.getBorder()) < 0) {
                    h2 = 0;
                }
                node.setHeight(h2);
                node.setWidth(w);
                continue;
            }
            int bSub = TreeMapNode.getBorder() > 1 ? 2 : (TreeMapNode.getBorder() == 1 ? 1 : 0);
            int w = node.getWidth() - bSub;
            if (w < 0) {
                w = 0;
            }
            if ((h = node.getHeight() - bSub) < 0) {
                h = 0;
            }
            TreeMapNode.setBorder(TreeMapNode.getBorder() - bSub);
            Rectangle newBounds = new Rectangle(node.getX() + bSub, node.getY() + bSub, w, h);
            this.calculatePositionsRec(newBounds, node.getWeight(), node.getChildren());
            TreeMapNode.setBorder(TreeMapNode.getBorder() + bSub);
        }
    }

    private double normAspect(double big, double small, double a, double b) {
        double x = this.aspect(big, small, a, b);
        if (x < 1.0) {
            return 1.0 / x;
        }
        return x;
    }
}

