/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jtreemap.ktreemap;

import java.util.List;
import net.sf.jtreemap.ktreemap.SplitStrategy;
import net.sf.jtreemap.ktreemap.TreeMapNode;
import org.eclipse.swt.graphics.Rectangle;

public class SplitBySlice
extends SplitStrategy {
    public static void splitInSlice(Rectangle bounds, List<TreeMapNode> children, double sumWeight) {
        int offset = 0;
        boolean vertical = bounds.height > bounds.width;
        for (TreeMapNode node : children) {
            if (vertical) {
                node.setX(bounds.x);
                node.setWidth(bounds.width);
                node.setY(bounds.y + offset);
                node.setHeight((int)Math.round((double)bounds.height * node.getWeight() / sumWeight));
                offset += node.getHeight();
                continue;
            }
            node.setX(bounds.x + offset);
            node.setWidth((int)Math.round((double)bounds.width * node.getWeight() / sumWeight));
            node.setY(bounds.y);
            node.setHeight(bounds.height);
            offset += node.getWidth();
        }
        if (!children.isEmpty()) {
            TreeMapNode node = children.get(children.size() - 1);
            if (vertical && bounds.height != offset) {
                node.setHeight(node.getHeight() - offset + bounds.height);
            } else if (!vertical && bounds.width != offset) {
                node.setWidth(node.getWidth() - offset + bounds.width);
            }
        }
    }

    @Override
    public void splitElements(List<TreeMapNode> v, List<TreeMapNode> v1, List<TreeMapNode> v2) {
    }

    @Override
    protected void calculatePositionsRec(Rectangle bounds, double weight0, List<TreeMapNode> v) {
        SplitBySlice.splitInSlice(bounds, v, weight0);
        for (TreeMapNode node : v) {
            Rectangle newBounds;
            if (node.isLeaf()) {
                node.setX(node.getX() + TreeMapNode.getBorder());
                node.setY(node.getY() + TreeMapNode.getBorder());
                node.setHeight(node.getHeight() - TreeMapNode.getBorder());
                node.setWidth(node.getWidth() - TreeMapNode.getBorder());
                continue;
            }
            if (TreeMapNode.getBorder() > 1) {
                TreeMapNode.setBorder(TreeMapNode.getBorder() - 2);
                newBounds = new Rectangle(node.getX() + 2, node.getY() + 2, node.getWidth() - 2, node.getHeight() - 2);
                this.calculatePositionsRec(newBounds, node.getWeight(), node.getChildren());
                TreeMapNode.setBorder(TreeMapNode.getBorder() + 2);
                continue;
            }
            if (TreeMapNode.getBorder() == 1) {
                TreeMapNode.setBorder(0);
                newBounds = new Rectangle(node.getX() + 1, node.getY() + 1, node.getWidth() - 1, node.getHeight() - 1);
                this.calculatePositionsRec(newBounds, node.getWeight(), node.getChildren());
                TreeMapNode.setBorder(1);
                continue;
            }
            this.calculatePositionsRec(node.getBounds(), node.getWeight(), node.getChildren());
        }
    }
}

