/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jtreemap.ktreemap;

import net.sf.jtreemap.ktreemap.ITreeMapColorProvider;
import net.sf.jtreemap.ktreemap.ITreeMapProvider;
import net.sf.jtreemap.ktreemap.SplitSquarified;
import net.sf.jtreemap.ktreemap.SplitStrategy;
import net.sf.jtreemap.ktreemap.TreeMapNode;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class KTreeMap
extends Canvas {
    private static final long serialVersionUID = 7255952672238300249L;
    private Color revealColor = null;
    private TreeMapNode activeLeaf = null;
    private ITreeMapColorProvider colorProvider = null;
    private ITreeMapProvider treeMapProvider = null;
    private TreeMapNode displayedRoot = null;
    private TreeMapNode root = null;
    private SplitStrategy strategy = null;
    private Zoom zoom;
    private Point cursorPosition = new Point(0, 0);

    public KTreeMap(Composite parent, int style, TreeMapNode root) {
        this(parent, style, root, new SplitSquarified());
    }

    public KTreeMap(Composite parent, int style, TreeMapNode root, SplitStrategy strategy) {
        super(parent, style);
        this.zoom = new Zoom();
        this.setRoot(root);
        this.setStrategy(strategy);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                KTreeMap.this.paintControl(e);
            }
        });
        this.addMouseMoveListener(new HandleMouseMotion());
    }

    public void calculatePositions() {
        if (this.getStrategy() != null && this.displayedRoot != null) {
            this.getStrategy().calculatePositions(this.displayedRoot);
        }
    }

    public void dispose() {
        if (this.revealColor != null) {
            this.revealColor.dispose();
        }
        super.dispose();
    }

    public TreeMapNode getActiveLeaf() {
        return this.activeLeaf;
    }

    public ITreeMapColorProvider getColorProvider() {
        return this.colorProvider;
    }

    public Point getCursorPosition() {
        return this.cursorPosition;
    }

    public TreeMapNode getDisplayedRoot() {
        return this.displayedRoot;
    }

    public TreeMapNode getRoot() {
        return this.root;
    }

    public SplitStrategy getStrategy() {
        return this.strategy;
    }

    public ITreeMapProvider getTreeMapProvider() {
        return this.treeMapProvider;
    }

    public void setActiveLeaf(TreeMapNode newActiveLeaf) {
        if (newActiveLeaf == null || newActiveLeaf.isLeaf()) {
            this.activeLeaf = newActiveLeaf;
        }
    }

    public void setColorProvider(ITreeMapColorProvider colorProvider) {
        this.colorProvider = colorProvider;
        this.redraw();
    }

    public void setDisplayedRoot(TreeMapNode newDisplayedRoot) {
        this.displayedRoot = newDisplayedRoot;
        this.redraw();
    }

    public void setRoot(TreeMapNode newRoot) {
        this.root = newRoot;
        int insets = this.getBorderWidth();
        this.root.setX(insets);
        this.root.setY(insets);
        this.setDisplayedRoot(this.root);
    }

    public void setStrategy(SplitStrategy newStrat) {
        this.strategy = newStrat;
        this.redraw();
    }

    public void setTreeMapProvider(ITreeMapProvider newColorProvider) {
        this.treeMapProvider = newColorProvider;
        this.redraw();
    }

    public void setZoomKeepProportion(boolean keepProportion) {
        this.zoom.setKeepProportion(keepProportion);
    }

    public void unzoom() {
        this.zoom.undo();
    }

    public void zoom(TreeMapNode dest) {
        this.unzoom();
        this.zoom.execute(dest);
    }

    void paintControl(PaintEvent e) {
        GC gc = e.gc;
        int width = this.getBounds().width;
        int height = this.getBounds().height;
        int insets = this.getBorderWidth();
        int border = TreeMapNode.getBorder();
        this.root.setBounds(new Rectangle(this.root.getX(), this.root.getY(), width - border - insets - insets, height - border - insets - insets));
        if (!this.root.equals(this.displayedRoot)) {
            this.displayedRoot.setBounds(new Rectangle(this.displayedRoot.getX(), this.displayedRoot.getY(), width - border - insets - insets, height - border - insets - insets));
        }
        this.calculatePositions();
        if (!this.displayedRoot.getChildren().isEmpty()) {
            gc.setBackground(this.getBackground());
            gc.fillRectangle(this.displayedRoot.getX(), this.displayedRoot.getY(), this.displayedRoot.getWidth() + border, this.displayedRoot.getHeight() + border);
            this.draw(gc, this.displayedRoot);
            if (this.activeLeaf != null) {
                this.reveal(gc, this.activeLeaf);
            }
            this.drawLabels(gc, this.displayedRoot);
        }
    }

    protected void draw(GC gc, TreeMapNode item) {
        if (item.isLeaf()) {
            gc.setBackground(this.getColorProvider().getBackground(item.getValue()));
            gc.fillRectangle(item.getBounds());
        } else {
            for (TreeMapNode node : item.getChildren()) {
                this.draw(gc, node);
            }
        }
    }

    protected void drawLabel(GC gc, TreeMapNode item) {
        FontMetrics fm = gc.getFontMetrics();
        if (fm.getHeight() < item.getHeight() - 2) {
            String label = this.getTreeMapProvider().getLabel(item);
            int y = (item.getHeight() - fm.getAscent() - fm.getLeading() + fm.getDescent()) / 2;
            int stringWidth = fm.getAverageCharWidth() * label.length();
            if (item.getWidth() - 5 <= stringWidth) {
                int nbChar = label.length() * item.getWidth() / stringWidth;
                if (nbChar > 3) {
                    label = label.substring(0, nbChar - 3) + "...";
                    stringWidth = (nbChar - 1) * fm.getAverageCharWidth();
                } else {
                    return;
                }
            }
            int x = (item.getWidth() - stringWidth) / 2;
            gc.setForeground(Display.getDefault().getSystemColor(2));
            gc.drawString(label, item.getX() + x + 1, item.getY() + y + 1, true);
            gc.drawString(label, item.getX() + x - 1, item.getY() + y + 1, true);
            gc.drawString(label, item.getX() + x + 1, item.getY() + y - 1, true);
            gc.drawString(label, item.getX() + x - 1, item.getY() + y - 1, true);
            gc.drawString(label, item.getX() + x + 1, item.getY() + y, true);
            gc.drawString(label, item.getX() + x - 1, item.getY() + y, true);
            gc.drawString(label, item.getX() + x, item.getY() + y + 1, true);
            gc.drawString(label, item.getX() + x, item.getY() + y - 1, true);
            gc.setForeground(this.getColorProvider().getForeground(item));
            gc.drawString(label, item.getX() + x, item.getY() + y, true);
        }
    }

    protected void drawLabels(GC gc, TreeMapNode item) {
        gc.setFont(this.getFont());
        if (this.displayedRoot.isLeaf()) {
            this.drawLabel(gc, this.displayedRoot);
        } else {
            for (TreeMapNode node : this.displayedRoot.getChildren()) {
                this.drawLabel(gc, node);
            }
        }
    }

    protected void reveal(GC gc, TreeMapNode item) {
        if (item.isLeaf()) {
            if (this.revealColor != null) {
                this.revealColor.dispose();
            }
            Color itemColor = this.colorProvider.getBackground(item.getValue());
            RGB rgb = itemColor.getRGB();
            float[] fs = new RGB(rgb.red, rgb.green, rgb.blue).getHSB();
            RGB rgbVal = new RGB(fs[0], fs[1] / 2.0f, (fs[2] + 1.0f) / 2.0f);
            this.revealColor = new Color((Device)this.getDisplay(), rgbVal.red, rgbVal.green, rgbVal.blue);
            gc.setBackground(this.revealColor);
            gc.fillRectangle(item.getX(), item.getY(), item.getWidth(), item.getHeight());
        }
    }

    private class Zoom {
        private boolean enable = true;
        private boolean keepProportion = false;

        public void execute(TreeMapNode dest) {
            if (this.enable) {
                KTreeMap.this.setActiveLeaf(null);
                this.setNewDimension(dest);
                KTreeMap.this.setDisplayedRoot(dest);
                this.enable = false;
            }
        }

        public boolean isKeepProportion() {
            return this.keepProportion;
        }

        public void setKeepProportion(boolean keepProportion) {
            this.keepProportion = keepProportion;
        }

        public void undo() {
            if (!this.enable) {
                KTreeMap.this.setDisplayedRoot(KTreeMap.this.getRoot());
                this.enable = true;
            }
        }

        protected void setNewDimension(TreeMapNode dest) {
            dest.setX(KTreeMap.this.getRoot().getX());
            dest.setY(KTreeMap.this.getRoot().getY());
            int rootWidth = KTreeMap.this.getRoot().getWidth();
            int rootHeight = KTreeMap.this.getRoot().getHeight();
            if (this.isKeepProportion()) {
                float divHeight;
                int destHeight = dest.getHeight();
                int destWidth = dest.getWidth();
                float divWidth = (float)destWidth / (float)rootWidth;
                if (divWidth >= (divHeight = (float)destHeight / (float)rootHeight)) {
                    dest.setHeight(Math.round((float)destHeight / divWidth));
                    dest.setWidth(rootWidth);
                } else {
                    dest.setHeight(rootHeight);
                    dest.setWidth(Math.round((float)destWidth / divHeight));
                }
            } else {
                dest.setHeight(rootHeight);
                dest.setWidth(rootWidth);
            }
        }
    }

    protected class HandleMouseMotion
    implements MouseMoveListener {
        protected HandleMouseMotion() {
        }

        public void mouseMove(MouseEvent e) {
            ((KTreeMap)KTreeMap.this).cursorPosition.x = e.x;
            ((KTreeMap)KTreeMap.this).cursorPosition.y = e.y;
            if (!KTreeMap.this.getDisplayedRoot().getChildren().isEmpty()) {
                Rectangle bounds;
                TreeMapNode t = KTreeMap.this.getDisplayedRoot().getActiveLeaf(e.x, e.y);
                TreeMapNode oldActiveLeaf = KTreeMap.this.getActiveLeaf();
                if (oldActiveLeaf != null && !oldActiveLeaf.equals(t)) {
                    bounds = oldActiveLeaf.getBounds();
                    KTreeMap.this.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
                }
                KTreeMap.this.setActiveLeaf(t);
                if (t != null && !t.equals(oldActiveLeaf)) {
                    bounds = t.getBounds();
                    KTreeMap.this.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
                }
                if (t != null) {
                    String label = KTreeMap.this.getTreeMapProvider().getLabel(t);
                    String valueLabel = KTreeMap.this.getTreeMapProvider().getValueLabel(t.getValue());
                    KTreeMap.this.setToolTipText(label + "\n" + valueLabel);
                } else {
                    KTreeMap.this.setToolTipText(null);
                }
            }
        }
    }
}

